/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.map.SubspaceSplitter;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TextSubspaceSplitter
implements SubspaceSplitter<Tuple> {
    @Nonnull
    private final Subspace indexSubspace;
    private final int groupingColumns;

    public TextSubspaceSplitter(@Nonnull Subspace indexSubspace, int groupingColumns) {
        this.indexSubspace = indexSubspace;
        this.groupingColumns = groupingColumns;
    }

    @Override
    @Nonnull
    public Subspace subspaceOf(@Nonnull byte[] keyBytes) {
        Tuple t2 = this.indexSubspace.unpack(keyBytes);
        return this.indexSubspace.subspace(TupleHelpers.subTuple(t2, 0, this.groupingColumns));
    }

    @Override
    @Nullable
    public Tuple subspaceTag(@Nonnull Subspace subspace) {
        return this.indexSubspace.unpack(subspace.getKey());
    }
}

