/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.cursors.ConcatCursor;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.provider.foundationdb.indexes.InvalidIndexEntry;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.ValueIndexScrubbingToolsDangling;
import com.apple.foundationdb.record.provider.foundationdb.indexes.ValueIndexScrubbingToolsMissing;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ValueIndexMaintainer
extends StandardIndexMaintainer {
    public ValueIndexMaintainer(IndexMaintainerState state) {
        super(state);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!scanType.equals(IndexScanType.BY_VALUE)) {
            throw new RecordCoreException("Can only scan standard index by value.", new Object[0]);
        }
        return this.scan(range, continuation, scanProperties);
    }

    @Override
    @Nonnull
    public RecordCursor<InvalidIndexEntry> validateEntries(@Nullable byte[] continuation, @Nullable ScanProperties scanProperties) {
        if (scanProperties == null) {
            scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(Integer.MAX_VALUE).setIsolationLevel(IsolationLevel.SNAPSHOT).build());
        }
        return new ConcatCursor<InvalidIndexEntry>(this.state.context, scanProperties, (context, scanProperties1, continuation1) -> this.validateOrphanEntries((byte[])continuation1, (ScanProperties)scanProperties1), (context, scanProperties2, continuation2) -> this.validateMissingEntries((byte[])continuation2, (ScanProperties)scanProperties2), continuation);
    }

    @Override
    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        return ("min".equals(function.getName()) || "max".equals(function.getName())) && ValueIndexMaintainer.ungroupedAggregateOperand(function.getOperand()).isPrefixKey(this.state.index.getRootExpression());
    }

    protected static KeyExpression ungroupedAggregateOperand(@Nonnull KeyExpression key) {
        if (key instanceof GroupingKeyExpression) {
            return ((GroupingKeyExpression)key).getWholeKey();
        }
        return key;
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        boolean reverse;
        if ("min".equals(function.getName())) {
            reverse = false;
        } else if ("max".equals(function.getName())) {
            reverse = true;
        } else {
            throw new MetaDataException("do not index aggregate function: " + String.valueOf(function), new Object[0]);
        }
        int totalSize = function.getOperand().getColumnSize();
        int groupSize = totalSize - (function.getOperand() instanceof GroupingKeyExpression ? ((GroupingKeyExpression)function.getOperand()).getGroupedCount() : 1);
        return this.scan(IndexScanType.BY_VALUE, range, null, new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(1).setIsolationLevel(isolationLevel).build(), reverse)).first().thenApply(kvo -> kvo.map(kv -> TupleHelpers.subTuple(kv.getKey(), groupSize, totalSize)).orElse(null));
    }

    @Override
    @Nonnull
    public RecordCursor<FDBIndexedRawRecord> scanRemoteFetch(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, int commonPrimaryKeyLength) {
        return this.scanRemoteFetchByValue(scanBounds, continuation, scanProperties, commonPrimaryKeyLength);
    }

    @Override
    @Nullable
    public IndexScrubbingTools<?> getIndexScrubbingTools(IndexScrubbingTools.ScrubbingType type) {
        switch (type) {
            case MISSING: {
                return new ValueIndexScrubbingToolsMissing();
            }
            case DANGLING: {
                return new ValueIndexScrubbingToolsDangling();
            }
        }
        return null;
    }
}

