/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.NestedRecordType;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class ValueIndexScrubbingToolsDangling
implements IndexScrubbingTools<IndexEntry> {
    private Index index = null;
    private boolean allowRepair;
    private boolean isSynthetic;

    @Override
    public void presetCommonParams(Index index, boolean allowRepair, boolean isSynthetic, Collection<RecordType> typesIgnored) {
        if (isSynthetic && allowRepair) {
            throw new UnsupportedOperationException("Scrubbing synthetic records with repair is not supported");
        }
        this.index = index;
        this.allowRepair = allowRepair;
        this.isSynthetic = isSynthetic;
    }

    @Override
    public RecordCursor<IndexEntry> getCursor(TupleRange range, FDBRecordStore store, int limit) {
        IsolationLevel isolationLevel = IsolationLevel.SNAPSHOT;
        ExecuteProperties.Builder executeProperties = ExecuteProperties.newBuilder().setIsolationLevel(isolationLevel).setReturnedRowLimit(limit);
        ScanProperties scanProperties = new ScanProperties(executeProperties.build(), false);
        return store.scanIndex(this.index, IndexScanType.BY_VALUE, range, null, scanProperties);
    }

    @Override
    public Tuple getKeyFromCursorResult(RecordCursorResult<IndexEntry> result) {
        IndexEntry indexEntry = result.get();
        return indexEntry == null ? null : indexEntry.getKey();
    }

    @Override
    public CompletableFuture<IndexScrubbingTools.Issue> handleOneItem(FDBRecordStore store, RecordCursorResult<IndexEntry> result) {
        if (this.index == null) {
            throw new IllegalStateException("presetParams was not called appropriately for this scrubbing tool");
        }
        IndexEntry indexEntry = result.get();
        if (indexEntry == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.isSynthetic) {
            return store.loadSyntheticRecord(indexEntry.getPrimaryKey(), IndexOrphanBehavior.RETURN).thenApply(syntheticRecord -> {
                if (syntheticRecord.getConstituents().isEmpty()) {
                    ArrayList<Tuple> primaryKeysForConflict = new ArrayList<Tuple>(indexEntry.getPrimaryKey().size() - 1);
                    SyntheticRecordType<?> syntheticRecordType = store.getRecordMetaData().getSyntheticRecordTypeFromRecordTypeKey(indexEntry.getPrimaryKey().get(0));
                    for (int i = 0; i < syntheticRecordType.getConstituents().size(); ++i) {
                        if (((SyntheticRecordType.Constituent)syntheticRecordType.getConstituents().get(i)).getRecordType() instanceof NestedRecordType || indexEntry.getPrimaryKey().get(i + 1) == null) continue;
                        primaryKeysForConflict.add(indexEntry.getPrimaryKey().getNestedTuple(i + 1));
                    }
                    return this.scrubDanglingEntry(store, indexEntry, primaryKeysForConflict);
                }
                return null;
            });
        }
        return store.loadIndexEntryRecord(indexEntry, IndexOrphanBehavior.RETURN).thenApply(indexedRecord -> {
            if (!indexedRecord.hasStoredRecord()) {
                return this.scrubDanglingEntry(store, indexEntry, List.of(indexEntry.getPrimaryKey()));
            }
            return null;
        });
    }

    private IndexScrubbingTools.Issue scrubDanglingEntry(@Nonnull FDBRecordStore store, @Nonnull IndexEntry indexEntry, @Nonnull List<Tuple> conflictPrimaryKeys) {
        Tuple valueKey = indexEntry.getKey();
        if (this.allowRepair) {
            for (Tuple primaryKey : conflictPrimaryKeys) {
                store.addRecordReadConflict(primaryKey);
            }
            byte[] keyBytes = store.indexSubspace(this.index).pack(valueKey);
            store.getContext().ensureActive().clear(keyBytes);
        }
        return new IndexScrubbingTools.Issue(KeyValueLogMessage.build("Scrubber: dangling index entry", new Object[]{LogMessageKeys.KEY, valueKey, LogMessageKeys.PRIMARY_KEY, indexEntry.getPrimaryKey()}), FDBStoreTimer.Counts.INDEX_SCRUBBER_DANGLING_ENTRIES, null);
    }
}

