/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlanner;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValueIndexScrubbingToolsMissing
implements IndexScrubbingTools<FDBStoredRecord<Message>> {
    private Collection<RecordType> recordTypes = null;
    private Index index;
    private boolean allowRepair;
    private boolean isSynthetic;

    @Override
    public void presetCommonParams(Index index, boolean allowRepair, boolean isSynthetic, Collection<RecordType> types) {
        if (isSynthetic && allowRepair) {
            throw new UnsupportedOperationException("Scrubbing synthetic records with repair is not supported");
        }
        this.recordTypes = types;
        this.index = index;
        this.allowRepair = allowRepair;
        this.isSynthetic = isSynthetic;
    }

    @Override
    public RecordCursor<FDBStoredRecord<Message>> getCursor(TupleRange tupleRange, FDBRecordStore store, int limit) {
        IsolationLevel isolationLevel = IsolationLevel.SNAPSHOT;
        ExecuteProperties.Builder executeProperties = ExecuteProperties.newBuilder().setIsolationLevel(isolationLevel).setReturnedRowLimit(limit);
        ScanProperties scanProperties = new ScanProperties(executeProperties.build(), false);
        return store.scanRecords(tupleRange, null, scanProperties);
    }

    @Override
    public Tuple getKeyFromCursorResult(RecordCursorResult<FDBStoredRecord<Message>> result) {
        FDBStoredRecord<Message> storedRecord = result.get();
        return storedRecord == null ? null : storedRecord.getPrimaryKey();
    }

    @Override
    @Nullable
    public CompletableFuture<IndexScrubbingTools.Issue> handleOneItem(FDBRecordStore store, RecordCursorResult<FDBStoredRecord<Message>> result) {
        if (this.recordTypes == null || this.index == null) {
            throw new IllegalStateException("presetParams was not called appropriately for this scrubbing tool");
        }
        FDBStoredRecord<Message> rec = result.get();
        if (rec == null || !this.recordTypes.contains(rec.getRecordType())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getMissingIndexKeys(store, rec).thenApply(missingIndexesKeys -> {
            if (missingIndexesKeys.isEmpty()) {
                return null;
            }
            return new IndexScrubbingTools.Issue(KeyValueLogMessage.build("Scrubber: missing index entry", new Object[]{LogMessageKeys.KEY, rec.getPrimaryKey().toString(), LogMessageKeys.INDEX_KEY, missingIndexesKeys.toString()}), FDBStoreTimer.Counts.INDEX_SCRUBBER_MISSING_ENTRIES, this.allowRepair ? rec : null);
        });
    }

    private CompletableFuture<List<Tuple>> getMissingIndexKeys(FDBRecordStore store, FDBStoredRecord<Message> rec) {
        IndexMaintainer maintainer = store.getIndexMaintainer(this.index);
        return this.indexEntriesForRecord(store, rec).mapPipelined(indexEntry -> {
            Tuple valueKey = indexEntry.getKey();
            byte[] keyBytes = maintainer.getIndexSubspace().pack(valueKey);
            return store.getContext().ensureActive().get(keyBytes).thenApply(indexVal -> indexVal == null ? valueKey : null);
        }, store.getPipelineSize(PipelineOperation.INDEX_TO_RECORD)).filter(Objects::nonNull).asList();
    }

    @Nonnull
    protected RecordCursor<IndexEntry> indexEntriesForRecord(@Nonnull FDBRecordStore store, @Nonnull FDBStoredRecord<Message> rec) {
        IndexMaintainer maintainer = store.getIndexMaintainer(this.index);
        if (this.isSynthetic) {
            RecordQueryPlanner queryPlanner = new RecordQueryPlanner(store.getRecordMetaData(), store.getRecordStoreState().withWriteOnlyIndexes(Collections.singletonList(this.index.getName())));
            SyntheticRecordPlanner syntheticPlanner = new SyntheticRecordPlanner(store, queryPlanner);
            SyntheticRecordFromStoredRecordPlan syntheticPlan = syntheticPlanner.forIndex(this.index);
            return RecordCursor.flatMapPipelined(outerContinuation -> syntheticPlan.execute(store, rec), (syntheticRecord, innerContinuation) -> {
                List<IndexEntry> entriesForSyntheticRecord = maintainer.filteredIndexEntries(syntheticRecord);
                if (entriesForSyntheticRecord == null) {
                    return RecordCursor.empty();
                }
                return RecordCursor.fromList(store.getExecutor(), entriesForSyntheticRecord, innerContinuation).map(entryNoPK -> this.rewriteWithPrimaryKey((IndexEntry)entryNoPK, (FDBRecord<? extends Message>)syntheticRecord));
            }, null, store.getPipelineSize(PipelineOperation.SYNTHETIC_RECORD_JOIN));
        }
        List<IndexEntry> indexEntryNoPKs = maintainer.filteredIndexEntries(rec);
        if (indexEntryNoPKs == null) {
            return RecordCursor.empty();
        }
        return RecordCursor.fromList(store.getExecutor(), indexEntryNoPKs).map(entryNoPK -> this.rewriteWithPrimaryKey((IndexEntry)entryNoPK, (FDBRecord<? extends Message>)rec));
    }

    @Nonnull
    private IndexEntry rewriteWithPrimaryKey(@Nonnull IndexEntry indexEntry, @Nonnull FDBRecord<? extends Message> rec) {
        return new IndexEntry(indexEntry.getIndex(), FDBRecordStoreBase.indexEntryKey(indexEntry.getIndex(), indexEntry.getKey(), rec.getPrimaryKey()), indexEntry.getValue(), rec.getPrimaryKey());
    }
}

