/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.ValueIndexScrubbingToolsDangling;
import com.apple.foundationdb.record.provider.foundationdb.indexes.ValueIndexScrubbingToolsMissing;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class VersionIndexMaintainer
extends StandardIndexMaintainer {
    protected VersionIndexMaintainer(IndexMaintainerState state) {
        super(state);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!scanType.equals(IndexScanType.BY_VALUE)) {
            throw new RecordCoreException("Can only scan version index by value.", new Object[0]);
        }
        return this.scan(range, continuation, scanProperties);
    }

    @Override
    protected <M extends Message> CompletableFuture<Void> updateOneKeyAsync(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull IndexEntry indexEntry) {
        if (this.state.index.isUnique()) {
            throw new MetaDataException("index type does not support unique indexes", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.INDEX_TYPE, this.state.index.getType()}).addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, this.state.index.getName()});
        }
        Tuple valueKey = indexEntry.getKey();
        Tuple value = indexEntry.getValue();
        long startTime = System.nanoTime();
        Tuple entryKey = this.indexEntryKey(valueKey, savedRecord.getPrimaryKey());
        boolean hasIncomplete = entryKey.hasIncompleteVersionstamp();
        byte[] keyBytes = hasIncomplete ? this.state.indexSubspace.packWithVersionstamp(entryKey) : this.state.indexSubspace.pack(entryKey);
        if (remove) {
            if (hasIncomplete) {
                this.state.context.removeVersionMutation(keyBytes);
            } else {
                this.state.transaction.clear(this.state.indexSubspace.pack(entryKey));
            }
            if (this.state.store.getTimer() != null) {
                this.state.store.getTimer().recordSinceNanoTime(FDBStoreTimer.Events.DELETE_INDEX_ENTRY, startTime);
            }
        } else {
            byte[] valueBytes = value.pack();
            this.checkKeyValueSizes(savedRecord, valueKey, value, keyBytes, valueBytes);
            if (hasIncomplete) {
                this.state.context.addVersionMutation(MutationType.SET_VERSIONSTAMPED_KEY, keyBytes, valueBytes);
            } else {
                this.state.transaction.set(keyBytes, valueBytes);
            }
            if (this.state.store.getTimer() != null) {
                this.state.store.getTimer().recordSinceNanoTime(FDBStoreTimer.Events.SAVE_INDEX_ENTRY, startTime);
            }
        }
        return AsyncUtil.DONE;
    }

    @Override
    @Nonnull
    public RecordCursor<FDBIndexedRawRecord> scanRemoteFetch(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, int commonPrimaryKeyLength) {
        return super.scanRemoteFetchByValue(scanBounds, continuation, scanProperties, commonPrimaryKeyLength);
    }

    @Override
    @Nullable
    public IndexScrubbingTools<?> getIndexScrubbingTools(IndexScrubbingTools.ScrubbingType type) {
        switch (type) {
            case MISSING: {
                return new ValueIndexScrubbingToolsMissing();
            }
            case DANGLING: {
                return new ValueIndexScrubbingToolsDangling();
            }
        }
        return null;
    }
}

