/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexing;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.RangeSet;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexingSubspaces;
import com.apple.foundationdb.subspace.Subspace;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class IndexingRangeSet {
    @Nonnull
    private final FDBRecordContext context;
    @Nonnull
    private final RangeSet rangeSet;

    private IndexingRangeSet(@Nonnull FDBRecordContext context, @Nonnull RangeSet rangeSet) {
        this.context = context;
        this.rangeSet = rangeSet;
    }

    @Nonnull
    public CompletableFuture<Boolean> isEmptyAsync() {
        long startTime = System.nanoTime();
        return this.context.instrument(FDBStoreTimer.Events.RANGE_SET_IS_EMPTY, this.rangeSet.isEmpty(this.context.ensureActive()), startTime);
    }

    public void clear() {
        this.rangeSet.clear(this.context.ensureActive());
        this.context.increment(FDBStoreTimer.Counts.RANGE_SET_CLEAR);
    }

    @Nonnull
    public CompletableFuture<Boolean> containsAsync(@Nonnull byte[] key) {
        long startTime = System.nanoTime();
        return this.context.instrument(FDBStoreTimer.Events.RANGE_SET_CONTAINS, this.rangeSet.contains(this.context.ensureActive(), key), startTime);
    }

    @Nonnull
    public CompletableFuture<Range> firstMissingRangeAsync() {
        return this.firstMissingRangeAsync(null, null);
    }

    @Nonnull
    public CompletableFuture<Range> firstMissingRangeAsync(@Nullable byte[] begin, @Nullable byte[] end) {
        long startTime = System.nanoTime();
        Iterator ranges = this.rangeSet.missingRanges(this.context.ensureActive(), begin, end, 1).iterator();
        CompletionStage future = ranges.onHasNext().thenApply(arg_0 -> IndexingRangeSet.lambda$firstMissingRangeAsync$0((AsyncIterator)ranges, arg_0));
        return this.context.instrument(FDBStoreTimer.Events.RANGE_SET_FIND_FIRST_MISSING, future, startTime);
    }

    @Nonnull
    public CompletableFuture<List<Range>> listMissingRangesAsync() {
        return this.listMissingRangesAsync(null, null);
    }

    @Nonnull
    public CompletableFuture<List<Range>> listMissingRangesAsync(@Nullable byte[] begin, @Nullable byte[] end) {
        long startTime = System.nanoTime();
        CompletableFuture<List<Range>> future = this.rangeSet.missingRanges(this.context.ensureActive(), begin, end).asList();
        return this.context.instrument(FDBStoreTimer.Events.RANGE_SET_LIST_MISSING, future, startTime);
    }

    @Nonnull
    public CompletableFuture<Boolean> insertRangeAsync(@Nullable byte[] begin, @Nullable byte[] end) {
        return this.insertRangeAsync(begin, end, false);
    }

    @Nonnull
    public CompletableFuture<Boolean> insertRangeAsync(@Nullable byte[] begin, @Nullable byte[] end, boolean requireEmpty) {
        long startTime = System.nanoTime();
        return this.context.instrument(FDBStoreTimer.Events.RANGE_SET_INSERT, this.rangeSet.insertRange(this.context.ensureActive(), begin, end, requireEmpty), startTime);
    }

    @Nonnull
    public static IndexingRangeSet forIndexBuild(@Nonnull FDBRecordStore store, @Nonnull Index index) {
        RangeSet rangeSet = new RangeSet(store.indexRangeSubspace(index));
        return new IndexingRangeSet(store.getRecordContext(), rangeSet);
    }

    @Nonnull
    public static IndexingRangeSet forScrubbingIndex(@Nonnull FDBRecordStore store, @Nonnull Index index, int rangeId) {
        Subspace subspace = IndexingSubspaces.indexScrubIndexRangeSubspace(store, index, rangeId);
        RangeSet rangeSet = new RangeSet(subspace);
        return new IndexingRangeSet(store.getRecordContext(), rangeSet);
    }

    @Nonnull
    public static IndexingRangeSet forScrubbingRecords(@Nonnull FDBRecordStore store, @Nonnull Index index, int rangeId) {
        Subspace subspace = IndexingSubspaces.indexScrubRecordsRangeSubspace(store, index, rangeId);
        RangeSet rangeSet = new RangeSet(subspace);
        return new IndexingRangeSet(store.getRecordContext(), rangeSet);
    }

    private static /* synthetic */ Range lambda$firstMissingRangeAsync$0(AsyncIterator ranges, Boolean hasNext) {
        if (hasNext.booleanValue()) {
            return (Range)ranges.next();
        }
        return null;
    }
}

