/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ExtendedDirectoryLayer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePathImpl;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.PathValue;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverCreateHooks;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class DirectoryLayerDirectory
extends KeySpaceDirectory {
    @Nonnull
    private final Function<FDBRecordContext, CompletableFuture<LocatableResolver>> scopeGenerator;
    @Nonnull
    private final ResolverCreateHooks createHooks;

    public DirectoryLayerDirectory(@Nonnull String name) {
        this(name, ANY_VALUE, null);
    }

    public DirectoryLayerDirectory(@Nonnull String name, Function<KeySpacePath, KeySpacePath> wrapper) {
        this(name, ANY_VALUE, wrapper);
    }

    public DirectoryLayerDirectory(@Nonnull String name, @Nullable Object value) {
        this(name, value, null);
    }

    public DirectoryLayerDirectory(@Nonnull String name, @Nullable Object value, @Nullable Function<KeySpacePath, KeySpacePath> wrapper) {
        this(name, value, wrapper, context -> CompletableFuture.completedFuture(ExtendedDirectoryLayer.global(context.getDatabase())), ResolverCreateHooks.getDefault());
    }

    public DirectoryLayerDirectory(@Nonnull String name, @Nullable Function<KeySpacePath, KeySpacePath> wrapper, @Nonnull Function<FDBRecordContext, CompletableFuture<LocatableResolver>> scopeGenerator, @Nonnull ResolverCreateHooks createHooks) {
        this(name, ANY_VALUE, wrapper, scopeGenerator, createHooks);
    }

    public DirectoryLayerDirectory(@Nonnull String name, @Nullable Object value, @Nullable Function<KeySpacePath, KeySpacePath> wrapper, @Nonnull Function<FDBRecordContext, CompletableFuture<LocatableResolver>> scopeGenerator, @Nonnull ResolverCreateHooks createHooks) {
        super(name, KeySpaceDirectory.KeyType.LONG, value, wrapper);
        this.scopeGenerator = scopeGenerator;
        this.createHooks = createHooks;
    }

    @Override
    protected void validateConstant(@Nullable Object value) {
        if (!(value instanceof String)) {
            throw new RecordCoreArgumentException("Illegal constant value type provided for directory", new Object[]{LogMessageKeys.DIR_NAME, this.getName(), "dir_value", value});
        }
    }

    @Override
    protected boolean isCompatible(@Nonnull KeySpaceDirectory parent, @Nonnull KeySpaceDirectory dir) {
        return dir instanceof DirectoryLayerDirectory;
    }

    @Override
    @Nonnull
    protected CompletableFuture<PathValue> toTupleValueAsyncImpl(@Nonnull FDBRecordContext context, final @Nullable Object value) {
        if (value instanceof Long) {
            if (this.value != ANY_VALUE) {
                if (!(this.value instanceof String)) {
                    throw new RecordCoreArgumentException("DirectoryLayerDirectory should be of string value", new Object[]{LogMessageKeys.DIR_NAME, this.getName(), "dir_layer_name", this.value, LogMessageKeys.PROVIDED_VALUE, value});
                }
                return this.lookupInScope(context, (String)this.value).thenApply(new Function<ResolverResult, PathValue>(){

                    @Override
                    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/552")
                    public PathValue apply(ResolverResult resolved) {
                        if (resolved.getValue() != ((Long)value).longValue()) {
                            throw new RecordCoreArgumentException("Provided directory layer value does not correspond to actual directory layer value for directory", new Object[]{LogMessageKeys.DIR_NAME, DirectoryLayerDirectory.this.getName(), "dir_layer_name", DirectoryLayerDirectory.this.value, LogMessageKeys.PROVIDED_VALUE, value, "expected_value", resolved});
                        }
                        return DirectoryLayerDirectory.toPathValue(resolved);
                    }
                });
            }
            return ((CompletableFuture)this.doReverseLookup(context, (Long)value).thenCompose(key -> this.lookupInScope(context, (String)key))).thenApply(DirectoryLayerDirectory::toPathValue);
        }
        if (!(value instanceof String)) {
            throw new RecordCoreArgumentException("Invalid value type provided for directory", new Object[]{LogMessageKeys.DIR_NAME, this.getName(), LogMessageKeys.PROVIDED_VALUE, value, "provided_type", value == null ? "null" : value.getClass().getName(), "expected_type", "[STRING, LONG]"});
        }
        if (this.value != ANY_VALUE && !DirectoryLayerDirectory.areEqual(this.value, value)) {
            throw new RecordCoreArgumentException("Illegal value type provided for directory", new Object[]{LogMessageKeys.DIR_NAME, this.getName(), LogMessageKeys.PROVIDED_VALUE, value, "expected_value", this.value});
        }
        return this.lookupInScope(context, (String)value).thenApply(DirectoryLayerDirectory::toPathValue);
    }

    @Override
    @Nonnull
    protected CompletableFuture<Optional<ResolvedKeySpacePath>> pathFromKey(@Nonnull FDBRecordContext context, @Nullable ResolvedKeySpacePath parent, @Nonnull Tuple key, int keySize, int keyIndex) {
        Object tupleValue = key.get(keyIndex);
        if (!(tupleValue instanceof Long)) {
            return DIRECTORY_NOT_FOR_KEY;
        }
        KeySpacePath parentPath = parent == null ? null : parent.toPath();
        return this.doReverseLookup(context, (Long)tupleValue).thenCompose(directoryString -> {
            if (this.value != ANY_VALUE && !directoryString.equals(this.value)) {
                return DIRECTORY_NOT_FOR_KEY;
            }
            return this.lookupInScope(context, (String)directoryString).thenCompose(directoryResolverResult -> {
                int childKeyIndex = keyIndex + 1;
                boolean canHaveChild = !this.subdirs.isEmpty() && childKeyIndex < keySize;
                Tuple remainder = canHaveChild || childKeyIndex == key.size() ? null : TupleHelpers.subTuple(key, childKeyIndex, key.size());
                PathValue pathValue = DirectoryLayerDirectory.toPathValue(directoryResolverResult);
                ResolvedKeySpacePath myPath = new ResolvedKeySpacePath(parent, KeySpacePathImpl.newPath(parentPath, this, directoryString, true, pathValue, remainder), pathValue, remainder);
                if (!canHaveChild) {
                    return CompletableFuture.completedFuture(Optional.of(myPath));
                }
                return this.findChildForKey(context, myPath, key, keySize, childKeyIndex).thenApply(Optional::of);
            });
        });
    }

    @Override
    @Nonnull
    public String getNameInTree() {
        return "[" + this.getName() + "]";
    }

    @Nonnull
    private CompletableFuture<String> doReverseLookup(@Nonnull FDBRecordContext context, Long dir) {
        return this.scopeGenerator.apply(context).thenCompose(resolver -> resolver.reverseLookup(context, dir));
    }

    @Nonnull
    private CompletableFuture<ResolverResult> lookupInScope(@Nonnull FDBRecordContext context, @Nonnull String key) {
        return this.scopeGenerator.apply(context).thenCompose(resolver -> resolver.resolveWithMetadata(context, key, this.createHooks));
    }

    @Nonnull
    private static PathValue toPathValue(@Nonnull ResolverResult result) {
        return new PathValue(result.getValue(), result.getMetadata());
    }
}

