/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.directory.DirectoryLayer;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBReverseDirectoryCache;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.record.provider.foundationdb.layers.interning.HighContentionAllocator;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ExtendedDirectoryLayer
extends LocatableResolver {
    private static final byte[] RESERVED_CONTENT_SUBSPACE_PREFIX = new byte[]{-3};
    private static final int STATE_SUBSPACE_KEY_SUFFIX = -10;
    private static final Subspace DEFAULT_BASE_SUBSPACE = new Subspace();
    private static final Subspace DEFAULT_NODE_SUBSPACE = new Subspace(Bytes.concat(DEFAULT_BASE_SUBSPACE.getKey(), DirectoryLayer.DEFAULT_NODE_SUBSPACE.getKey()));
    private static final Subspace DEFAULT_CONTENT_SUBSPACE = DEFAULT_BASE_SUBSPACE;
    private final boolean isRootLevel;
    @Nonnull
    private CompletableFuture<Subspace> baseSubspaceFuture;
    @Nonnull
    private CompletableFuture<Subspace> nodeSubspaceFuture;
    @Nonnull
    private CompletableFuture<Subspace> stateSubspaceFuture;
    @Nonnull
    private final Subspace contentSubspace;

    public ExtendedDirectoryLayer(@Nonnull FDBDatabase database, @Nonnull ResolvedKeySpacePath path) {
        this(database, path.toPath(), CompletableFuture.completedFuture(path));
    }

    private ExtendedDirectoryLayer(@Nonnull FDBDatabase database, @Nullable KeySpacePath path, @Nullable CompletableFuture<ResolvedKeySpacePath> resolvedPathFuture) {
        super(database, path, resolvedPathFuture);
        if (path == null && resolvedPathFuture == null) {
            this.isRootLevel = true;
            this.baseSubspaceFuture = CompletableFuture.completedFuture(DEFAULT_BASE_SUBSPACE);
            this.nodeSubspaceFuture = CompletableFuture.completedFuture(DEFAULT_NODE_SUBSPACE);
            this.contentSubspace = DEFAULT_CONTENT_SUBSPACE;
        } else {
            this.isRootLevel = false;
            this.baseSubspaceFuture = resolvedPathFuture.thenApply(ResolvedKeySpacePath::toSubspace);
            this.nodeSubspaceFuture = this.baseSubspaceFuture.thenApply(base -> new Subspace(Bytes.concat(base.getKey(), DirectoryLayer.DEFAULT_NODE_SUBSPACE.getKey())));
            this.contentSubspace = new Subspace(RESERVED_CONTENT_SUBSPACE_PREFIX);
        }
        this.stateSubspaceFuture = this.nodeSubspaceFuture.thenApply(node -> node.get(-10));
    }

    public static ExtendedDirectoryLayer global(@Nonnull FDBDatabase database) {
        return new ExtendedDirectoryLayer(database, null, null);
    }

    @Override
    protected CompletableFuture<ResolverResult> create(@Nonnull FDBRecordContext context, @Nonnull String key, @Nullable byte[] metadata) {
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.EXTENDED_DIRECTORY_LAYER_CREATE, this.createInternal(context, key, metadata));
    }

    private CompletableFuture<ResolverResult> createInternal(@Nonnull FDBRecordContext context, String key, @Nullable byte[] metadata) {
        FDBReverseDirectoryCache reverseCache = context.getDatabase().getReverseDirectoryCache();
        return ((CompletableFuture)((CompletableFuture)this.getHca(context).thenCompose(hca -> hca.allocate(key))).thenCompose(allocated -> {
            ResolverResult result = new ResolverResult((long)allocated, metadata);
            return this.getMappingSubspaceAsync().thenApply(mappingSubspace -> {
                context.ensureActive().set(mappingSubspace.pack(key), this.serializeValue(result));
                return result;
            });
        })).thenCompose(result -> reverseCache.putIfNotExists(context, this.wrap(key), result.getValue()).thenApply(ignore -> result));
    }

    @Override
    protected CompletableFuture<Optional<ResolverResult>> read(@Nonnull FDBRecordContext context, String key) {
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.EXTENDED_DIRECTORY_LAYER_READ, this.readInternal(context, key));
    }

    private CompletableFuture<Optional<ResolverResult>> readInternal(@Nonnull FDBRecordContext context, String key) {
        FDBReverseDirectoryCache reverseCache = context.getDatabase().getReverseDirectoryCache();
        return ((CompletableFuture)this.getMappingSubspaceAsync().thenCompose(mappingSubspace -> context.ensureActive().get(mappingSubspace.pack(key)))).thenCompose(bytes -> {
            if (bytes == null) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            ResolverResult result = this.deserializeValue((byte[])bytes);
            return reverseCache.putIfNotExists(context, this.wrap(key), result.getValue()).thenApply(ignore -> Optional.of(result));
        });
    }

    @Override
    protected CompletableFuture<Optional<String>> readReverse(@Nonnull FDBRecordContext context, Long value) {
        FDBReverseDirectoryCache reverseCache = this.database.getReverseDirectoryCache();
        return reverseCache.get(context, this.wrap(value));
    }

    @Override
    @Deprecated
    protected CompletableFuture<Optional<String>> readReverse(FDBStoreTimer timer, Long value) {
        FDBReverseDirectoryCache reverseCache = this.database.getReverseDirectoryCache();
        return reverseCache.get(timer, this.wrap(value));
    }

    private CompletableFuture<Optional<String>> readInReverseCacheSubpspace(FDBStoreTimer timer, Long value) {
        return this.database.getReverseDirectoryCache().getInReverseDirectoryCacheSubspace(timer, this.wrap(value));
    }

    @Override
    @VisibleForTesting
    protected CompletableFuture<Void> deleteReverseForTesting(FDBRecordContext context, long value) {
        return this.database.getReverseDirectoryCache().deleteForTesting(context, this.wrap(value));
    }

    @Override
    protected CompletableFuture<Void> putReverse(@Nonnull FDBRecordContext context, long value, @Nonnull String key) {
        return this.database.getReverseDirectoryCache().putOrReplaceForTesting(context, this.wrap(key), value);
    }

    @Override
    public CompletableFuture<Void> setMapping(FDBRecordContext context, String key, ResolverResult value) {
        return ((CompletableFuture)this.read(context, key).thenCombine(this.readInReverseCacheSubpspace(context.getTimer(), value.getValue()), (maybeRead, maybeReverseRead) -> {
            maybeRead.ifPresent(read -> {
                if (!read.equals(value)) {
                    throw new RecordCoreException("mapping already exists with different value", new Object[0]).addLogInfo("keyToSet", (Object)key).addLogInfo("valueToSet", (Object)value).addLogInfo("valueFound", read);
                }
            });
            maybeReverseRead.ifPresent(reverseRead -> {
                if (!reverseRead.equals(key)) {
                    throw new RecordCoreException("reverse mapping already exists with different key", new Object[0]).addLogInfo("keyToSet", (Object)key).addLogInfo("valueToSet", (Object)value).addLogInfo("keyForValueFound", reverseRead);
                }
            });
            if (!maybeRead.isPresent() && !maybeReverseRead.isPresent()) {
                return ((CompletableFuture)this.getMappingSubspaceAsync().thenCombine(this.getHca(context), (mappingSubspace, hca) -> {
                    context.ensureActive().set(mappingSubspace.pack(key), this.serializeValue(value));
                    hca.forceAllocate(key, value.getValue());
                    return null;
                })).thenCompose(vignore -> context.getDatabase().getReverseDirectoryCache().putIfNotExists(context, this.wrap(key), value.getValue()));
            }
            return AsyncUtil.DONE;
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<HighContentionAllocator> getHca(@Nonnull FDBRecordContext context) {
        return this.getCounterSubspaceAsync().thenCombine(this.getAllocationSubspaceAsync(), (counter, allocation) -> this.isRootLevel ? HighContentionAllocator.forRoot(context, counter, allocation) : new HighContentionAllocator(context, (Subspace)counter, (Subspace)allocation));
    }

    @Override
    public CompletableFuture<Void> updateMetadata(FDBRecordContext context, String key, byte[] metadata) {
        throw new UnsupportedOperationException("cannot update metadata in ExtendedDirectoryLayer");
    }

    @Override
    public CompletableFuture<Void> setWindow(long count) {
        return this.database.runAsync(context -> this.getHca((FDBRecordContext)context).thenAccept(hca -> hca.setWindow(count)), Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "ExtendedDirectoryLayer::setWindow", LogMessageKeys.RESOLVER, this}));
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getMappingSubspaceAsync() {
        return this.nodeSubspaceFuture.thenApply(nodeSubspace -> nodeSubspace.get(nodeSubspace.getKey()).get(0));
    }

    private CompletableFuture<Subspace> getCounterSubspaceAsync() {
        return this.nodeSubspaceFuture.thenApply(nodeSubspace -> nodeSubspace.get(nodeSubspace.getKey()).get("hca".getBytes(StandardCharsets.UTF_8)).get(0));
    }

    private CompletableFuture<Subspace> getAllocationSubspaceAsync() {
        return this.nodeSubspaceFuture.thenApply(nodeSubspace -> nodeSubspace.get(nodeSubspace.getKey()).get("hca".getBytes(StandardCharsets.UTF_8)).get(1));
    }

    @Override
    protected CompletableFuture<Subspace> getStateSubspaceAsync() {
        return this.stateSubspaceFuture;
    }

    @Override
    @Nonnull
    public ResolverResult deserializeValue(byte[] value) {
        Tuple unpacked = this.contentSubspace.unpack(value);
        return unpacked.size() == 1 ? new ResolverResult(unpacked.getLong(0), null) : new ResolverResult(unpacked.getLong(0), unpacked.getBytes(1));
    }

    private byte[] serializeValue(@Nonnull ResolverResult value) {
        return value.getMetadata() == null ? this.contentSubspace.pack(Tuple.from(value.getValue())) : this.contentSubspace.pack(Tuple.from(value.getValue(), value.getMetadata()));
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getBaseSubspaceAsync() {
        return this.baseSubspaceFuture;
    }
}

