/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePathImpl;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.tuple.Tuple;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class KeySpace {
    private final KeySpaceDirectory root;

    public KeySpace(KeySpaceDirectory ... rootDirectories) {
        this("/", rootDirectories);
    }

    public KeySpace(@Nonnull String name, KeySpaceDirectory ... rootDirectories) {
        this.root = new KeySpaceDirectory(name, KeySpaceDirectory.KeyType.NULL, null, null);
        for (KeySpaceDirectory directory : rootDirectories) {
            this.root.addSubdirectory(directory);
        }
    }

    @Nonnull
    public KeySpaceDirectory getDirectory(@Nonnull String name) {
        return this.root.getSubdirectory(name);
    }

    @Nonnull
    public List<KeySpaceDirectory> getDirectories() {
        return this.root.getSubdirectories();
    }

    @Nonnull
    public KeySpacePath path(@Nonnull String name) {
        KeySpaceDirectory dir = this.root.getSubdirectory(name);
        return KeySpacePathImpl.newPath(null, dir);
    }

    @Nonnull
    public KeySpacePath path(@Nonnull String name, @Nullable Object value) {
        KeySpaceDirectory dir = this.root.getSubdirectory(name);
        return KeySpacePathImpl.newPath(null, dir, value, false, null, null);
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    public CompletableFuture<KeySpacePath> pathFromKeyAsync(@Nonnull FDBRecordContext context, @Nonnull Tuple key) {
        return this.root.findChildForKey(context, null, key, key.size(), 0).thenApply(ResolvedKeySpacePath::toPath);
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    public KeySpacePath pathFromKey(@Nonnull FDBRecordContext context, @Nonnull Tuple key) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_PATH_RESOLVE, this.pathFromKeyAsync(context, key));
    }

    @Nonnull
    public CompletableFuture<ResolvedKeySpacePath> resolveFromKeyAsync(@Nonnull FDBRecordContext context, @Nonnull Tuple key) {
        return this.root.findChildForKey(context, null, key, key.size(), 0);
    }

    @Nonnull
    public ResolvedKeySpacePath resolveFromKey(@Nonnull FDBRecordContext context, @Nonnull Tuple key) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_PATH_RESOLVE, this.resolveFromKeyAsync(context, key));
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    public RecordCursor<KeySpacePath> listAsync(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.root.listSubdirectoryAsync(null, context, subdirName, continuation, scanProperties).map(ResolvedKeySpacePath::toPath);
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    public List<KeySpacePath> list(@Nonnull FDBRecordContext context, @Nonnull String directory, @Nonnull ScanProperties scanProperties) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_LIST, this.listAsync(context, directory, null, scanProperties).asList());
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    public List<KeySpacePath> list(@Nonnull FDBRecordContext context, @Nonnull String directory) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_LIST, this.listAsync(context, directory, null, ScanProperties.FORWARD_SCAN).asList());
    }

    @Nonnull
    public RecordCursor<ResolvedKeySpacePath> listDirectoryAsync(@Nonnull FDBRecordContext context, @Nonnull String directory, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.root.listSubdirectoryAsync(null, context, directory, continuation, scanProperties);
    }

    @Nonnull
    public List<ResolvedKeySpacePath> listDirectory(@Nonnull FDBRecordContext context, @Nonnull String directory, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_LIST, this.listDirectoryAsync(context, directory, continuation, scanProperties).asList());
    }

    @Nonnull
    public List<ResolvedKeySpacePath> listDirectory(@Nonnull FDBRecordContext context, @Nonnull String directory, @Nonnull ScanProperties scanProperties) {
        return this.listDirectory(context, directory, null, scanProperties);
    }

    @Nonnull
    public List<ResolvedKeySpacePath> listDirectory(@Nonnull FDBRecordContext context, @Nonnull String directory) {
        return this.listDirectory(context, directory, null, ScanProperties.FORWARD_SCAN);
    }

    public KeySpaceDirectory getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }

    public void toTree(Writer out) throws IOException {
        this.root.toTree(out);
    }
}

