/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.KeyRange;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.ValueRange;
import com.apple.foundationdb.record.cursors.ChainedCursor;
import com.apple.foundationdb.record.cursors.LazyCursor;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePathImpl;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.NoSuchDirectoryException;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.PathValue;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class KeySpaceDirectory {
    protected static final CompletableFuture<Optional<ResolvedKeySpacePath>> DIRECTORY_NOT_FOR_KEY = CompletableFuture.completedFuture(Optional.empty());
    public static final Object ANY_VALUE = new AnyValue();
    @Nullable
    protected KeySpaceDirectory parent;
    @Nonnull
    protected final String name;
    @Nonnull
    protected final KeyType keyType;
    @Nullable
    protected final Object value;
    @Nonnull
    protected final Map<String, KeySpaceDirectory> subdirsByName = new HashMap<String, KeySpaceDirectory>();
    @Nonnull
    protected final List<KeySpaceDirectory> subdirs = new ArrayList<KeySpaceDirectory>();
    @Nullable
    protected Function<KeySpacePath, KeySpacePath> wrapper;

    public KeySpaceDirectory(@Nonnull String name, @Nonnull KeyType keyType, @Nullable Object value, @Nullable Function<KeySpacePath, KeySpacePath> wrapper) {
        this.name = name;
        this.keyType = keyType;
        this.value = value;
        this.wrapper = wrapper;
        if (value != keyType.getAnyValue()) {
            this.validateConstant(value);
        }
    }

    public KeySpaceDirectory(@Nonnull String name, @Nonnull KeyType keyType, @Nullable Function<KeySpacePath, KeySpacePath> wrapper) {
        this(name, keyType, keyType.getAnyValue(), wrapper);
    }

    public KeySpaceDirectory(@Nonnull String name, @Nonnull KeyType keyType) {
        this(name, keyType, keyType.getAnyValue(), null);
    }

    public KeySpaceDirectory(@Nonnull String name, @Nonnull KeyType keyType, @Nullable Object value) {
        this(name, keyType, value, null);
    }

    public int depth() {
        int depth = 0;
        for (KeySpaceDirectory current = this; current != null; current = current.getParent()) {
            ++depth;
        }
        return depth;
    }

    protected void validateConstant(@Nullable Object value) {
        if (!this.keyType.isMatch(value)) {
            throw new RecordCoreArgumentException("Illegal constant value provided for directory", new Object[]{LogMessageKeys.DIR_NAME, this.getName(), LogMessageKeys.DIR_VALUE, value});
        }
    }

    @Nonnull
    protected CompletableFuture<Optional<ResolvedKeySpacePath>> pathFromKey(@Nonnull FDBRecordContext context, @Nullable ResolvedKeySpacePath parent, @Nonnull Tuple key, int keySize, int keyIndex) {
        Object tupleValue = key.get(keyIndex);
        if (KeyType.typeOf(tupleValue) != this.getKeyType() || this.value != ANY_VALUE && !KeySpaceDirectory.areEqual(this.value, tupleValue)) {
            return DIRECTORY_NOT_FOR_KEY;
        }
        KeySpacePath parentPath = parent == null ? null : parent.toPath();
        PathValue pathValue = new PathValue(tupleValue);
        return this.toTupleValueAsync(context, tupleValue).thenCompose(resolvedValue -> {
            if (this.subdirs.isEmpty() || keyIndex + 1 == keySize) {
                Tuple remainder = keyIndex + 1 == key.size() ? null : TupleHelpers.subTuple(key, keyIndex + 1, key.size());
                KeySpacePath path = KeySpacePathImpl.newPath(parentPath, this, tupleValue, true, resolvedValue, remainder);
                return CompletableFuture.completedFuture(Optional.of(new ResolvedKeySpacePath(parent, path, new PathValue(tupleValue), remainder)));
            }
            KeySpacePath path = KeySpacePathImpl.newPath(parentPath, this, tupleValue, true, resolvedValue, null);
            return this.findChildForKey(context, new ResolvedKeySpacePath(parent, path, pathValue, null), key, keySize, keyIndex + 1).thenApply(Optional::of);
        });
    }

    @Nonnull
    public CompletableFuture<ResolvedKeySpacePath> findChildForValue(@Nonnull FDBRecordContext context, @Nullable ResolvedKeySpacePath parent, @Nullable Object value) {
        Tuple key = Tuple.from(value);
        return this.findChildForKey(context, parent, key, 1, 0);
    }

    @Nonnull
    protected CompletableFuture<ResolvedKeySpacePath> findChildForKey(@Nonnull FDBRecordContext context, @Nullable ResolvedKeySpacePath parent, @Nonnull Tuple key, int keySize, int keyIndex) {
        return this.nextChildForKey(0, context, parent, key, keySize, keyIndex);
    }

    protected CompletableFuture<ResolvedKeySpacePath> nextChildForKey(int childIndex, @Nonnull FDBRecordContext context, @Nullable ResolvedKeySpacePath parent, @Nonnull Tuple key, int keySize, int keyIndex) {
        if (childIndex >= this.subdirs.size()) {
            throw new RecordCoreArgumentException("No subdirectory available to hold provided type", new Object[]{LogMessageKeys.PARENT_DIR, this.getName(), "key_tuple", key, "key_tuple_pos", keyIndex, "key_tuple_type", key.get(keyIndex) == null ? "NULL" : key.get(keyIndex).getClass().getName()});
        }
        KeySpaceDirectory subdir = this.subdirs.get(childIndex);
        return subdir.pathFromKey(context, parent, key, keySize, keyIndex).thenCompose(maybeChildPath -> {
            if (maybeChildPath.isPresent()) {
                return CompletableFuture.completedFuture((ResolvedKeySpacePath)maybeChildPath.get());
            }
            return this.nextChildForKey(childIndex + 1, context, parent, key, keySize, keyIndex);
        });
    }

    @Nonnull
    public KeySpaceDirectory addSubdirectory(@Nonnull KeySpaceDirectory subdirectory) {
        for (KeySpaceDirectory existingSubdir : this.subdirsByName.values()) {
            if (existingSubdir.getName().equals(subdirectory.getName())) {
                throw new RecordCoreArgumentException("Subdirectory already exists", new Object[]{LogMessageKeys.PARENT_DIR, this.getName(), LogMessageKeys.DIR_NAME, subdirectory.getName()});
            }
            if (existingSubdir.getKeyType() != subdirectory.getKeyType()) continue;
            if (existingSubdir.getValue() == ANY_VALUE || subdirectory.getValue() == ANY_VALUE) {
                throw new RecordCoreArgumentException("Cannot add directory due to overlapping type", new Object[]{LogMessageKeys.PARENT_DIR, this.getName(), LogMessageKeys.DIR_NAME, existingSubdir.getName(), LogMessageKeys.DIR_TYPE, subdirectory.getKeyType()});
            }
            if (Objects.equals(subdirectory.getValue(), existingSubdir.getValue())) {
                throw new RecordCoreArgumentException("Cannot add directory due to overlapping constant value", new Object[]{LogMessageKeys.PARENT_DIR, this.getName(), LogMessageKeys.DIR_NAME, existingSubdir.getName(), LogMessageKeys.DIR_TYPE, existingSubdir.getKeyType(), LogMessageKeys.DIR_VALUE, existingSubdir.getValue()});
            }
            if (existingSubdir.isCompatible(this, subdirectory) && subdirectory.isCompatible(this, existingSubdir)) continue;
            throw new RecordCoreArgumentException("Cannot add directory due to incompatibility with existing subdirectory", new Object[]{LogMessageKeys.PARENT_DIR, this.getName(), LogMessageKeys.DIR_TYPE, existingSubdir.getKeyType(), LogMessageKeys.DIR_VALUE, existingSubdir.getValue()});
        }
        subdirectory.setParent(this);
        this.subdirsByName.put(subdirectory.getName(), subdirectory);
        this.subdirs.add(subdirectory);
        return this;
    }

    protected boolean isCompatible(@Nonnull KeySpaceDirectory parent, @Nonnull KeySpaceDirectory dir) {
        return true;
    }

    private void setParent(@Nonnull KeySpaceDirectory parent) {
        if (this.parent != null) {
            throw new RecordCoreArgumentException("Cannot re-parent a directory", new Object[0]);
        }
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.subdirsByName.isEmpty();
    }

    @Nonnull
    public KeySpaceDirectory getSubdirectory(@Nonnull String name) {
        KeySpaceDirectory dir = this.subdirsByName.get(name);
        if (dir == null) {
            throw new NoSuchDirectoryException(this, name);
        }
        return dir;
    }

    @Nonnull
    protected KeySpacePath wrap(@Nonnull KeySpacePath path) {
        if (this.wrapper != null) {
            return this.wrapper.apply(path);
        }
        return path;
    }

    @Nonnull
    protected RecordCursor<ResolvedKeySpacePath> listSubdirectoryAsync(@Nullable KeySpacePath listFrom, @Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.listSubdirectoryAsync(listFrom, context, subdirName, null, continuation, scanProperties);
    }

    @Nonnull
    protected RecordCursor<ResolvedKeySpacePath> listSubdirectoryAsync(@Nullable KeySpacePath listFrom, @Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable ValueRange<?> valueRange, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (listFrom != null && listFrom.getDirectory() != this) {
            throw new RecordCoreException("Provided path does not belong to this directory", new Object[0]).addLogInfo("path", listFrom, "directory", this.getName());
        }
        KeySpaceDirectory subdir = this.getSubdirectory(subdirName);
        CompletableFuture<Object> resolvedFromFuture = listFrom == null ? CompletableFuture.completedFuture(null) : listFrom.toResolvedPathAsync(context);
        ScanProperties chainedCursorScanProperties = scanProperties.isReverse() ? scanProperties.setReverse(false) : scanProperties;
        ScanProperties keyReadScanProperties = scanProperties.with(props -> props.clearState().setReturnedRowLimit(1));
        return new LazyCursor<ResolvedKeySpacePath>((CompletableFuture<RecordCursor<ResolvedKeySpacePath>>)resolvedFromFuture.thenCompose(resolvedFrom -> {
            Subspace subspace = resolvedFrom == null ? new Subspace() : resolvedFrom.toSubspace();
            return subdir.getValueRange(context, valueRange, subspace).thenApply(range -> {
                ChainedCursor<Tuple> cursor = new ChainedCursor<Tuple>(context, lastKey -> this.nextTuple(context, subspace, (KeyRange)range, (Optional<Tuple>)lastKey, keyReadScanProperties), Tuple::pack, Tuple::fromBytes, continuation, chainedCursorScanProperties);
                return cursor.mapPipelined(tuple -> {
                    Tuple key = Tuple.fromList(tuple.getItems());
                    return this.findChildForKey(context, (ResolvedKeySpacePath)resolvedFrom, key, 1, 0);
                }, 1);
            });
        }), context.getExecutor());
    }

    @Nonnull
    private CompletableFuture<KeyRange> getValueRange(@Nonnull FDBRecordContext context, @Nullable ValueRange<?> valueRange, @Nonnull Subspace subspace) {
        if (this.getValue() == ANY_VALUE) {
            EndpointType stopType;
            byte[] stopKey;
            byte[] subspaceBytes;
            EndpointType startType;
            byte[] startKey;
            if (valueRange != null && valueRange.getLowEndpoint() != EndpointType.TREE_START) {
                if (KeyType.typeOf(valueRange.getLow()) != this.getKeyType()) {
                    throw this.invalidValueTypeException(KeyType.typeOf(valueRange.getLow()), this.getKeyType(), this.getName(), valueRange);
                }
                startKey = subspace.pack(valueRange.getLow());
                startType = valueRange.getLowEndpoint();
                if (startType != EndpointType.RANGE_INCLUSIVE && startType != EndpointType.RANGE_EXCLUSIVE) {
                    throw new RecordCoreArgumentException("Endpoint type not supported for directory list", new Object[]{LogMessageKeys.ENDPOINT_TYPE, startType});
                }
            } else {
                subspaceBytes = subspace.pack();
                startKey = new byte[subspaceBytes.length + 1];
                System.arraycopy(subspaceBytes, 0, startKey, 0, subspaceBytes.length);
                startKey[subspaceBytes.length] = this.getKeyType().getTypeLowBounds();
                startType = EndpointType.RANGE_INCLUSIVE;
            }
            if (valueRange != null && valueRange.getHighEndpoint() != EndpointType.TREE_END) {
                if (KeyType.typeOf(valueRange.getHigh()) != this.getKeyType()) {
                    throw this.invalidValueTypeException(KeyType.typeOf(valueRange.getHigh()), this.getKeyType(), this.getName(), valueRange);
                }
                stopKey = subspace.pack(valueRange.getHigh());
                stopType = valueRange.getHighEndpoint();
                if (stopType != EndpointType.RANGE_INCLUSIVE && stopType != EndpointType.RANGE_EXCLUSIVE) {
                    throw new RecordCoreArgumentException("Endpoint type not supported for directory list", new Object[]{LogMessageKeys.ENDPOINT_TYPE, stopType});
                }
            } else {
                subspaceBytes = subspace.pack();
                stopKey = new byte[subspaceBytes.length + 1];
                System.arraycopy(subspaceBytes, 0, stopKey, 0, subspaceBytes.length);
                stopKey[subspaceBytes.length] = this.getKeyType().getTypeHighBounds();
                stopType = EndpointType.RANGE_EXCLUSIVE;
            }
            return CompletableFuture.completedFuture(new KeyRange(startKey, startType, stopKey, stopType));
        }
        if (valueRange != null) {
            throw new RecordCoreArgumentException("range is not applicable when the subdirectory has a value.", new Object[]{LogMessageKeys.DIR_NAME, this.getName(), LogMessageKeys.RANGE, valueRange});
        }
        return this.toTupleValueAsync(context, this.value).thenApply(resolvedValue -> {
            byte[] key = subspace.pack(Tuple.from(resolvedValue.getResolvedValue()));
            return new KeyRange(key, EndpointType.RANGE_INCLUSIVE, ByteArrayUtil.strinc(key), EndpointType.RANGE_EXCLUSIVE);
        });
    }

    private RecordCoreArgumentException invalidValueTypeException(KeyType rangeValueType, KeyType expectedValueType, String dirName, ValueRange<?> range) {
        throw new RecordCoreArgumentException("value type provided for range is invalid for directory type", new Object[]{LogMessageKeys.RANGE_VALUE_TYPE, rangeValueType, LogMessageKeys.EXPECTED_VALUE_TYPE, expectedValueType, LogMessageKeys.DIR_NAME, dirName, LogMessageKeys.RANGE, range});
    }

    private CompletableFuture<Optional<Tuple>> nextTuple(@Nonnull FDBRecordContext context, @Nonnull Subspace subspace, @Nonnull KeyRange range, @Nonnull Optional<Tuple> lastTuple, @Nonnull ScanProperties scanProperties) {
        KeyValueCursor cursor;
        if (!lastTuple.isPresent()) {
            cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(subspace).setContext(context)).setRange(range)).setContinuation(null)).setScanProperties(scanProperties)).build();
        } else {
            KeyValueCursor.Builder builder = (KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(subspace).setContext(context)).setContinuation(null)).setScanProperties(scanProperties);
            cursor = scanProperties.isReverse() ? ((KeyValueCursor.Builder)((KeyValueCursor.Builder)builder.setLow(range.getLowKey(), range.getLowEndpoint())).setHigh(subspace.pack(lastTuple.get().get(0)), EndpointType.RANGE_EXCLUSIVE)).build() : ((KeyValueCursor.Builder)((KeyValueCursor.Builder)builder.setLow(subspace.pack(lastTuple.get().get(0)), EndpointType.RANGE_EXCLUSIVE)).setHigh(range.getHighKey(), range.getHighEndpoint())).build();
        }
        return cursor.onNext().thenApply(next -> {
            if (next.hasNext()) {
                KeyValue kv = (KeyValue)next.get();
                return Optional.of(subspace.unpack(kv.getKey()));
            }
            return Optional.empty();
        });
    }

    @Nonnull
    public List<KeySpaceDirectory> getSubdirectories() {
        return this.subdirs;
    }

    @Nonnull
    protected final CompletableFuture<PathValue> toTupleValueAsync(@Nonnull FDBRecordContext context, @Nullable Object value) {
        return this.toTupleValueAsyncImpl(context, value).thenApply(pathValue -> {
            this.validateResolvedValue(pathValue.getResolvedValue());
            return pathValue;
        });
    }

    @Nullable
    protected PathValue toTupleValue(@Nonnull FDBRecordContext context, @Nullable Object value) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_DIRECTORY_RESOLVE, this.toTupleValueAsync(context, value));
    }

    @Nonnull
    protected CompletableFuture<PathValue> toTupleValueAsyncImpl(@Nonnull FDBRecordContext context, @Nullable Object value) {
        if (this.value != ANY_VALUE && !KeySpaceDirectory.areEqual(this.value, value)) {
            throw new RecordCoreArgumentException("Illegal value provided", "provided_value", value, "expected_value", this.value);
        }
        return CompletableFuture.completedFuture(new PathValue(value));
    }

    @Nullable
    protected Object validateResolvedValue(@Nullable Object value) {
        if (!this.keyType.isMatch(value)) {
            throw new RecordCoreArgumentException("Illegal value type provided for directory", new Object[]{LogMessageKeys.DIR_NAME, this.getName(), "provided_value", value, "expected_type", this.keyType, "provided_type", value == null ? "NULL" : value.getClass().getName()});
        }
        return value;
    }

    @Nullable
    public KeySpaceDirectory getParent() {
        return this.parent;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getNameInTree() {
        return this.name;
    }

    @Nonnull
    public KeyType getKeyType() {
        return this.keyType;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    protected static boolean areEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        KeyType o1Type = KeyType.typeOf(o1);
        if (o1Type != KeyType.typeOf(o2)) {
            return false;
        }
        switch (o1Type) {
            case BYTES: {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            case LONG: {
                return ((Number)o1).longValue() == ((Number)o2).longValue();
            }
            case STRING: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case UUID: {
                return o1.equals(o2);
            }
        }
        throw new RecordCoreException("Unexpected key type " + String.valueOf((Object)o1Type), new Object[0]);
    }

    public String toPathString() {
        StringBuilder sb = new StringBuilder();
        this.appendPath(sb, this);
        return sb.toString();
    }

    private void appendPath(StringBuilder sb, KeySpaceDirectory dir) {
        KeySpaceDirectory parent = dir.getParent();
        if (parent != null) {
            this.appendPath(sb, parent);
        }
        sb.append("/").append(dir.getName());
    }

    public String toString() {
        String string;
        StringWriter out = new StringWriter();
        try {
            this.toTree(out);
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RecordCoreException(e.getMessage(), e);
            }
        }
        out.close();
        return string;
    }

    public void toTree(Writer out) throws IOException {
        this.toTree(out, this, 0, false, new BitSet());
    }

    private void toTree(Writer out, KeySpaceDirectory dir, int indent, boolean hasAnotherSibling, BitSet downspouts) throws IOException {
        for (int i = 0; i < indent; ++i) {
            if (downspouts.get(i)) {
                out.append(" | ");
                continue;
            }
            out.append("   ");
        }
        if (dir.getParent() != null) {
            out.append(" +- ");
        }
        out.append(dir.getNameInTree());
        out.append(" (");
        out.append(dir.getKeyType().toString());
        if (dir.getValue() != dir.getKeyType().getAnyValue()) {
            out.append("=");
            out.append(dir.getValue() == null ? "null" : dir.getValue().toString());
        }
        out.append(")").append("\n");
        if (!dir.isLeaf()) {
            List<KeySpaceDirectory> dirSubdirs = dir.getSubdirectories();
            downspouts.set(indent, hasAnotherSibling);
            for (int i = 0; i < dirSubdirs.size(); ++i) {
                this.toTree(out, dirSubdirs.get(i), indent + 1, i < dirSubdirs.size() - 1, downspouts);
            }
            downspouts.set(indent, false);
        }
    }

    public static enum KeyType {
        NULL(v -> v == null, null, 0, 1),
        BYTES(v -> v instanceof byte[], 1, 2),
        STRING(String.class, 2, 3),
        LONG(v -> v instanceof Long || v instanceof Integer, 11, 30),
        FLOAT(Float.class, 32, 33),
        DOUBLE(Double.class, 33, 34),
        BOOLEAN(v -> v instanceof Boolean, 38, 40),
        UUID(UUID.class, 48, 49);

        @Nonnull
        @SpotBugsSuppressWarnings(value={"SE_BAD_FIELD"})
        final Function<Object, Boolean> matcher;
        @Nullable
        final Object anyValue;
        final byte typeLowBounds;
        final byte typeHighBounds;

        private KeyType(Class<?> expectedType, byte typeLowBounds, byte typeHighBounds) {
            this(v -> v != null && expectedType.isAssignableFrom(v.getClass()), ANY_VALUE, typeLowBounds, typeHighBounds);
        }

        private KeyType(Function<Object, Boolean> matcher, byte typeLowBounds, byte typeHighBounds) {
            this(matcher, ANY_VALUE, typeLowBounds, typeHighBounds);
        }

        private KeyType(Function<Object, Boolean> matcher, Object anyValue, byte typeLowBounds, byte typeHighBounds) {
            this.matcher = matcher;
            this.typeLowBounds = typeLowBounds;
            this.typeHighBounds = typeHighBounds;
            this.anyValue = anyValue;
        }

        public boolean isMatch(@Nullable Object value) {
            return this.matcher.apply(value);
        }

        public Object getAnyValue() {
            return this.anyValue;
        }

        public byte getTypeLowBounds() {
            return this.typeLowBounds;
        }

        public byte getTypeHighBounds() {
            return this.typeHighBounds;
        }

        public static KeyType typeOf(@Nullable Object value) {
            for (KeyType type : KeyType.values()) {
                if (!type.matcher.apply(value).booleanValue()) continue;
                return type;
            }
            throw new RecordCoreArgumentException("No directory type matches value", "value", value, "value_type", value.getClass().getName());
        }
    }

    private static class AnyValue {
        private AnyValue() {
        }

        public String toString() {
            return "*any*";
        }
    }
}

