/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.ValueRange;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.PathValue;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface KeySpacePath {
    default public int size() {
        int size = 0;
        for (KeySpacePath root = this; root != null; root = root.getParent()) {
            ++size;
        }
        return size;
    }

    @Nonnull
    public KeySpacePath add(@Nonnull String var1);

    @Nonnull
    public KeySpacePath add(@Nonnull String var1, @Nullable Object var2);

    @Deprecated
    @Nullable
    @API(value=API.Status.DEPRECATED)
    public Tuple getRemainder();

    @Nullable
    public KeySpacePath getParent();

    @Nonnull
    public String getDirectoryName();

    @Nonnull
    public KeySpaceDirectory getDirectory();

    @Nullable
    public Object getValue();

    @Nonnull
    public CompletableFuture<PathValue> resolveAsync(@Nonnull FDBRecordContext var1);

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    public PathValue getStoredValue();

    @Deprecated
    @API(value=API.Status.DEPRECATED)
    public boolean hasStoredValue();

    @Nonnull
    default public Tuple toTuple(@Nonnull FDBRecordContext context) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_PATH_RESOLVE, this.toTupleAsync(context));
    }

    @Nonnull
    public CompletableFuture<Tuple> toTupleAsync(@Nonnull FDBRecordContext var1);

    @Nonnull
    public CompletableFuture<ResolvedKeySpacePath> toResolvedPathAsync(@Nonnull FDBRecordContext var1);

    @Nonnull
    default public ResolvedKeySpacePath toResolvedPath(@Nonnull FDBRecordContext context) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_PATH_RESOLVE, this.toResolvedPathAsync(context));
    }

    default public Subspace toSubspace(FDBRecordContext context) {
        return new Subspace(this.toTuple(context));
    }

    @Nonnull
    default public CompletableFuture<Subspace> toSubspaceAsync(@Nonnull FDBRecordContext context) {
        return this.toTupleAsync(context).thenApply(Subspace::new);
    }

    @Nonnull
    public List<KeySpacePath> flatten();

    @Nonnull
    public CompletableFuture<Boolean> hasDataAsync(FDBRecordContext var1);

    default public boolean hasData(@Nonnull FDBRecordContext context) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_SCAN, this.hasDataAsync(context));
    }

    @Nonnull
    public CompletableFuture<Void> deleteAllDataAsync(@Nonnull FDBRecordContext var1);

    default public void deleteAllData(@Nonnull FDBRecordContext context) {
        context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_CLEAR, this.deleteAllDataAsync(context));
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    default public RecordCursor<KeySpacePath> listAsync(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.listAsync(context, subdirName, null, continuation, scanProperties);
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    public RecordCursor<KeySpacePath> listAsync(@Nonnull FDBRecordContext var1, @Nonnull String var2, @Nullable ValueRange<?> var3, @Nullable byte[] var4, @Nonnull ScanProperties var5);

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    default public List<KeySpacePath> list(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nonnull ScanProperties scanProperties) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_LIST, this.listAsync(context, subdirName, null, scanProperties).asList());
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    default public List<KeySpacePath> list(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable ValueRange<?> range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_LIST, this.listAsync(context, subdirName, range, continuation, scanProperties).asList());
    }

    @Deprecated
    @Nonnull
    @API(value=API.Status.DEPRECATED)
    default public List<KeySpacePath> list(@Nonnull FDBRecordContext context, @Nonnull String subdirName) {
        return this.list(context, subdirName, ScanProperties.FORWARD_SCAN);
    }

    @Nonnull
    public RecordCursor<ResolvedKeySpacePath> listSubdirectoryAsync(@Nonnull FDBRecordContext var1, @Nonnull String var2, @Nullable ValueRange<?> var3, @Nullable byte[] var4, @Nonnull ScanProperties var5);

    @Nonnull
    default public RecordCursor<ResolvedKeySpacePath> listSubdirectoryAsync(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.listSubdirectoryAsync(context, subdirName, null, continuation, scanProperties);
    }

    @Nonnull
    default public List<ResolvedKeySpacePath> listSubdirectory(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable ValueRange<?> range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_LIST, this.listSubdirectoryAsync(context, subdirName, range, continuation, scanProperties).asList());
    }

    @Nonnull
    default public List<ResolvedKeySpacePath> listSubdirectory(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable ValueRange<?> range, @Nonnull ScanProperties scanProperties) {
        return this.listSubdirectory(context, subdirName, range, null, scanProperties);
    }

    @Nonnull
    default public List<ResolvedKeySpacePath> listSubdirectory(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nonnull ScanProperties scanProperties) {
        return this.listSubdirectory(context, subdirName, null, null, scanProperties);
    }

    @Nonnull
    default public List<ResolvedKeySpacePath> listSubdirectory(@Nonnull FDBRecordContext context, @Nonnull String subdirName) {
        return this.listSubdirectory(context, subdirName, null, null, ScanProperties.FORWARD_SCAN);
    }

    @API(value=API.Status.UNSTABLE)
    public String toString(@Nonnull Tuple var1);
}

