/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.ValueRange;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.PathValue;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class KeySpacePathImpl
implements KeySpacePath {
    @Nonnull
    protected final KeySpaceDirectory directory;
    @Nullable
    protected final KeySpacePath parent;
    @Nullable
    private final Object value;
    private final boolean wasFromTuple;
    @Nullable
    private final PathValue resolvedPathValue;
    @Nullable
    protected final Tuple remainder;

    private KeySpacePathImpl(@Nullable KeySpacePath parent, @Nonnull KeySpaceDirectory directory, @Nullable Object value, boolean wasFromTuple, @Nullable PathValue resolvedPathValue, @Nullable Tuple remainder) {
        if (!(wasFromTuple || resolvedPathValue == null && remainder == null)) {
            throw new IllegalArgumentException("Paths that weren't resolved from a tuple cannot provide storage information!");
        }
        this.directory = directory;
        this.value = value;
        this.parent = parent;
        this.wasFromTuple = wasFromTuple;
        this.resolvedPathValue = resolvedPathValue;
        this.remainder = remainder;
    }

    @Nonnull
    static KeySpacePath newPath(@Nullable KeySpacePath parent, @Nonnull KeySpaceDirectory directory, @Nullable Object value, boolean wasFromTuple, @Nullable PathValue resolvedPathValue, @Nullable Tuple remainder) {
        return directory.wrap(new KeySpacePathImpl(parent, directory, value, wasFromTuple, resolvedPathValue, remainder));
    }

    @Nonnull
    static KeySpacePath newPath(@Nullable KeySpacePath parent, @Nonnull KeySpaceDirectory directory) {
        return directory.wrap(new KeySpacePathImpl(parent, directory, directory.getValue(), false, null, null));
    }

    @Override
    @Nonnull
    public KeySpacePath add(@Nonnull String dirName) {
        KeySpaceDirectory nextDir = this.directory.getSubdirectory(dirName);
        if (nextDir.getValue() == KeySpaceDirectory.ANY_VALUE) {
            throw new RecordCoreArgumentException("Directory requires an explicit value", "dir_name", nextDir.getName());
        }
        return this.add(dirName, nextDir.getValue());
    }

    @Override
    @Nonnull
    public KeySpacePath add(@Nonnull String dirName, @Nullable Object value) {
        KeySpaceDirectory subdir = this.directory.getSubdirectory(dirName);
        return subdir.wrap(new KeySpacePathImpl(this.self(), subdir, value, false, null, null));
    }

    @Override
    @Deprecated
    @Nonnull
    public RecordCursor<KeySpacePath> listAsync(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable ValueRange<?> range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.directory.listSubdirectoryAsync(this.self(), context, subdirName, range, continuation, scanProperties).map(ResolvedKeySpacePath::toPath);
    }

    @Override
    @Nonnull
    public RecordCursor<ResolvedKeySpacePath> listSubdirectoryAsync(@Nonnull FDBRecordContext context, @Nonnull String subdirName, @Nullable ValueRange<?> range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.directory.listSubdirectoryAsync(this.self(), context, subdirName, range, continuation, scanProperties);
    }

    @Override
    @Deprecated
    @Nullable
    public Tuple getRemainder() {
        return this.remainder;
    }

    @Override
    @Nullable
    public KeySpacePath getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public String getDirectoryName() {
        return this.directory.getName();
    }

    @Override
    @Nonnull
    public KeySpaceDirectory getDirectory() {
        return this.directory;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Override
    @Deprecated
    @Nonnull
    public PathValue getStoredValue() {
        if (!this.wasFromTuple) {
            throw new IllegalStateException("Path must be produced using pathFromKey() or list()");
        }
        return this.resolvedPathValue;
    }

    @Override
    @Deprecated
    public boolean hasStoredValue() {
        return this.wasFromTuple;
    }

    @Override
    @Nonnull
    public CompletableFuture<PathValue> resolveAsync(@Nonnull FDBRecordContext context) {
        if (this.wasFromTuple) {
            return CompletableFuture.completedFuture(this.resolvedPathValue);
        }
        return this.getDirectory().toTupleValueAsync(context, this.getValue());
    }

    @Override
    @Nonnull
    public List<KeySpacePath> flatten() {
        ArrayList<KeySpacePath> reversePath = new ArrayList<KeySpacePath>();
        for (KeySpacePath current = this.self(); current != null; current = current.getParent()) {
            reversePath.add(current);
        }
        return Lists.reverse(reversePath);
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> toTupleAsync(@Nonnull FDBRecordContext context) {
        List work = this.flatten().stream().map(entry -> entry.resolveAsync(context).thenApply(PathValue::getResolvedValue)).collect(Collectors.toList());
        return AsyncUtil.getAll(work).thenApply(Tuple::fromList);
    }

    @Override
    @Nonnull
    public CompletableFuture<ResolvedKeySpacePath> toResolvedPathAsync(@Nonnull FDBRecordContext context) {
        List<KeySpacePath> flatPath = this.flatten();
        List work = flatPath.stream().map(entry -> entry.resolveAsync(context)).collect(Collectors.toList());
        return AsyncUtil.getAll(work).thenApply(pathValues -> {
            ResolvedKeySpacePath current = null;
            for (int i = 0; i < pathValues.size(); ++i) {
                KeySpacePath path = (KeySpacePath)flatPath.get(i);
                current = new ResolvedKeySpacePath(current, path.getDirectory().wrap(path), (PathValue)pathValues.get(i), null);
            }
            return current;
        });
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> hasDataAsync(@Nonnull FDBRecordContext context) {
        return this.toTupleAsync(context).thenCompose(tuple -> {
            byte[] rangeStart = tuple.pack();
            byte[] rangeEnd = ByteArrayUtil.strinc(rangeStart);
            return context.ensureActive().getRange(rangeStart, rangeEnd, 1).iterator().onHasNext();
        });
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> deleteAllDataAsync(@Nonnull FDBRecordContext context) {
        context.setDirtyStoreState(true);
        context.setMetaDataVersionStamp();
        return this.toTupleAsync(context).thenApply(tuple -> {
            byte[] rangeStart = tuple.pack();
            byte[] rangeEnd = ByteArrayUtil.strinc(rangeStart);
            context.clear(new Range(rangeStart, rangeEnd));
            return null;
        });
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeySpacePath)) {
            return false;
        }
        KeySpacePath that = (KeySpacePath)obj;
        boolean directoriesEqual = Objects.equals((Object)this.getDirectory().getKeyType(), (Object)that.getDirectory().getKeyType()) && Objects.equals(this.getDirectory().getName(), that.getDirectory().getName()) && Objects.equals(this.getDirectory().getValue(), that.getDirectory().getValue());
        return directoriesEqual && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getParent(), that.getParent());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getDirectory().getKeyType(), this.getDirectory().getName(), this.getDirectory().getValue(), this.getValue(), this.parent});
    }

    @Override
    public String toString(@Nullable Tuple t2) {
        Iterator<Object> it = null;
        if (t2 != null) {
            it = t2.getItems().iterator();
        }
        StringBuilder sb = new StringBuilder();
        for (KeySpacePath entry : this.flatten()) {
            sb.append('/').append(entry.getDirectoryName()).append(':');
            Object dirValue = entry.getValue();
            Object storedValue = null;
            if (it != null && it.hasNext()) {
                storedValue = it.next();
            } else if (entry.hasStoredValue()) {
                storedValue = entry.getStoredValue().getResolvedValue();
            }
            if (storedValue != null && !Objects.equals(dirValue, storedValue)) {
                ResolvedKeySpacePath.appendValue(sb, storedValue);
                sb.append("->");
            }
            ResolvedKeySpacePath.appendValue(sb, dirValue);
        }
        if (this.getRemainder() != null) {
            sb.append('+').append(this.getRemainder());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    @Nonnull
    private KeySpacePath self() {
        return this.directory.wrap(this);
    }
}

