/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreKeyspace;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KeySpaceTreeResolver {
    private static final CompletableFuture<Resolved> UNRESOLVED = CompletableFuture.completedFuture(null);
    private static final CompletableFuture<RecordMetaData> NO_META_DATA = CompletableFuture.completedFuture(null);

    @Nullable
    public FDBRecordContext getContext() {
        return null;
    }

    public CompletableFuture<ResolvedAndRemainder> resolveKeySpacePath(@Nonnull KeySpace keySpace, @Nonnull Tuple tuple) {
        return this.resolvePathAndRemainder(new ResolvedRoot(keySpace), tuple);
    }

    public CompletableFuture<ResolvedAndRemainder> resolvePathAndRemainder(@Nonnull Resolved resolvedSubRoot, @Nonnull Tuple tuple) {
        AtomicReference<Resolved> current = new AtomicReference<Resolved>(resolvedSubRoot);
        AtomicInteger index = new AtomicInteger(0);
        return AsyncUtil.whileTrue(() -> {
            if (index.get() >= tuple.size()) {
                return AsyncUtil.READY_FALSE;
            }
            return this.resolve((Resolved)current.get(), tuple.get(index.get())).thenApply(resolved -> {
                if (resolved == null) {
                    return false;
                }
                current.set((Resolved)resolved);
                index.incrementAndGet();
                return true;
            });
        }).thenApply(vignore -> new ResolvedAndRemainder((Resolved)current.get(), TupleHelpers.subTuple(tuple, index.get(), tuple.size())));
    }

    public CompletableFuture<Resolved> resolve(@Nonnull Resolved resolvedParent, @Nullable Object object) {
        if (resolvedParent.getDirectory() != null) {
            if (resolvedParent.getDirectory().getSubdirectories().isEmpty()) {
                if (this.isRecordStoreLeaf(resolvedParent, object)) {
                    FDBRecordStoreKeyspace recordStoreKeyspace;
                    if (object == null) {
                        recordStoreKeyspace = FDBRecordStoreKeyspace.STORE_INFO;
                    } else {
                        try {
                            recordStoreKeyspace = FDBRecordStoreKeyspace.fromKey(object);
                        }
                        catch (RecordCoreException ex2) {
                            return UNRESOLVED;
                        }
                    }
                    if (recordStoreKeyspace != FDBRecordStoreKeyspace.STORE_INFO) {
                        return this.getRecordStoreMetaData(resolvedParent, object).thenApply(metaData -> new ResolvedRecordStoreKeyspace(resolvedParent, recordStoreKeyspace, (RecordMetaData)metaData, object));
                    }
                    return CompletableFuture.completedFuture(new ResolvedRecordStoreKeyspace(resolvedParent, recordStoreKeyspace, null, object));
                }
            } else {
                FDBRecordContext context = this.getContext();
                if (context == null) {
                    return UNRESOLVED;
                }
                try {
                    return resolvedParent.getDirectory().findChildForValue(context, resolvedParent.getResolvedPath(), object).handle((resolved, ex) -> resolved == null ? null : new ResolvedPath(resolvedParent, (ResolvedKeySpacePath)resolved));
                }
                catch (RecordCoreException ex3) {
                    return UNRESOLVED;
                }
            }
        }
        return this.resolveNonDirectory(resolvedParent, object);
    }

    protected CompletableFuture<Resolved> resolveNonDirectory(@Nonnull Resolved resolvedParent, @Nullable Object object) {
        Index index;
        List<KeyExpression> storedKeys;
        List<KeyExpression> storedPrimaryKeys;
        int distance = 0;
        ResolvedRecordStoreKeyspace recordStoreKeyspace = null;
        ResolvedRecordTypeKeyspace recordTypeKeyspace = null;
        Resolved indexKeyspace = null;
        for (Resolved resolved = resolvedParent; resolved != null && resolved.getDirectory() == null; resolved = resolved.getParent()) {
            if (resolved instanceof ResolvedRecordTypeKeyspace) {
                recordTypeKeyspace = (ResolvedRecordTypeKeyspace)resolved;
                break;
            }
            if (resolved instanceof ResolvedIndexKeyspace) {
                indexKeyspace = (ResolvedIndexKeyspace)resolved;
                break;
            }
            if (resolved instanceof ResolvedRecordStoreKeyspace) {
                recordStoreKeyspace = (ResolvedRecordStoreKeyspace)resolved;
                break;
            }
            ++distance;
        }
        if (recordStoreKeyspace != null && recordStoreKeyspace.getRecordMetaData() != null) {
            switch (recordStoreKeyspace.getRecordStoreKeyspace()) {
                case RECORD: {
                    List<KeyExpression> storedPrimaryKeys2;
                    if (distance == 0 && object != null && recordStoreKeyspace.getRecordMetaData().primaryKeyHasRecordTypePrefix()) {
                        RecordType recordType;
                        try {
                            recordType = recordStoreKeyspace.getRecordMetaData().getRecordTypeFromRecordTypeKey(object);
                        }
                        catch (RecordCoreException ex) {
                            break;
                        }
                        return CompletableFuture.completedFuture(new ResolvedRecordTypeKeyspace(resolvedParent, recordType));
                    }
                    KeyExpression commonPrimaryKey = recordStoreKeyspace.getRecordMetaData().commonPrimaryKey();
                    if (commonPrimaryKey == null || distance >= (storedPrimaryKeys2 = commonPrimaryKey.normalizeKeyForPositions()).size()) break;
                    return this.resolvePrimaryKeyField(resolvedParent, object, storedPrimaryKeys2.get(distance), distance);
                }
                case INDEX: 
                case INDEX_SECONDARY_SPACE: 
                case INDEX_RANGE_SPACE: 
                case INDEX_UNIQUENESS_VIOLATIONS_SPACE: 
                case INDEX_BUILD_SPACE: {
                    Index index2;
                    if (distance != 0 || object == null) break;
                    try {
                        index2 = recordStoreKeyspace.getRecordMetaData().getIndexFromSubspaceKey(object);
                    }
                    catch (RecordCoreException ex) {
                        break;
                    }
                    return CompletableFuture.completedFuture(new ResolvedIndexKeyspace(resolvedParent, index2));
                }
            }
        }
        if (recordTypeKeyspace != null && distance + 1 < (storedPrimaryKeys = recordTypeKeyspace.getRecordType().getPrimaryKey().normalizeKeyForPositions()).size()) {
            return this.resolvePrimaryKeyField(resolvedParent, object, storedPrimaryKeys.get(distance + 1), distance + 1);
        }
        if (indexKeyspace != null && indexKeyspace.getParent() instanceof ResolvedRecordStoreKeyspace && ((ResolvedRecordStoreKeyspace)indexKeyspace.getParent()).getRecordStoreKeyspace() == FDBRecordStoreKeyspace.INDEX && distance < (storedKeys = this.indexStoredKeys(index = ((ResolvedIndexKeyspace)indexKeyspace).getIndex())).size()) {
            return this.resolveIndexField(resolvedParent, object, index, storedKeys.get(distance), distance);
        }
        return UNRESOLVED;
    }

    protected List<KeyExpression> indexStoredKeys(@Nonnull Index index) {
        KeyExpression storedKey = index.getRootExpression();
        if (storedKey instanceof GroupingKeyExpression) {
            storedKey = "rank".equals(index.getType()) || "time_window_leaderboard".equals(index.getType()) ? ((GroupingKeyExpression)storedKey).getWholeKey() : ((GroupingKeyExpression)storedKey).getGroupingSubKey();
        }
        if ("time_window_leaderboard".equals(index.getType())) {
            storedKey = Key.Expressions.concat(Key.Expressions.field("leaderboard"), storedKey, new KeyExpression[0]);
        }
        return storedKey.normalizeKeyForPositions();
    }

    public boolean isRecordStoreLeaf(@Nonnull Resolved resolvedParent, @Nullable Object object) {
        return false;
    }

    protected CompletableFuture<RecordMetaData> getRecordStoreMetaData(@Nonnull Resolved resolvedParent, @Nullable Object object) {
        return NO_META_DATA;
    }

    protected CompletableFuture<Resolved> resolvePrimaryKeyField(@Nonnull Resolved resolvedParent, @Nullable Object object, @Nonnull KeyExpression fieldKey, int fieldIndex) {
        return this.resolveKeyField(resolvedParent, object, fieldKey);
    }

    protected CompletableFuture<Resolved> resolveIndexField(@Nonnull Resolved resolvedParent, @Nullable Object object, @Nonnull Index index, @Nonnull KeyExpression fieldKey, int fieldIndex) {
        return this.resolveKeyField(resolvedParent, object, fieldKey);
    }

    protected CompletableFuture<Resolved> resolveKeyField(@Nonnull Resolved resolvedParent, @Nullable Object object, @Nonnull KeyExpression fieldKey) {
        while (fieldKey instanceof NestingKeyExpression) {
            fieldKey = ((NestingKeyExpression)fieldKey).getChild();
        }
        if (fieldKey instanceof FieldKeyExpression) {
            return CompletableFuture.completedFuture(new ResolvedKeyField(resolvedParent, ((FieldKeyExpression)fieldKey).getFieldName(), object, object));
        }
        return UNRESOLVED;
    }

    public static class ResolvedRoot
    extends Resolved {
        @Nonnull
        private final KeySpaceDirectory rootDirectory;

        protected ResolvedRoot(@Nullable Resolved parent, @Nonnull KeySpaceDirectory rootDirectory) {
            super(parent);
            this.rootDirectory = rootDirectory;
        }

        public ResolvedRoot(@Nonnull KeySpace keySpace) {
            this(null, keySpace.getRoot());
        }

        @Override
        @Nonnull
        public String getName() {
            return this.rootDirectory.getName();
        }

        @Override
        @Nullable
        public Object getLogicalValue() {
            return null;
        }

        @Override
        @Nullable
        public Object getResolvedValue() {
            return null;
        }

        @Override
        @Nullable
        public KeySpaceDirectory getDirectory() {
            return this.rootDirectory;
        }

        @Override
        public StringBuilder appendPathString(StringBuilder str) {
            return str;
        }
    }

    public static abstract class Resolved {
        @Nullable
        private final Resolved parent;

        protected Resolved(@Nullable Resolved parent) {
            this.parent = parent;
        }

        @Nullable
        public Resolved getParent() {
            return this.parent;
        }

        @Nonnull
        public abstract String getName();

        @Nullable
        public abstract Object getLogicalValue();

        @Nullable
        public abstract Object getResolvedValue();

        @Nullable
        public KeySpaceDirectory getDirectory() {
            return null;
        }

        @Nullable
        public ResolvedKeySpacePath getResolvedPath() {
            return null;
        }

        @Nullable
        public KeySpacePath getPath() {
            ResolvedKeySpacePath resolved = this.getResolvedPath();
            return resolved == null ? null : resolved.toPath();
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            this.appendString(str);
            return str.toString();
        }

        public String toPathString() {
            StringBuilder str = new StringBuilder();
            this.appendPathString(str);
            return str.toString();
        }

        public StringBuilder appendString(StringBuilder str) {
            str.append(this.getName()).append(':');
            ResolvedKeySpacePath.appendValue(str, this.getLogicalValue());
            if (!Objects.equals(this.getLogicalValue(), this.getResolvedValue())) {
                str.append('[');
                ResolvedKeySpacePath.appendValue(str, this.getResolvedValue());
                str.append(']');
            }
            return str;
        }

        public StringBuilder appendPathString(StringBuilder str) {
            if (this.parent != null) {
                this.parent.appendPathString(str);
            }
            str.append('/');
            this.appendString(str);
            return str;
        }
    }

    public static class ResolvedRecordStoreKeyspace
    extends Resolved {
        @Nonnull
        private final FDBRecordStoreKeyspace recordStoreKeyspace;
        @Nullable
        private final RecordMetaData recordMetaData;
        @Nullable
        private final Object object;

        public ResolvedRecordStoreKeyspace(@Nonnull Resolved parent, @Nonnull FDBRecordStoreKeyspace recordStoreKeyspace, @Nullable RecordMetaData recordMetaData, @Nullable Object object) {
            super(parent);
            this.recordStoreKeyspace = recordStoreKeyspace;
            this.recordMetaData = recordMetaData;
            this.object = object;
        }

        @Nonnull
        public FDBRecordStoreKeyspace getRecordStoreKeyspace() {
            return this.recordStoreKeyspace;
        }

        @Nullable
        public RecordMetaData getRecordMetaData() {
            return this.recordMetaData;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.recordStoreKeyspace.name();
        }

        @Override
        @Nullable
        public Object getLogicalValue() {
            return this.recordStoreKeyspace.key();
        }

        @Override
        @Nullable
        public Object getResolvedValue() {
            return this.object;
        }
    }

    public static class ResolvedRecordTypeKeyspace
    extends Resolved {
        @Nonnull
        private final RecordType recordType;

        public ResolvedRecordTypeKeyspace(@Nonnull Resolved parent, @Nonnull RecordType recordType) {
            super(parent);
            this.recordType = recordType;
        }

        @Nullable
        public RecordType getRecordType() {
            return this.recordType;
        }

        @Override
        @Nonnull
        public String getName() {
            return "record type";
        }

        @Override
        @Nullable
        public Object getLogicalValue() {
            return this.recordType.getName();
        }

        @Override
        @Nullable
        public Object getResolvedValue() {
            return this.recordType.getRecordTypeKey();
        }
    }

    public static class ResolvedIndexKeyspace
    extends Resolved {
        @Nonnull
        private final Index index;

        public ResolvedIndexKeyspace(@Nonnull Resolved parent, @Nonnull Index index) {
            super(parent);
            this.index = index;
        }

        @Nullable
        public Index getIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public String getName() {
            return "index";
        }

        @Override
        @Nullable
        public Object getLogicalValue() {
            return this.index.getName();
        }

        @Override
        @Nullable
        public Object getResolvedValue() {
            return this.index.getSubspaceKey();
        }
    }

    public static class ResolvedKeyField
    extends Resolved {
        @Nonnull
        private final String fieldName;
        @Nullable
        private final Object logicalValue;
        @Nullable
        private final Object resolvedValue;

        public ResolvedKeyField(@Nonnull Resolved parent, @Nonnull String fieldName, @Nullable Object logicalValue, @Nullable Object resolvedValue) {
            super(parent);
            this.fieldName = fieldName;
            this.logicalValue = logicalValue;
            this.resolvedValue = resolvedValue;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.fieldName;
        }

        @Override
        @Nullable
        public Object getLogicalValue() {
            return this.logicalValue;
        }

        @Override
        @Nullable
        public Object getResolvedValue() {
            return this.resolvedValue;
        }
    }

    public static class ResolvedPath
    extends Resolved {
        @Nonnull
        private final ResolvedKeySpacePath resolvedKeySpacePath;

        public ResolvedPath(@Nonnull Resolved parent, @Nonnull ResolvedKeySpacePath resolvedKeySpacePath) {
            super(parent);
            this.resolvedKeySpacePath = resolvedKeySpacePath;
        }

        @Override
        @Nullable
        public KeySpaceDirectory getDirectory() {
            return this.resolvedKeySpacePath.getDirectory();
        }

        @Override
        @Nullable
        public ResolvedKeySpacePath getResolvedPath() {
            return this.resolvedKeySpacePath;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.resolvedKeySpacePath.getDirectory().getName();
        }

        @Override
        @Nullable
        public Object getLogicalValue() {
            return this.resolvedKeySpacePath.getLogicalValue();
        }

        @Override
        @Nullable
        public Object getResolvedValue() {
            return this.resolvedKeySpacePath.getResolvedValue();
        }
    }

    public static final class ResolvedAndRemainder {
        @Nonnull
        private final Resolved resolved;
        @Nonnull
        private final Tuple remainder;

        private ResolvedAndRemainder(@Nonnull Resolved resolved, @Nonnull Tuple remainder) {
            this.resolved = resolved;
            this.remainder = remainder;
        }

        @Nonnull
        public Resolved getResolved() {
            return this.resolved;
        }

        @Nonnull
        public Tuple getRemainder() {
            return this.remainder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedAndRemainder that = (ResolvedAndRemainder)o;
            return Objects.equals(this.resolved, that.resolved) && Objects.equals(this.remainder, that.remainder);
        }

        public int hashCode() {
            return Objects.hash(this.resolved, this.remainder);
        }

        public String toString() {
            return String.valueOf(this.resolved) + "+" + String.valueOf(this.remainder);
        }
    }

    public static class ResolvedPrefixRoot
    extends ResolvedRoot {
        @Nonnull
        private final Object prefix;

        public ResolvedPrefixRoot(@Nonnull Resolved parent, @Nonnull Object prefix) {
            super(parent, parent.getDirectory());
            this.prefix = prefix;
        }

        @Override
        public String toString() {
            return this.prefix.toString();
        }
    }
}

