/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreRetriableTransactionException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ResolverStateProto;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.LazyCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverCreateHooks;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverKeyValue;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ScopedValue;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public abstract class LocatableResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocatableResolver.class);
    @Nonnull
    protected final FDBDatabase database;
    @Nonnull
    protected final ResolverLocation location;
    protected final int hashCode;

    protected LocatableResolver(@Nonnull FDBDatabase database, @Nullable KeySpacePath path, @Nullable CompletableFuture<ResolvedKeySpacePath> resolvedPath) {
        if (path == null && resolvedPath != null || resolvedPath == null && path != null) {
            throw new IllegalArgumentException("Path and resolved path must both be null or neither be null");
        }
        this.database = database;
        this.location = new ResolverLocation(path, resolvedPath);
        this.hashCode = Objects.hash(this.getClass(), path, database);
    }

    public <T> ScopedValue<T> wrap(T value) {
        return new ScopedValue<T>(value, this);
    }

    @Nonnull
    public FDBDatabase getDatabase() {
        return this.database;
    }

    private void validateDatabase(@Nonnull FDBRecordContext context) {
        if (!context.getDatabase().equals(this.database)) {
            throw new RecordCoreArgumentException("attempted to resolve value against incorrect database", new Object[0]);
        }
    }

    @Nonnull
    private <T> CompletableFuture<T> runAsync(@Nullable FDBStoreTimer timer, @Nonnull Function<FDBRecordContext, CompletableFuture<T>> retriable, Object ... additionalLogMessageKeyValues) {
        return this.database.runAsync(timer, null, (? super FDBRecordContext context) -> context.getReadVersionAsync().thenCompose(ignore -> (CompletionStage)retriable.apply((FDBRecordContext)context)), Arrays.asList(additionalLogMessageKeyValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private <T> CompletableFuture<T> runAsyncBorrowingReadVersion(@Nonnull FDBRecordContext parentContext, @Nonnull Function<FDBRecordContext, CompletableFuture<T>> retriable, Object ... additionalLogMessageKeyValues) {
        FDBDatabaseRunner runner = parentContext.newRunner();
        boolean started = false;
        try {
            AtomicBoolean first = new AtomicBoolean(true);
            CompletableFuture future = runner.runAsync(childContext -> {
                CompletionStage<Long> readVersionFuture;
                if (parentContext.isClosed()) {
                    throw new FDBDatabaseRunner.RunnerClosed();
                }
                if (first.get()) {
                    first.set(false);
                    readVersionFuture = parentContext.getReadVersionAsync().thenApply(readVersion -> {
                        childContext.setReadVersion((long)readVersion);
                        return readVersion;
                    });
                } else {
                    readVersionFuture = childContext.getReadVersionAsync();
                }
                return readVersionFuture.thenCompose(ignore -> (CompletionStage)retriable.apply((FDBRecordContext)childContext));
            }, Arrays.asList(additionalLogMessageKeyValues));
            started = true;
            CompletionStage completionStage = future.whenComplete((valIgnore, errIgnore) -> runner.close());
            return completionStage;
        }
        finally {
            if (!started) {
                runner.close();
            }
        }
    }

    private CompletableFuture<Cache<ScopedValue<String>, ResolverResult>> getDirectoryCache(@Nonnull FDBRecordContext context) {
        this.validateDatabase(context);
        return this.getVersion(context).thenApply(this.database::getDirectoryCache);
    }

    @Nonnull
    public CompletableFuture<Long> resolve(@Nonnull String name) {
        return this.resolve((FDBStoreTimer)null, name, ResolverCreateHooks.getDefault());
    }

    @Nonnull
    public CompletableFuture<Long> resolve(@Nullable FDBStoreTimer timer, @Nonnull String name) {
        return this.resolve(timer, name, ResolverCreateHooks.getDefault());
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public CompletableFuture<Long> resolve(@Nonnull FDBRecordContext context, @Nonnull String name) {
        return this.resolve(context, name, ResolverCreateHooks.getDefault());
    }

    @Nonnull
    public CompletableFuture<Long> resolve(@Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        return this.resolve((FDBStoreTimer)null, name, hooks);
    }

    @Nonnull
    public CompletableFuture<Long> resolve(@Nullable FDBStoreTimer timer, @Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        return this.resolveWithMetadata(timer, name, hooks).thenApply(ResolverResult::getValue);
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public CompletableFuture<Long> resolve(@Nonnull FDBRecordContext context, @Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        return this.resolveWithMetadata(context, name, hooks).thenApply(ResolverResult::getValue);
    }

    @Nonnull
    public CompletableFuture<ResolverResult> resolveWithMetadata(@Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        return this.resolveWithMetadata((FDBStoreTimer)null, name, hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompletableFuture<ResolverResult> resolveWithMetadata(@Nullable FDBStoreTimer timer, @Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        FDBRecordContext context = this.database.openContext(null, timer);
        boolean started = false;
        try {
            CompletableFuture<ResolverResult> future = this.resolveWithMetadata(context, name, hooks);
            started = true;
            CompletionStage completionStage = future.whenComplete((valIgnore, errIgnore) -> context.close());
            return completionStage;
        }
        finally {
            if (!started) {
                context.close();
            }
        }
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public CompletableFuture<ResolverResult> resolveWithMetadata(@Nonnull FDBRecordContext context, @Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        return this.getDirectoryCache(context).thenCompose(directoryCache -> this.resolveWithCache(context, this.wrap(name), (Cache<ScopedValue<String>, ResolverResult>)directoryCache, hooks));
    }

    @Nonnull
    public CompletableFuture<ResolverResult> mustResolveWithMetadata(@Nonnull FDBRecordContext context, @Nonnull String name) {
        return this.read(context, name).thenApply(maybeRead -> (ResolverResult)maybeRead.orElseThrow(() -> new NoSuchElementException(this.wrap(name).toString())));
    }

    public CompletableFuture<Long> mustResolve(@Nonnull FDBRecordContext context, @Nonnull String name) {
        return this.read(context, name).thenApply(maybeRead -> maybeRead.map(ResolverResult::getValue).orElseThrow(() -> new NoSuchElementException(this.wrap(name).toString())));
    }

    @Nonnull
    public CompletableFuture<String> reverseLookup(@Nullable FDBStoreTimer timer, @Nonnull Long value) {
        Cache<ScopedValue<Long>, String> inMemoryReverseCache = this.database.getReverseDirectoryInMemoryCache();
        String cachedValue = inMemoryReverseCache.getIfPresent(this.wrap(value));
        if (cachedValue != null) {
            return CompletableFuture.completedFuture(cachedValue);
        }
        FDBRecordContext context = this.database.openContext(null, timer);
        return this.reverseLookupFromDatabase(context, value).whenComplete((vignore, eignore) -> context.close());
    }

    @Nonnull
    public CompletableFuture<String> reverseLookup(@Nonnull FDBRecordContext parentContext, @Nonnull Long value) {
        Cache<ScopedValue<Long>, String> inMemoryReverseCache = this.database.getReverseDirectoryInMemoryCache();
        String cachedValue = inMemoryReverseCache.getIfPresent(this.wrap(value));
        if (cachedValue != null) {
            return CompletableFuture.completedFuture(cachedValue);
        }
        return this.reverseLookupFromDatabase(parentContext, value);
    }

    private CompletableFuture<String> reverseLookupFromDatabase(@Nonnull FDBRecordContext parentContext, @Nonnull Long value) {
        AtomicBoolean maybeStale = new AtomicBoolean(true);
        return this.runAsyncBorrowingReadVersion(parentContext, childContext -> this.readReverse((FDBRecordContext)childContext, value).thenApply(maybeRead -> {
            if (maybeStale.get()) {
                maybeStale.set(false);
                if (maybeRead.isEmpty()) {
                    throw new RecordCoreRetriableTransactionException("reverse lookup failed on potentially stale read");
                }
            }
            return maybeRead;
        }), new Object[0]).thenApply(maybeRead -> maybeRead.map(read -> {
            parentContext.getDatabase().getReverseDirectoryInMemoryCache().put(this.wrap(value), (String)read);
            return read;
        }).orElseThrow(() -> new NoSuchElementException("reverse lookup of " + String.valueOf(this.wrap(value)))));
    }

    @Nonnull
    public CompletableFuture<String> reverseLookupInTransaction(@Nonnull FDBRecordContext context, long value) {
        ScopedValue<Long> reverseCacheKey;
        Cache<ScopedValue<Long>, String> inMemoryCache = this.database.getReverseDirectoryInMemoryCache();
        String cachedString = inMemoryCache.getIfPresent(reverseCacheKey = this.wrap(value));
        if (cachedString != null) {
            return CompletableFuture.completedFuture(cachedString);
        }
        return this.readReverse(context, (Long)value).thenApply(maybeKey -> {
            if (maybeKey.isPresent()) {
                String key = (String)maybeKey.get();
                context.addPostCommit(() -> {
                    inMemoryCache.put(reverseCacheKey, key);
                    return AsyncUtil.DONE;
                });
                return key;
            }
            throw new NoSuchElementException("reverse lookup of " + String.valueOf(reverseCacheKey));
        });
    }

    private CompletableFuture<ResolverResult> resolveWithCache(@Nonnull FDBRecordContext context, @Nonnull ScopedValue<String> scopedName, @Nonnull Cache<ScopedValue<String>, ResolverResult> directoryCache, @Nonnull ResolverCreateHooks hooks) {
        ResolverResult value = directoryCache.getIfPresent(scopedName);
        if (value != null) {
            return CompletableFuture.completedFuture(value);
        }
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.DIRECTORY_READ, this.runAsyncBorrowingReadVersion(context, childContext -> this.readOrCreateValue((FDBRecordContext)childContext, (String)scopedName.getData(), hooks), new Object[]{LogMessageKeys.TRANSACTION_NAME, "LocatableResolver::readOrCreateValue", LogMessageKeys.RESOLVER, this, LogMessageKeys.RESOLVER_KEY, scopedName.getData()})).thenApply(fetched -> {
            directoryCache.put(scopedName, (ResolverResult)fetched);
            return fetched;
        });
    }

    @Nonnull
    public CompletableFuture<ResolverResult> readInTransaction(@Nonnull FDBRecordContext context, @Nonnull String name) {
        return this.getDirectoryCache(context).thenCompose(directoryCache -> {
            ScopedValue<String> scopedName = this.wrap(name);
            ResolverResult cachedValue = (ResolverResult)directoryCache.getIfPresent(scopedName);
            if (cachedValue != null) {
                return CompletableFuture.completedFuture(cachedValue);
            }
            return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.DIRECTORY_READ, this.read(context, name)).thenApply(maybeResult -> {
                ResolverResult result = maybeResult.orElse(null);
                this.addCachePostCommitIfNotError(context, (Cache<ScopedValue<String>, ResolverResult>)directoryCache, name, result, null);
                return result;
            });
        });
    }

    @Nonnull
    public CompletableFuture<ResolverResult> createInTransaction(@Nonnull FDBRecordContext context, @Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        return this.getDirectoryCache(context).thenCompose(directoryCache -> this.createIfNotLocked(context, name, hooks).whenComplete((result, err) -> this.addCachePostCommitIfNotError(context, (Cache<ScopedValue<String>, ResolverResult>)directoryCache, name, (ResolverResult)result, (Throwable)err)));
    }

    private void addCachePostCommitIfNotError(@Nonnull FDBRecordContext context, @Nonnull Cache<ScopedValue<String>, ResolverResult> directoryCache, @Nonnull String name, @Nullable ResolverResult result, @Nullable Throwable err) {
        if (result != null && err == null) {
            context.addPostCommit(() -> {
                ScopedValue<String> scopedName = this.wrap(name);
                directoryCache.put(scopedName, result);
                return AsyncUtil.DONE;
            });
        }
    }

    private CompletableFuture<ResolverResult> readOrCreateValue(@Nonnull FDBRecordContext context, @Nonnull String name, @Nonnull ResolverCreateHooks hooks) {
        return this.read(context, name).thenCompose(maybeRead -> maybeRead.map(CompletableFuture::completedFuture).orElseGet(() -> this.createIfNotLocked(context, name, hooks)));
    }

    private CompletableFuture<ResolverResult> createIfNotLocked(@Nonnull FDBRecordContext context, @Nonnull String key, @Nonnull ResolverCreateHooks hooks) {
        List checks = hooks.getPreWriteChecks().stream().map(hook -> (CompletableFuture)hook.apply(context, this)).collect(Collectors.toList());
        byte[] metadata = (byte[])hooks.getMetadataHook().apply(key);
        return ((CompletableFuture)((CompletableFuture)AsyncUtil.getAll(checks).thenCompose(checkValues -> {
            if (checkValues.contains(false)) {
                throw new LocatableResolverLockedException("prewrite check failed").addLogInfo(new Object[]{LogMessageKeys.RESOLVER_PATH, this.location}).addLogInfo(new Object[]{LogMessageKeys.RESOLVER_KEY, key});
            }
            return this.loadResolverState(context);
        })).thenCombine(this.getResolverState(context), (readState, cachedState) -> {
            if (!readState.equals(cachedState) && LOGGER.isWarnEnabled()) {
                LOGGER.warn(KeyValueLogMessage.of("cached state and read stated differ", new Object[]{LogMessageKeys.RESOLVER_KEY, key, LogMessageKeys.RESOLVER_PATH, this.location, LogMessageKeys.CACHED_STATE, cachedState, LogMessageKeys.READ_STATE, readState}));
            }
            return readState;
        })).thenCompose(state -> {
            if (state.getLock() != ResolverStateProto.WriteLock.UNLOCKED) {
                throw new LocatableResolverLockedException("locatable resolver is not writable").addLogInfo(new Object[]{LogMessageKeys.RESOLVER_KEY, key}).addLogInfo(new Object[]{LogMessageKeys.RESOLVER_PATH, this.location}).addLogInfo("lockState", (Object)state.getLock());
            }
            return this.create(context, key, metadata);
        });
    }

    @Nonnull
    public CompletableFuture<ResolverStateProto.State> loadResolverState(@Nonnull FDBRecordContext context) {
        return context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.RESOLVER_STATE_READ, this.getStateSubspaceAsync().thenCompose(stateSubspace -> context.ensureActive().get(stateSubspace.pack()).thenApply(LocatableResolver::deserializeResolverState)));
    }

    @Nonnull
    private CompletableFuture<ResolverStateProto.State> getResolverState(@Nullable FDBStoreTimer timer) {
        return this.database.getStateForResolver(this, () -> this.runAsync(timer, this::loadResolverState, new Object[]{LogMessageKeys.TRANSACTION_NAME, "LocatableResolver::loadResolverState", LogMessageKeys.RESOLVER, this, LogMessageKeys.SHARED_READ_VERSION, false}));
    }

    @Nonnull
    private CompletableFuture<ResolverStateProto.State> getResolverState(@Nonnull FDBRecordContext context) {
        return this.database.getStateForResolver(this, () -> this.runAsyncBorrowingReadVersion(context, this::loadResolverState, new Object[]{LogMessageKeys.TRANSACTION_NAME, "LocatableResolver::loadResolverState", LogMessageKeys.RESOLVER, this, LogMessageKeys.SHARED_READ_VERSION, true}));
    }

    @Nonnull
    public CompletableFuture<Void> exclusiveLock() {
        return this.updateAndCommitResolverState(StateMutation.EXCLUSIVE_LOCK);
    }

    @Nonnull
    public CompletableFuture<Void> enableWriteLock() {
        return this.updateAndCommitResolverState(StateMutation.LOCK);
    }

    @Nonnull
    public CompletableFuture<Void> disableWriteLock() {
        return this.updateAndCommitResolverState(StateMutation.UNLOCK);
    }

    @Nonnull
    public CompletableFuture<Void> retireLayer() {
        return this.updateAndCommitResolverState(StateMutation.RETIRE);
    }

    @Nonnull
    public CompletableFuture<Void> incrementVersion() {
        return this.updateAndCommitResolverState(StateMutation.INCREMENT_VERSION);
    }

    @Nonnull
    public CompletableFuture<Integer> getVersion(@Nullable FDBStoreTimer timer) {
        return this.runAsync(timer, this::getVersion, new Object[]{LogMessageKeys.TRANSACTION_NAME, "LocatableResolver::getVersion", LogMessageKeys.RESOLVER, this});
    }

    @Nonnull
    private CompletableFuture<Integer> getVersion(@Nonnull FDBRecordContext context) {
        return this.getResolverState(context).thenApply(ResolverStateProto.State::getVersion);
    }

    @Nonnull
    public CompletableFuture<Boolean> retired(@Nullable FDBStoreTimer timer) {
        return this.getResolverState(timer).thenApply(state -> state.getLock() == ResolverStateProto.WriteLock.RETIRED);
    }

    @Nonnull
    public CompletableFuture<Boolean> retiredSkipCache(@Nonnull FDBRecordContext context) {
        return this.loadResolverState(context).thenApply(state -> state.getLock() == ResolverStateProto.WriteLock.RETIRED);
    }

    @Nonnull
    public CompletableFuture<Void> updateMetadataAndVersion(@Nonnull String key, @Nullable byte[] metadata) {
        return this.runAsync(null, context -> this.updateMetadata((FDBRecordContext)context, key, metadata).thenCompose(ignore -> this.updateResolverState((FDBRecordContext)context, StateMutation.INCREMENT_VERSION)), new Object[]{LogMessageKeys.TRANSACTION_NAME, "LocatableResolver::updateMetadataAndVersion", LogMessageKeys.RESOLVER, this, LogMessageKeys.RESOLVER_KEY, key});
    }

    @Nonnull
    public CompletableFuture<Void> saveResolverState(@Nonnull FDBRecordContext context, @Nonnull ResolverStateProto.State newState) {
        return this.loadResolverState(context).thenCompose(oldState -> {
            if (newState.equals(oldState)) {
                return AsyncUtil.DONE;
            }
            if (oldState.getVersion() > newState.getVersion()) {
                throw new RecordCoreArgumentException("resolver state version must monotonically increase", new Object[0]);
            }
            return this.writeResolverState(context, newState);
        });
    }

    private CompletableFuture<Void> updateAndCommitResolverState(@Nonnull StateMutation mutation) {
        return this.runAsync(null, context -> this.updateResolverState((FDBRecordContext)context, mutation), new Object[]{LogMessageKeys.TRANSACTION_NAME, "LocatableResolver::updateAndCommitResolverState", LogMessageKeys.RESOLVER, this, LogMessageKeys.MUTATION, mutation});
    }

    private CompletableFuture<Void> updateResolverState(@Nonnull FDBRecordContext context, @Nonnull StateMutation mutation) {
        return ((CompletableFuture)this.loadResolverState(context).thenApply(x$0 -> mutation.apply((ResolverStateProto.State)x$0))).thenCompose(newState -> this.writeResolverState(context, (ResolverStateProto.State)newState));
    }

    private CompletableFuture<Void> writeResolverState(@Nonnull FDBRecordContext context, @Nonnull ResolverStateProto.State newState) {
        return ((CompletableFuture)this.getStateSubspaceAsync().thenApply(Subspace::getKey)).thenApply(stateKey -> {
            context.ensureActive().set((byte[])stateKey, newState.toByteArray());
            return null;
        });
    }

    public RecordCursor<ResolverKeyValue> scan(@Nonnull FDBRecordContext context, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return new LazyCursor<ResolverKeyValue>((CompletableFuture<RecordCursor<ResolverKeyValue>>)this.getMappingSubspaceAsync().thenApply(mappingSubspace -> ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(mappingSubspace).setScanProperties(scanProperties)).setContext(context)).setContinuation(continuation)).build().map(keyValue -> new ResolverKeyValue(mappingSubspace.unpack(keyValue.getKey()).getString(0), this.deserializeValue(keyValue.getValue())))), context.getExecutor());
    }

    protected abstract CompletableFuture<Optional<ResolverResult>> read(@Nonnull FDBRecordContext var1, String var2);

    protected abstract CompletableFuture<ResolverResult> create(@Nonnull FDBRecordContext var1, @Nonnull String var2, @Nullable byte[] var3);

    protected final CompletableFuture<ResolverResult> create(@Nonnull FDBRecordContext context, @Nonnull String key) {
        return this.create(context, key, null);
    }

    protected CompletableFuture<Optional<String>> readReverse(@Nonnull FDBRecordContext context, Long value) {
        return this.readReverse(context.getTimer(), value);
    }

    @Deprecated
    protected abstract CompletableFuture<Optional<String>> readReverse(FDBStoreTimer var1, Long var2);

    protected abstract CompletableFuture<Void> updateMetadata(FDBRecordContext var1, String var2, byte[] var3);

    protected abstract CompletableFuture<Void> setMapping(FDBRecordContext var1, String var2, ResolverResult var3);

    @VisibleForTesting
    public final CompletableFuture<Void> setMapping(FDBRecordContext context, String key, Long value) {
        return this.setMapping(context, key, new ResolverResult(value));
    }

    @VisibleForTesting
    public abstract CompletableFuture<Void> setWindow(long var1);

    protected abstract CompletableFuture<Subspace> getStateSubspaceAsync();

    @Nonnull
    public abstract CompletableFuture<Subspace> getMappingSubspaceAsync();

    @Nonnull
    public abstract CompletableFuture<Subspace> getBaseSubspaceAsync();

    @Nonnull
    public abstract ResolverResult deserializeValue(byte[] var1);

    @VisibleForTesting
    @API(value=API.Status.INTERNAL)
    protected abstract CompletableFuture<Void> deleteReverseForTesting(@Nonnull FDBRecordContext var1, long var2);

    @API(value=API.Status.INTERNAL)
    protected abstract CompletableFuture<Void> putReverse(@Nonnull FDBRecordContext var1, long var2, @Nonnull String var4);

    @Nonnull
    private static ResolverStateProto.State deserializeResolverState(@Nullable byte[] bytes) {
        if (bytes != null) {
            try {
                return ResolverStateProto.State.parseFrom(bytes);
            }
            catch (InvalidProtocolBufferException exception) {
                throw new RecordCoreException("invalid state value", exception).addLogInfo("valueBytes", (Object)ByteArrayUtil2.loggable(bytes));
            }
        }
        return ResolverStateProto.State.newBuilder().build();
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.location.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocatableResolver that = (LocatableResolver)this.getClass().cast(obj);
        return Objects.equals(this.database, that.database) && this.location.equals(that.location);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static class ResolverLocation {
        @Nullable
        KeySpacePath path;
        @Nullable
        ResolvedKeySpacePath resolvedKeySpacePath;

        public ResolverLocation(@Nullable KeySpacePath path, @Nullable CompletableFuture<ResolvedKeySpacePath> resolvedFuture) {
            if (resolvedFuture != null && resolvedFuture.isDone() && !resolvedFuture.isCompletedExceptionally()) {
                this.resolvedKeySpacePath = resolvedFuture.join();
            }
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolverLocation that = (ResolverLocation)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return this.path == null ? 0 : this.path.hashCode();
        }

        public String toString() {
            if (this.resolvedKeySpacePath != null) {
                return this.resolvedKeySpacePath.toString();
            }
            if (this.path != null) {
                return this.path.toString();
            }
            return "GLOBAL";
        }
    }

    private static enum StateMutation {
        LOCK(state -> state.toBuilder().setLock(ResolverStateProto.WriteLock.WRITE_LOCKED).build()),
        UNLOCK(state -> state.toBuilder().setLock(ResolverStateProto.WriteLock.UNLOCKED).build()),
        RETIRE(state -> state.toBuilder().setLock(ResolverStateProto.WriteLock.RETIRED).build()),
        INCREMENT_VERSION(state -> state.toBuilder().setVersion(state.getVersion() + 1).build()),
        EXCLUSIVE_LOCK(state -> {
            if (state.getLock() != ResolverStateProto.WriteLock.UNLOCKED) {
                throw new LocatableResolverLockedException("resolver must be unlocked to get exclusive lock").addLogInfo("lockState", (Object)state.getLock());
            }
            return LOCK.apply((ResolverStateProto.State)state);
        });

        @Nonnull
        @SpotBugsSuppressWarnings(value={"SE_BAD_FIELD"})
        private final Function<ResolverStateProto.State, ResolverStateProto.State> mutation;

        private StateMutation(Function<ResolverStateProto.State, ResolverStateProto.State> mutation) {
            this.mutation = mutation;
        }

        @Nonnull
        private ResolverStateProto.State apply(ResolverStateProto.State state) {
            return this.mutation.apply(state);
        }
    }

    public static class LocatableResolverLockedException
    extends RecordCoreException {
        LocatableResolverLockedException(String message) {
            super(message, new Object[0]);
        }
    }
}

