/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.PathValue;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResolvedKeySpacePath {
    @Nullable
    private final ResolvedKeySpacePath parent;
    @Nonnull
    private final KeySpacePath inner;
    @Nonnull
    private final PathValue value;
    @Nullable
    private final Tuple remainder;
    @Nullable
    private Tuple cachedTuple;
    @Nullable
    private Subspace cachedSubspace;

    protected ResolvedKeySpacePath(@Nullable ResolvedKeySpacePath parent, @Nonnull KeySpacePath inner, @Nonnull PathValue value, @Nullable Tuple remainder) {
        this.parent = parent;
        this.inner = inner;
        this.value = value;
        this.remainder = remainder;
    }

    public int size() {
        return this.inner.size();
    }

    @Nullable
    public ResolvedKeySpacePath getParent() {
        return this.parent;
    }

    @Nonnull
    public String getDirectoryName() {
        return this.inner.getDirectoryName();
    }

    @Nonnull
    public KeySpaceDirectory getDirectory() {
        return this.inner.getDirectory();
    }

    @Nullable
    public Object getLogicalValue() {
        return this.inner.getValue();
    }

    @Nonnull
    public PathValue getResolvedPathValue() {
        return this.value;
    }

    @Nullable
    public Object getResolvedValue() {
        return this.value.getResolvedValue();
    }

    @Nullable
    public byte[] getResolvedMetadata() {
        return this.value.getMetadata();
    }

    @Nonnull
    public Tuple toTuple() {
        if (this.cachedTuple == null) {
            int len = this.size();
            Object[] values = new Object[len];
            ResolvedKeySpacePath current = this;
            for (int i = len - 1; i >= 0; --i) {
                values[i] = current.getResolvedValue();
                current = current.getParent();
            }
            this.cachedTuple = Tuple.from(values);
        }
        return this.cachedTuple;
    }

    @Nonnull
    public Subspace toSubspace() {
        if (this.cachedSubspace == null) {
            this.cachedSubspace = new Subspace(this.toTuple().pack());
        }
        return this.cachedSubspace;
    }

    @Nonnull
    public KeySpacePath toPath() {
        return this.inner;
    }

    @Nullable
    public Tuple getRemainder() {
        return this.remainder;
    }

    @Nonnull
    public List<ResolvedKeySpacePath> flatten() {
        int len = this.size();
        ResolvedKeySpacePath[] flat = new ResolvedKeySpacePath[len];
        ResolvedKeySpacePath current = this;
        for (int i = len - 1; i >= 0; --i) {
            flat[i] = current;
            current = current.getParent();
        }
        return Arrays.asList(flat);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResolvedKeySpacePath)) {
            return false;
        }
        ResolvedKeySpacePath otherPath = (ResolvedKeySpacePath)other;
        return this.inner.equals(otherPath.inner) && Objects.equals(this.getResolvedValue(), otherPath.getResolvedValue());
    }

    public int hashCode() {
        return Objects.hash(this.inner, this.getResolvedPathValue());
    }

    public String toString() {
        List<ResolvedKeySpacePath> path = this.flatten();
        StringBuilder sb = new StringBuilder();
        for (ResolvedKeySpacePath current : path) {
            sb.append('/').append(current.getDirectoryName()).append(':');
            ResolvedKeySpacePath.appendValue(sb, current.getLogicalValue());
            if (!Objects.equals(current.getLogicalValue(), current.getResolvedValue())) {
                sb.append('[');
                ResolvedKeySpacePath.appendValue(sb, current.getResolvedValue());
                sb.append(']');
            }
            if (current.getRemainder() == null) continue;
            sb.append('+').append(current.getRemainder());
        }
        return sb.toString();
    }

    public static void appendValue(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof String) {
            sb.append('\"').append(value).append('\"');
        } else if (value instanceof byte[]) {
            sb.append("0x");
            sb.append(ByteArrayUtil2.toHexString((byte[])value));
        } else {
            sb.append(value);
        }
    }
}

