/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.tuple.Tuple;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ResolverMappingDigest
implements AutoCloseable {
    private static final String ALGORITHM = "SHA-256";
    @Nonnull
    private final LocatableResolver resolver;
    @Nonnull
    private final FDBDatabaseRunner runner;
    private final int transactionRowLimit;

    public ResolverMappingDigest(@Nonnull LocatableResolver directoryScope) {
        this(directoryScope, 10000);
    }

    public ResolverMappingDigest(@Nonnull LocatableResolver directoryScope, int transactionRowLimit) {
        this.runner = directoryScope.getDatabase().newRunner();
        this.resolver = directoryScope;
        this.transactionRowLimit = transactionRowLimit;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    public CompletableFuture<byte[]> computeDigest() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("invalid directory layer digest algorithm", e);
        }
        FDBRecordContext context = this.runner.openContext();
        return ((CompletableFuture)this.computeInternal(context, null, messageDigest).thenCompose(continuation -> {
            context.close();
            if (continuation != null) {
                return this.computeInternal(this.runner.openContext(), (byte[])continuation, messageDigest);
            }
            return CompletableFuture.completedFuture(null);
        })).thenApply(ignore -> messageDigest.digest());
    }

    private CompletableFuture<byte[]> computeInternal(@Nonnull FDBRecordContext context, @Nullable byte[] continuation, @Nonnull MessageDigest messageDigest) {
        return this.resolver.getMappingSubspaceAsync().thenCompose(mappingSubspace -> {
            KeyValueCursor cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(mappingSubspace).setScanProperties(new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(this.transactionRowLimit).setIsolationLevel(IsolationLevel.SNAPSHOT).build()))).setContext(context)).setContinuation(continuation)).build();
            return cursor.forEachResult(result -> {
                KeyValue kv = (KeyValue)result.get();
                String key = mappingSubspace.unpack(kv.getKey()).getString(0);
                ResolverResult value = this.resolver.deserializeValue(kv.getValue());
                messageDigest.update(Tuple.from(key, value.getValue(), value.getMetadata()).pack());
            }).thenApply(result -> result.getContinuation().toBytes());
        });
    }
}

