/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class ResolverMappingReplicator
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverMappingReplicator.class);
    @Nonnull
    private final FDBDatabaseRunner runner;
    @Nonnull
    private final LocatableResolver primary;
    @Nonnull
    private final Function<byte[], ResolverResult> valueDeserializer;
    private final int transactionRowLimit;
    private final long transactionTimeLimitMillis;

    public ResolverMappingReplicator(@Nonnull LocatableResolver primary) {
        this(primary, 10000, 4000L);
    }

    public ResolverMappingReplicator(@Nonnull LocatableResolver primary, int transactionRowLimit) {
        this(primary, transactionRowLimit, 4000L);
    }

    public ResolverMappingReplicator(@Nonnull LocatableResolver primary, int transactionRowLimit, long transactionTimeLimitMillis) {
        this.runner = primary.getDatabase().newRunner();
        this.primary = primary;
        this.valueDeserializer = primary::deserializeValue;
        this.transactionRowLimit = transactionRowLimit;
        this.transactionTimeLimitMillis = transactionTimeLimitMillis;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    public void copyTo(LocatableResolver replica) {
        this.runner.asyncToSync(FDBStoreTimer.Waits.WAIT_LOCATABLE_RESOLVER_MAPPING_COPY, this.copyToAsync(replica));
    }

    public CompletableFuture<Void> copyToAsync(@Nonnull LocatableResolver replica) {
        if (!replica.getDatabase().equals(this.runner.getDatabase())) {
            throw new IllegalArgumentException("copy must be within same database");
        }
        LongAccumulator maxAccumulator = new LongAccumulator(Long::max, 0L);
        AtomicInteger counter = new AtomicInteger();
        return this.copyInternal(replica, maxAccumulator, counter).thenCompose(ignore -> replica.setWindow(maxAccumulator.get()));
    }

    private CompletableFuture<Void> copyInternal(@Nonnull LocatableResolver replica, @Nonnull LongAccumulator accumulator, @Nonnull AtomicInteger counter) {
        ExecuteProperties executeProperties = ExecuteProperties.newBuilder().setReturnedRowLimit(this.transactionRowLimit).setTimeLimit(this.transactionTimeLimitMillis).setIsolationLevel(IsolationLevel.SNAPSHOT).build();
        AtomicReference<Object> continuation = new AtomicReference<Object>(null);
        return AsyncUtil.whileTrue(() -> {
            FDBRecordContext context = this.runner.openContext();
            return this.primary.getMappingSubspaceAsync().thenCompose(primaryMappingSubspace -> {
                KeyValueCursor cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(primaryMappingSubspace).setScanProperties(new ScanProperties(executeProperties))).setContext(context)).setContinuation((byte[])continuation.get())).build();
                return ((CompletableFuture)((CompletableFuture)cursor.forEachResultAsync(result -> {
                    KeyValue kv = (KeyValue)result.get();
                    String mappedString = primaryMappingSubspace.unpack(kv.getKey()).getString(0);
                    ResolverResult mappedValue = this.valueDeserializer.apply(kv.getValue());
                    accumulator.accumulate(mappedValue.getValue());
                    counter.incrementAndGet();
                    return replica.setMapping(context, mappedString, mappedValue);
                }).thenCompose(lastResult -> context.commitAsync().thenRun(() -> {
                    byte[] nextContinuationBytes = lastResult.getContinuation().toBytes();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(KeyValueLogMessage.of("committing batch", new Object[]{LogMessageKeys.SCANNED_SO_FAR, counter.get(), LogMessageKeys.NEXT_CONTINUATION, ByteArrayUtil2.loggable(nextContinuationBytes)}));
                    }
                    continuation.set(nextContinuationBytes);
                }))).whenComplete((vignore, eignore) -> cursor.close())).thenApply(vignore -> Objects.nonNull(continuation.get()));
            });
        }, this.runner.getExecutor());
    }

    public String toString() {
        return "Replicator from: " + String.valueOf(this.primary);
    }
}

