/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ResolverResult {
    private final long value;
    @Nullable
    private final byte[] metadata;

    public ResolverResult(long value) {
        this(value, null);
    }

    public ResolverResult(long value, @Nullable byte[] metadata) {
        this.value = value;
        this.metadata = metadata == null ? null : Arrays.copyOf(metadata, metadata.length);
    }

    public long getValue() {
        return this.value;
    }

    @Nullable
    public byte[] getMetadata() {
        return this.metadata == null ? null : Arrays.copyOf(this.metadata, this.metadata.length);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResolverResult) {
            ResolverResult that = (ResolverResult)obj;
            return this.value == that.value && Arrays.equals(this.metadata, that.metadata);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.value);
        return 29 * result + 31 * Arrays.hashCode(this.metadata);
    }

    public String toString() {
        return "Value: " + this.value + ", metadata: " + ByteArrayUtil2.loggable(this.metadata);
    }
}

