/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.AutoContinuingCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBReverseDirectoryCache;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverKeyValue;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class ResolverValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverValidator.class);

    public static void validate(@Nullable FDBStoreTimer timer, @Nonnull LocatableResolver resolver, @Nonnull ExecuteProperties.Builder executeProperties, int reverseLookupPipelineSize, boolean badEntriesOnly, @Nonnull Consumer<ValidatedEntry> entryListener) {
        try (FDBDatabaseRunner runner = resolver.database.newRunner();
             AutoContinuingCursor<ValidatedEntry> cursor = new AutoContinuingCursor<ValidatedEntry>(runner, (context, continuation) -> ResolverValidator.validate(resolver, context, continuation, reverseLookupPipelineSize, false, new ScanProperties(executeProperties.build())), 3);){
            resolver.getDatabase().asyncToSync(timer, FDBStoreTimer.Waits.WAIT_VALIDATE_RESOLVER, cursor.forEach(validatedEntry -> {
                if (!badEntriesOnly || validatedEntry.getValidationResult() != ValidationResult.OK) {
                    entryListener.accept((ValidatedEntry)validatedEntry);
                }
            }));
        }
    }

    public static RecordCursor<ValidatedEntry> validate(@Nonnull LocatableResolver resolver, @Nonnull FDBRecordContext context, @Nullable byte[] continuation, boolean repairMissingEntries, @Nonnull ScanProperties scanProperties) {
        return ResolverValidator.validate(resolver, context, continuation, 10, repairMissingEntries, scanProperties);
    }

    public static RecordCursor<ValidatedEntry> validate(@Nonnull LocatableResolver resolver, @Nonnull FDBRecordContext context, @Nullable byte[] continuation, int reverseLookupPipelineSize, boolean repairMissingEntries, @Nonnull ScanProperties scanProperties) {
        return resolver.scan(context, continuation, scanProperties).mapPipelined(keyValue -> {
            if (FDBReverseDirectoryCache.REVERSE_DIRECTORY_CACHE_ENTRY.equals(keyValue.getKey())) {
                return CompletableFuture.completedFuture(new ValidatedEntry(ValidationResult.OK, (ResolverKeyValue)keyValue));
            }
            return ((CompletableFuture)resolver.reverseLookup(context, (Long)keyValue.getValue().getValue()).handle((reverseKey, exception) -> {
                if (exception != null) {
                    if (ResolverValidator.isEntryMissing(exception)) {
                        return new ValidatedEntry(ValidationResult.REVERSE_ENTRY_MISSING, (ResolverKeyValue)keyValue);
                    }
                    throw new RecordCoreException("Error reading reverse directory entry", (Throwable)exception).addLogInfo(new Object[]{LogMessageKeys.RESOLVER, resolver}).addLogInfo(new Object[]{LogMessageKeys.RESOLVER_KEY, keyValue.getKey()}).addLogInfo(new Object[]{LogMessageKeys.RESOLVER_VALUE, keyValue.getValue().getValue()}).addLogInfo(new Object[]{LogMessageKeys.RESOLVER_METADATA, ByteArrayUtil2.loggable(keyValue.getValue().getMetadata())});
                }
                if (!reverseKey.equals(keyValue.getKey())) {
                    return new ValidatedEntry(ValidationResult.REVERSE_ENTRY_MISMATCH, (ResolverKeyValue)keyValue, (String)reverseKey);
                }
                return new ValidatedEntry(ValidationResult.OK, (ResolverKeyValue)keyValue);
            })).thenCompose(validatedEntry -> {
                if (repairMissingEntries && validatedEntry.getValidationResult() != ValidationResult.OK) {
                    return ResolverValidator.repairReverseEntry(resolver, context, validatedEntry);
                }
                return CompletableFuture.completedFuture(validatedEntry);
            });
        }, reverseLookupPipelineSize);
    }

    private static CompletableFuture<ValidatedEntry> repairReverseEntry(@Nonnull LocatableResolver resolver, @Nonnull FDBRecordContext context, @Nonnull ValidatedEntry validatedEntry) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(KeyValueLogMessage.of("Repairing reverse mapping", new Object[]{LogMessageKeys.RESOLVER, resolver, LogMessageKeys.RESOLVER_KEY, validatedEntry.getKey(), LogMessageKeys.RESOLVER_VALUE, validatedEntry.getValue().getValue(), LogMessageKeys.RESOLVER_REVERSE_VALUE, validatedEntry.getReverseValue(), LogMessageKeys.VALIDATION_RESULT, validatedEntry.getValidationResult()}));
        }
        if (validatedEntry.getValidationResult() == ValidationResult.REVERSE_ENTRY_MISMATCH) {
            context.getOrCreatePostCommit("___reverseDirectoryRepair", name -> new RepairPostCommit(resolver.getDatabase()));
        }
        return resolver.putReverse(context, validatedEntry.getValue().getValue(), validatedEntry.getKey()).thenApply(vignore -> validatedEntry);
    }

    private static boolean isEntryMissing(Throwable e) {
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        return e instanceof NoSuchElementException;
    }

    public static class ValidatedEntry {
        @Nonnull
        private final ValidationResult result;
        @Nonnull
        private final ResolverKeyValue keyValue;
        @Nonnull
        private final String reverseValue;

        @API(value=API.Status.INTERNAL)
        protected ValidatedEntry(@Nonnull ValidationResult result, @Nonnull ResolverKeyValue keyValue) {
            this(result, keyValue, keyValue.getKey());
        }

        @API(value=API.Status.INTERNAL)
        protected ValidatedEntry(@Nonnull ValidationResult result, @Nonnull ResolverKeyValue keyValue, @Nonnull String reverseValue) {
            this.result = result;
            this.keyValue = keyValue;
            this.reverseValue = reverseValue;
        }

        @Nonnull
        public ValidationResult getValidationResult() {
            return this.result;
        }

        @Nonnull
        public String getKey() {
            return this.keyValue.getKey();
        }

        @Nonnull
        public ResolverResult getValue() {
            return this.keyValue.getValue();
        }

        @Nonnull
        public String getReverseValue() {
            return this.reverseValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidatedEntry that = (ValidatedEntry)o;
            return this.result == that.result && this.keyValue.equals(that.keyValue) && this.reverseValue.equals(that.reverseValue);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.result, this.keyValue, this.reverseValue});
        }

        public String toString() {
            return "BadEntry{error=" + String.valueOf((Object)this.result) + ", keyValue=" + String.valueOf(this.keyValue) + ", reverseValue=" + this.reverseValue + "}";
        }
    }

    public static enum ValidationResult {
        OK,
        REVERSE_ENTRY_MISSING,
        REVERSE_ENTRY_MISMATCH;

    }

    private static class RepairPostCommit
    implements FDBRecordContext.PostCommit {
        private final FDBDatabase database;

        public RepairPostCommit(FDBDatabase database) {
            this.database = database;
        }

        @Override
        public CompletableFuture<Void> get() {
            this.database.clearReverseDirectoryCache();
            return AsyncUtil.DONE;
        }
    }
}

