/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.keyspace;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.directory.DirectoryLayer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBReverseDirectoryCache;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.subspace.Subspace;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Bytes;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ScopedDirectoryLayer
extends LocatableResolver {
    private static final byte[] RESERVED_CONTENT_SUBSPACE_PREFIX = new byte[]{-3};
    private static final int STATE_SUBSPACE_KEY_SUFFIX = -10;
    @Nonnull
    private CompletableFuture<Subspace> baseSubspaceFuture;
    @Nonnull
    private CompletableFuture<Subspace> nodeSubspaceFuture;
    @Nonnull
    private CompletableFuture<Subspace> stateSubspaceFuture;
    @Nonnull
    private CompletableFuture<DirectoryLayer> directoryLayerFuture;
    @Nonnull
    private final Subspace contentSubspace;

    @Deprecated
    @API(value=API.Status.DEPRECATED)
    public ScopedDirectoryLayer(@Nonnull FDBRecordContext context, @Nonnull KeySpacePath path) {
        this(context.getDatabase(), path, path.toResolvedPathAsync(context));
    }

    public ScopedDirectoryLayer(@Nonnull FDBDatabase database, @Nonnull ResolvedKeySpacePath path) {
        this(database, path.toPath(), CompletableFuture.completedFuture(path));
    }

    private ScopedDirectoryLayer(@Nonnull FDBDatabase database, @Nullable KeySpacePath path, @Nullable CompletableFuture<ResolvedKeySpacePath> resolvedPath) {
        super(database, path, resolvedPath);
        if (path == null && resolvedPath == null) {
            this.baseSubspaceFuture = CompletableFuture.completedFuture(new Subspace());
            this.contentSubspace = new Subspace();
        } else {
            this.baseSubspaceFuture = resolvedPath.thenApply(ResolvedKeySpacePath::toSubspace);
            this.contentSubspace = new Subspace(RESERVED_CONTENT_SUBSPACE_PREFIX);
        }
        this.nodeSubspaceFuture = this.baseSubspaceFuture.thenApply(base -> new Subspace(Bytes.concat(base.getKey(), DirectoryLayer.DEFAULT_NODE_SUBSPACE.getKey())));
        this.stateSubspaceFuture = this.nodeSubspaceFuture.thenApply(node -> node.get(-10));
        this.directoryLayerFuture = this.nodeSubspaceFuture.thenApply(node -> new DirectoryLayer((Subspace)node, this.contentSubspace));
    }

    public static ScopedDirectoryLayer global(@Nonnull FDBDatabase database) {
        return new ScopedDirectoryLayer(database, null, null);
    }

    private CompletableFuture<Boolean> exists(@Nonnull FDBRecordContext context, String key) {
        return this.directoryLayerFuture.thenCompose(directoryLayer -> directoryLayer.exists(context.ensureActive(), Collections.singletonList(key)));
    }

    @Override
    protected CompletableFuture<ResolverResult> create(@Nonnull FDBRecordContext context, @Nonnull String key, @Nullable byte[] metadata) {
        if (metadata != null) {
            throw new IllegalArgumentException("cannot set metadata in ScopedDirectoryLayer");
        }
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.SCOPED_DIRECTORY_LAYER_CREATE, this.createInternal(context, key));
    }

    private CompletableFuture<ResolverResult> createInternal(@Nonnull FDBRecordContext context, String key) {
        FDBReverseDirectoryCache reverseCache = context.getDatabase().getReverseDirectoryCache();
        return this.directoryLayerFuture.thenCompose(directoryLayer -> ((CompletableFuture)directoryLayer.create(context.ensureActive(), Collections.singletonList(key)).thenApply(serializedValue -> this.deserializeValue(serializedValue.getKey()))).thenCompose(result -> reverseCache.putIfNotExists(context, this.wrap(key), result.getValue()).thenApply(ignore -> result)));
    }

    @Override
    protected CompletableFuture<Optional<ResolverResult>> read(@Nonnull FDBRecordContext context, String key) {
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.SCOPED_DIRECTORY_LAYER_READ, this.readInternal(context, key));
    }

    private CompletableFuture<Optional<ResolverResult>> readInternal(@Nonnull FDBRecordContext context, String key) {
        FDBReverseDirectoryCache reverseCache = context.getDatabase().getReverseDirectoryCache();
        return this.exists(context, key).thenCompose(keyExists -> keyExists != false ? this.directoryLayerFuture.thenCompose(directoryLayer -> ((CompletableFuture)((CompletableFuture)directoryLayer.open(context.ensureActive(), Collections.singletonList(key)).thenApply(serializedValue -> this.deserializeValue(serializedValue.getKey()))).thenCompose(result -> reverseCache.putIfNotExists(context, this.wrap(key), result.getValue()).thenApply(ignore -> result))).thenApply(Optional::of)) : CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    protected CompletableFuture<Optional<String>> readReverse(@Nonnull FDBRecordContext context, Long value) {
        FDBReverseDirectoryCache reverseCache = this.database.getReverseDirectoryCache();
        return reverseCache.get(context, this.wrap(value));
    }

    @Override
    @Deprecated
    protected CompletableFuture<Optional<String>> readReverse(FDBStoreTimer timer, Long value) {
        FDBReverseDirectoryCache reverseCache = this.database.getReverseDirectoryCache();
        return reverseCache.get(timer, this.wrap(value));
    }

    @Override
    @VisibleForTesting
    protected CompletableFuture<Void> deleteReverseForTesting(FDBRecordContext context, long value) {
        return this.database.getReverseDirectoryCache().deleteForTesting(context, this.wrap(value));
    }

    @Override
    protected CompletableFuture<Void> putReverse(@Nonnull FDBRecordContext context, long value, @Nonnull String key) {
        return this.database.getReverseDirectoryCache().putOrReplaceForTesting(context, this.wrap(key), value);
    }

    @Override
    public CompletableFuture<Void> setMapping(FDBRecordContext context, String key, ResolverResult value) {
        throw new UnsupportedOperationException("cannot manually add mappings to ScopedDirectoryLayer");
    }

    @Override
    public CompletableFuture<Void> updateMetadata(FDBRecordContext context, String key, byte[] metadata) {
        throw new UnsupportedOperationException("cannot update metadata in ScopedDirectoryLayer");
    }

    @Override
    public CompletableFuture<Void> setWindow(long count) {
        throw new UnsupportedOperationException("cannot manually send allocation window for ScopedDirectoryLayer");
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getMappingSubspaceAsync() {
        return this.nodeSubspaceFuture.thenApply(nodeSubspace -> nodeSubspace.get(nodeSubspace.getKey()).get(0));
    }

    @Override
    protected CompletableFuture<Subspace> getStateSubspaceAsync() {
        return this.stateSubspaceFuture;
    }

    @Override
    @Nonnull
    public ResolverResult deserializeValue(byte[] value) {
        return new ResolverResult(this.contentSubspace.unpack(value).getLong(0));
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getBaseSubspaceAsync() {
        return this.baseSubspaceFuture;
    }

    @VisibleForTesting
    public CompletableFuture<Subspace> getNodeSubspace(FDBRecordContext context) {
        return this.nodeSubspaceFuture;
    }

    @VisibleForTesting
    public Subspace getContentSubspace() {
        return this.contentSubspace;
    }
}

