/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.layers.interning;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class HighContentionAllocator {
    private static final byte[] LITTLE_ENDIAN_LONG_ONE = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] KEY_UPDATING_BYTE = new byte[0];
    private static final byte[] INVALID_ALLOCATION_VALUE = new byte[]{-3};
    private static final Function<Long, CompletableFuture<Boolean>> NOOP_CHECK = ignored -> CompletableFuture.completedFuture(true);
    private final Subspace counterSubspace;
    private final Subspace allocationSubspace;
    private final Transaction transaction;
    private final Function<Long, CompletableFuture<Boolean>> candidateCheck;

    public HighContentionAllocator(@Nonnull FDBRecordContext context, @Nonnull KeySpacePath basePath) {
        this(context, basePath, NOOP_CHECK);
    }

    public HighContentionAllocator(@Nonnull FDBRecordContext context, @Nonnull KeySpacePath basePath, @Nonnull Function<Long, CompletableFuture<Boolean>> candidateCheck) {
        this(context, basePath.toSubspace(context), candidateCheck);
    }

    public HighContentionAllocator(@Nonnull FDBRecordContext context, @Nonnull Subspace basePathSubspace, @Nonnull Function<Long, CompletableFuture<Boolean>> candidateCheck) {
        this(context, basePathSubspace.get(0), basePathSubspace.get(1), candidateCheck);
    }

    public HighContentionAllocator(@Nonnull FDBRecordContext context, @Nonnull Subspace counterSubspace, @Nonnull Subspace allocationSubspace) {
        this(context, counterSubspace, allocationSubspace, NOOP_CHECK);
    }

    protected HighContentionAllocator(@Nonnull FDBRecordContext context, @Nonnull Subspace counterSubspace, @Nonnull Subspace allocationSubspace, @Nonnull Function<Long, CompletableFuture<Boolean>> candidateCheck) {
        this.transaction = context.ensureActive();
        this.counterSubspace = counterSubspace;
        this.allocationSubspace = allocationSubspace;
        this.candidateCheck = candidateCheck;
    }

    public static HighContentionAllocator forRoot(@Nonnull FDBRecordContext context, @Nonnull Subspace counterSubspace, @Nonnull Subspace allocationSubspace) {
        return new HighContentionAllocator(context, counterSubspace, allocationSubspace, value -> HighContentionAllocator.hasConflictAtRoot(context.ensureActive(), value));
    }

    public static HighContentionAllocator forRoot(@Nonnull FDBRecordContext context, @Nonnull KeySpacePath basePath) {
        return new HighContentionAllocator(context, basePath, value -> HighContentionAllocator.hasConflictAtRoot(context.ensureActive(), value));
    }

    @VisibleForTesting
    public Subspace getAllocationSubspace() {
        return this.allocationSubspace;
    }

    public CompletableFuture<Long> allocate(String valueToStore) {
        byte[] valueBytes = Tuple.from(valueToStore).pack();
        return ((CompletableFuture)this.initialWindow().thenCompose(initialWindow -> this.chooseWindow((AllocationWindow)initialWindow, false))).thenCompose(window -> this.chooseCandidate((AllocationWindow)window, valueBytes));
    }

    private CompletableFuture<Optional<KeyValue>> currentCounter() {
        return this.transaction.snapshot().getRange(this.counterSubspace.range(), 1, true).asList().thenApply(list -> list.isEmpty() ? Optional.empty() : Optional.of((KeyValue)list.get(0)));
    }

    private CompletableFuture<AllocationWindow> initialWindow() {
        return this.currentCounter().thenApply(counter -> counter.map(kv -> AllocationWindow.startingFrom(this.counterSubspace.unpack(kv.getKey()).getLong(0))).orElse(AllocationWindow.startingFrom(0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<AllocationWindow> chooseWindow(AllocationWindow currentWindow, boolean wipeOld) {
        CompletableFuture<byte[]> newCount;
        byte[] counterKey = this.counterSubspace.pack(currentWindow.getStart());
        Range oldCounters = new Range(this.counterSubspace.getKey(), counterKey);
        Transaction transaction = this.transaction;
        synchronized (transaction) {
            if (wipeOld) {
                this.transaction.clear(oldCounters);
            }
            this.transaction.mutate(MutationType.ADD, counterKey, LITTLE_ENDIAN_LONG_ONE);
            newCount = this.transaction.snapshot().get(counterKey);
        }
        return ((CompletableFuture)newCount.thenApply(ByteArrayUtil::decodeInt)).thenCompose(count -> {
            if (count * 2L > (long)currentWindow.size()) {
                AllocationWindow newWindow = AllocationWindow.startingFrom(currentWindow.getEnd());
                return this.chooseWindow(newWindow, true);
            }
            return CompletableFuture.completedFuture(currentWindow);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Long> chooseCandidate(AllocationWindow window, byte[] valueToStore) {
        CompletableFuture<byte[]> previousAllocationValue;
        long candidate = window.random();
        byte[] allocationKey = this.allocationSubspace.pack(candidate);
        CompletableFuture<Boolean> check = this.candidateCheck.apply(candidate);
        Transaction transaction = this.transaction;
        synchronized (transaction) {
            previousAllocationValue = this.transaction.get(allocationKey);
            this.transaction.options().setNextWriteNoWriteConflictRange();
            this.transaction.set(allocationKey, KEY_UPDATING_BYTE);
        }
        return ((CompletableFuture)previousAllocationValue.thenCombine(check, (valueBytes, isGood) -> {
            if (valueBytes == null) {
                Transaction transaction = this.transaction;
                synchronized (transaction) {
                    this.transaction.set(allocationKey, isGood != false ? valueToStore : INVALID_ALLOCATION_VALUE);
                }
                if (!isGood.booleanValue()) {
                    throw new IllegalStateException("database already has keys in allocation range");
                }
                return CompletableFuture.completedFuture(candidate);
            }
            if (!Arrays.equals(valueBytes, KEY_UPDATING_BYTE)) {
                Transaction transaction = this.transaction;
                synchronized (transaction) {
                    this.transaction.options().setNextWriteNoWriteConflictRange();
                    this.transaction.set(allocationKey, (byte[])valueBytes);
                }
            }
            return this.chooseCandidate(window, valueToStore);
        })).thenCompose(Function.identity());
    }

    public void setWindow(long count) {
        this.transaction.mutate(MutationType.ADD, this.counterSubspace.pack(count), LITTLE_ENDIAN_LONG_ONE);
    }

    public void forceAllocate(@Nonnull String key, @Nonnull Long value) {
        this.transaction.set(this.allocationSubspace.pack(value), Tuple.from(key).pack());
    }

    private static CompletableFuture<Boolean> hasConflictAtRoot(Transaction context, Long value) {
        return HighContentionAllocator.hasConflictInSubspace(context, new Subspace(), value);
    }

    private static CompletableFuture<Boolean> hasConflictInSubspace(@Nonnull Transaction transaction, @Nonnull Subspace subspace, @Nonnull Long value) {
        Range checkRange = Range.startsWith(subspace.pack(value));
        return transaction.snapshot().getRange(checkRange, 1).iterator().onHasNext().thenApply(hasKeys -> hasKeys == false);
    }

    public static class AllocationWindow {
        private static Random random = new Random();
        private final long start;
        private final long end;

        private AllocationWindow(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public static AllocationWindow startingFrom(long start) {
            return new AllocationWindow(start, start + AllocationWindow.getWindowSize(start));
        }

        private static long getWindowSize(long windowBegin) {
            if (windowBegin < 255L) {
                return 64L;
            }
            if (windowBegin < 65535L) {
                return 1024L;
            }
            return 4096L;
        }

        public long random() {
            return this.start + (long)random.nextInt(this.size());
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public int size() {
            return Math.toIntExact(this.end - this.start);
        }

        public String toString() {
            return "AllocationWindow[start=" + this.start + ", end=" + this.end + "]";
        }
    }
}

