/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.layers.interning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolvedKeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.record.provider.foundationdb.layers.interning.StringInterningLayer;
import com.apple.foundationdb.subspace.Subspace;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ScopedInterningLayer
extends LocatableResolver {
    private static final byte[] GLOBAL_SCOPE_PREFIX_BYTES = new byte[]{-4};
    private static final int STATE_SUBSPACE_KEY_SUFFIX = -10;
    @Nonnull
    private CompletableFuture<Subspace> baseSubspaceFuture;
    @Nonnull
    private CompletableFuture<Subspace> nodeSubspaceFuture;
    @Nonnull
    private CompletableFuture<Subspace> stateSubspaceFuture;
    @Nonnull
    private CompletableFuture<StringInterningLayer> interningLayerFuture;

    @Deprecated
    @API(value=API.Status.DEPRECATED)
    public ScopedInterningLayer(@Nonnull FDBRecordContext context, @Nonnull KeySpacePath path) {
        this(context.getDatabase(), path, path.toResolvedPathAsync(context));
    }

    public ScopedInterningLayer(@Nonnull FDBDatabase database, @Nonnull ResolvedKeySpacePath path) {
        this(database, path.toPath(), CompletableFuture.completedFuture(path));
    }

    private ScopedInterningLayer(@Nonnull FDBDatabase database, @Nullable KeySpacePath path, @Nullable CompletableFuture<ResolvedKeySpacePath> resolvedPath) {
        super(database, path, resolvedPath);
        boolean isRootLevel;
        if (path == null && resolvedPath == null) {
            isRootLevel = true;
            this.baseSubspaceFuture = CompletableFuture.completedFuture(new Subspace());
            this.nodeSubspaceFuture = CompletableFuture.completedFuture(new Subspace(GLOBAL_SCOPE_PREFIX_BYTES));
        } else {
            isRootLevel = false;
            this.baseSubspaceFuture = resolvedPath.thenApply(ResolvedKeySpacePath::toSubspace);
            this.nodeSubspaceFuture = this.baseSubspaceFuture;
        }
        this.stateSubspaceFuture = this.nodeSubspaceFuture.thenApply(node -> node.get(-10));
        this.interningLayerFuture = this.nodeSubspaceFuture.thenApply(node -> new StringInterningLayer((Subspace)node, isRootLevel));
    }

    public static ScopedInterningLayer global(@Nonnull FDBDatabase database) {
        return new ScopedInterningLayer(database, null, null);
    }

    @Override
    protected CompletableFuture<Optional<ResolverResult>> read(@Nonnull FDBRecordContext context, String key) {
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.INTERNING_LAYER_READ, this.interningLayerFuture.thenCompose(layer -> layer.read(context, key)));
    }

    @Override
    protected CompletableFuture<ResolverResult> create(@Nonnull FDBRecordContext context, @Nonnull String key, @Nullable byte[] metadata) {
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.INTERNING_LAYER_CREATE, this.interningLayerFuture.thenCompose(layer -> layer.create(context, key, metadata)));
    }

    @Override
    protected CompletableFuture<Optional<String>> readReverse(@Nonnull FDBRecordContext context, Long value) {
        return this.interningLayerFuture.thenCompose(layer -> layer.readReverse(context, value));
    }

    @Override
    @Deprecated
    protected CompletableFuture<Optional<String>> readReverse(FDBStoreTimer timer, Long value) {
        FDBRecordContext context = this.database.openContext(null, timer);
        return this.readReverse(context, value).whenComplete((ignored, th) -> context.close());
    }

    @Override
    @VisibleForTesting
    protected CompletableFuture<Void> deleteReverseForTesting(FDBRecordContext context, long value) {
        return this.interningLayerFuture.thenApply(layer -> {
            layer.deleteReverseForTesting(context, value);
            return null;
        });
    }

    @Override
    protected CompletableFuture<Void> putReverse(@Nonnull FDBRecordContext context, long value, @Nonnull String key) {
        return this.interningLayerFuture.thenApply(layer -> {
            layer.putReverse(context, value, key);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> setMapping(FDBRecordContext context, String key, ResolverResult value) {
        return this.interningLayerFuture.thenCompose(layer -> layer.setMapping(context, key, value));
    }

    @Override
    public CompletableFuture<Void> updateMetadata(@Nonnull FDBRecordContext context, @Nonnull String key, @Nullable byte[] metadata) {
        return this.interningLayerFuture.thenCompose(layer -> layer.updateMetadata(context, key, metadata));
    }

    @Override
    public CompletableFuture<Void> setWindow(long count) {
        return this.database.runAsync(context -> this.interningLayerFuture.thenCompose(layer -> layer.setWindow((FDBRecordContext)context, count)), Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "ScopedInterningLayer::setWindow", LogMessageKeys.RESOLVER, this}));
    }

    @Override
    protected CompletableFuture<Subspace> getStateSubspaceAsync() {
        return this.stateSubspaceFuture;
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getMappingSubspaceAsync() {
        return this.interningLayerFuture.thenApply(StringInterningLayer::getMappingSubspace);
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getBaseSubspaceAsync() {
        return this.baseSubspaceFuture;
    }

    @Override
    @Nonnull
    public ResolverResult deserializeValue(byte[] value) {
        return StringInterningLayer.deserializeValue(value);
    }
}

