/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.layers.interning;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.StringInterningProto;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.record.provider.foundationdb.layers.interning.HighContentionAllocator;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ZeroCopyByteString;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class StringInterningLayer {
    @Nonnull
    private final Subspace mappingSubspace;
    @Nonnull
    private final Subspace reverseMappingSubspace;
    @Nonnull
    private final Subspace counterSubspace;
    private final boolean isRootLevel;

    public StringInterningLayer(@Nonnull Subspace baseSubspace) {
        this(baseSubspace, false);
    }

    public StringInterningLayer(@Nonnull Subspace baseSubspace, boolean isRootLevel) {
        this(baseSubspace.get(2), baseSubspace.get(1), baseSubspace.get(0), isRootLevel);
    }

    private StringInterningLayer(@Nonnull Subspace mappingSubspace, @Nonnull Subspace reverseMappingSubspace, @Nonnull Subspace counterSubspace, boolean isRootLevel) {
        this.mappingSubspace = mappingSubspace;
        this.reverseMappingSubspace = reverseMappingSubspace;
        this.counterSubspace = counterSubspace;
        this.isRootLevel = isRootLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<ResolverResult> intern(@Nonnull FDBRecordContext context, @Nonnull String toIntern) {
        CompletableFuture<Optional<ResolverResult>> readResult;
        StringInterningLayer stringInterningLayer = this;
        synchronized (stringInterningLayer) {
            readResult = this.read(context, toIntern);
        }
        return ((CompletableFuture)readResult.thenApply(maybeRead -> maybeRead.map(CompletableFuture::completedFuture))).thenCompose(value -> value.orElseGet(() -> this.createMapping(context, toIntern, null)));
    }

    protected CompletableFuture<Boolean> exists(@Nonnull FDBRecordContext context, @Nonnull String toRead) {
        return context.ensureActive().get(this.mappingSubspace.pack(toRead)).thenApply(Objects::nonNull);
    }

    protected CompletableFuture<Optional<ResolverResult>> read(@Nonnull FDBRecordContext context, @Nonnull String toRead) {
        return ((CompletableFuture)context.ensureActive().get(this.mappingSubspace.pack(toRead)).thenApply(Optional::ofNullable)).thenApply(maybeValue -> maybeValue.map(StringInterningLayer::deserializeValue));
    }

    protected CompletableFuture<Optional<String>> readReverse(@Nonnull FDBRecordContext context, @Nonnull Long internedValue) {
        return ((CompletableFuture)context.ensureActive().get(this.reverseMappingSubspace.pack(internedValue)).thenApply(Optional::ofNullable)).thenApply(maybeValue -> maybeValue.map(bytes -> Tuple.fromBytes(bytes).getString(0)));
    }

    @VisibleForTesting
    protected void deleteReverseForTesting(@Nonnull FDBRecordContext context, @Nonnull Long internedValue) {
        context.ensureActive().clear(this.reverseMappingSubspace.pack(internedValue));
    }

    protected void putReverse(@Nonnull FDBRecordContext context, @Nonnull Long internedValue, @Nonnull String key) {
        context.ensureActive().set(this.reverseMappingSubspace.pack(internedValue), Tuple.from(key).pack());
    }

    protected CompletableFuture<ResolverResult> create(@Nonnull FDBRecordContext context, @Nonnull String toIntern, @Nullable byte[] metadata) {
        return this.exists(context, toIntern).thenCompose(present -> {
            if (present.booleanValue()) {
                throw new RecordCoreException("value already exists in interning layer", new Object[0]).addLogInfo("value", (Object)toIntern);
            }
            return this.createMapping(context, toIntern, metadata);
        });
    }

    protected CompletableFuture<Void> updateMetadata(@Nonnull FDBRecordContext context, @Nonnull String key, @Nullable byte[] metadata) {
        return ((CompletableFuture)this.read(context, key).thenApply(maybeRead -> maybeRead.map(read -> new ResolverResult(read.getValue(), metadata)).orElseThrow(() -> new NoSuchElementException("updateMetadata must reference key that already exists")))).thenAccept(newResult -> context.ensureActive().set(this.mappingSubspace.pack(key), this.serializeValue((ResolverResult)newResult)));
    }

    protected CompletableFuture<Void> setMapping(@Nonnull FDBRecordContext context, @Nonnull String key, @Nonnull ResolverResult value) {
        return this.read(context, key).thenCombine(this.readReverse(context, value.getValue()), (maybeRead, maybeReverseRead) -> {
            maybeRead.ifPresent(read -> {
                if (!read.equals(value)) {
                    throw new RecordCoreException("mapping already exists with different value", new Object[0]).addLogInfo("keyToSet", (Object)key).addLogInfo("valueToSet", (Object)value).addLogInfo("valueFound", read);
                }
            });
            maybeReverseRead.ifPresent(reverseRead -> {
                if (!reverseRead.equals(key)) {
                    throw new RecordCoreException("reverse mapping already exists with different key", new Object[0]).addLogInfo("keyToSet", (Object)key).addLogInfo("valueToSet", (Object)value).addLogInfo("keyForValueFound", reverseRead);
                }
            });
            if (!maybeRead.isPresent() && !maybeReverseRead.isPresent()) {
                context.ensureActive().set(this.mappingSubspace.pack(key), this.serializeValue(value));
                this.getHca(context).forceAllocate(key, value.getValue());
            }
            return null;
        });
    }

    protected CompletableFuture<Void> setWindow(@Nonnull FDBRecordContext context, long count) {
        this.getHca(context).setWindow(count);
        return AsyncUtil.DONE;
    }

    protected Subspace getMappingSubspace() {
        return this.mappingSubspace;
    }

    private CompletableFuture<ResolverResult> createMapping(@Nonnull FDBRecordContext context, @Nonnull String toIntern, @Nullable byte[] metadata) {
        HighContentionAllocator hca = this.getHca(context);
        byte[] mappingKey = this.mappingSubspace.pack(toIntern);
        return hca.allocate(toIntern).thenApply(allocated -> {
            ResolverResult result = new ResolverResult((long)allocated, metadata);
            context.ensureActive().set(mappingKey, this.serializeValue(result));
            return result;
        });
    }

    private HighContentionAllocator getHca(@Nonnull FDBRecordContext context) {
        return this.isRootLevel ? HighContentionAllocator.forRoot(context, this.counterSubspace, this.reverseMappingSubspace) : new HighContentionAllocator(context, this.counterSubspace, this.reverseMappingSubspace);
    }

    private byte[] serializeValue(@Nonnull ResolverResult allocated) {
        byte[] metadata = allocated.getMetadata();
        StringInterningProto.Data.Builder builder = StringInterningProto.Data.newBuilder();
        builder.setInternedValue(allocated.getValue());
        if (metadata != null) {
            builder.setMetadata(ZeroCopyByteString.wrap(metadata));
        }
        return builder.build().toByteArray();
    }

    protected static ResolverResult deserializeValue(byte[] bytes) {
        try {
            StringInterningProto.Data interned = StringInterningProto.Data.parseFrom(bytes);
            return new ResolverResult(interned.getInternedValue(), interned.hasMetadata() ? interned.getMetadata().toByteArray() : null);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new RecordCoreException("invalid interned value", exception).addLogInfo("internedBytes", (Object)ByteArrayUtil2.loggable(bytes));
        }
    }
}

