/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowForFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowAggregateFunction
extends IndexAggregateFunction {
    @Nonnull
    private final TimeWindowForFunction timeWindow;

    public TimeWindowAggregateFunction(@Nonnull String name, @Nonnull KeyExpression operand, @Nullable String index, @Nonnull TimeWindowForFunction timeWindow) {
        super(name, operand, index);
        this.timeWindow = timeWindow;
    }

    @Nonnull
    public TimeWindowForFunction getTimeWindow() {
        return this.timeWindow;
    }

    @Override
    @Nonnull
    public TimeWindowAggregateFunction cloneWithOperand(@Nonnull KeyExpression operand) {
        return new TimeWindowAggregateFunction(this.getName(), operand, this.getIndex(), this.timeWindow);
    }

    @Override
    @Nonnull
    public TimeWindowAggregateFunction cloneWithIndex(@Nonnull String index) {
        return new TimeWindowAggregateFunction(this.getName(), this.getOperand(), index, this.timeWindow);
    }

    @Override
    @Nonnull
    public TupleRange adjustRange(@Nonnull EvaluationContext context, @Nonnull TupleRange tupleRange) {
        return this.timeWindow.prependLeaderboardKeys(context, tupleRange);
    }

    @Override
    public String toString() {
        return super.toString() + "@" + String.valueOf(this.timeWindow);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeWindowAggregateFunction that = (TimeWindowAggregateFunction)o;
        return this.timeWindow.equals(that.timeWindow);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.timeWindow.hashCode();
        return result;
    }
}

