/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.planprotos.PTimeWindowForFunction;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowForFunction
implements PlanHashable,
PlanSerializable {
    private final int leaderboardType;
    private final long leaderboardTimestamp;
    @Nullable
    private final String leaderboardTypeParameter;
    @Nullable
    private final String leaderboardTimestampParameter;

    public TimeWindowForFunction(int leaderboardType, long leaderboardTimestamp, @Nullable String leaderboardTypeParameter, @Nullable String leaderboardTimestampParameter) {
        this.leaderboardType = leaderboardType;
        this.leaderboardTimestamp = leaderboardTimestamp;
        this.leaderboardTypeParameter = leaderboardTypeParameter;
        this.leaderboardTimestampParameter = leaderboardTimestampParameter;
    }

    public int getLeaderboardType() {
        return this.leaderboardType;
    }

    public int getLeaderboardType(@Nonnull EvaluationContext context) {
        if (this.leaderboardTypeParameter == null) {
            return this.leaderboardType;
        }
        return ((Number)context.getBinding(this.leaderboardTypeParameter)).intValue();
    }

    public long getLeaderboardTimestamp() {
        return this.leaderboardTimestamp;
    }

    public long getLeaderboardTimestamp(@Nonnull EvaluationContext context) {
        if (this.leaderboardTimestampParameter == null) {
            return this.leaderboardTimestamp;
        }
        return ((Number)context.getBinding(this.leaderboardTimestampParameter)).longValue();
    }

    @Nullable
    public String getLeaderboardTypeParameter() {
        return this.leaderboardTypeParameter;
    }

    @Nullable
    public String getLeaderboardTimestampParameter() {
        return this.leaderboardTimestampParameter;
    }

    @Nonnull
    public ScanComparisons prependLeaderboardKeys(@Nonnull ScanComparisons scanComparisons) {
        Comparisons.Comparison typeComparison = this.leaderboardTypeParameter == null ? new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, this.leaderboardType) : new Comparisons.ParameterComparison(Comparisons.Type.EQUALS, this.leaderboardTypeParameter);
        Comparisons.Comparison timestampComparison = this.leaderboardTimestampParameter == null ? new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, this.leaderboardTimestamp) : new Comparisons.ParameterComparison(Comparisons.Type.EQUALS, this.leaderboardTimestampParameter);
        return new ScanComparisons(Arrays.asList(typeComparison, timestampComparison), Collections.emptySet()).append(scanComparisons);
    }

    @Nonnull
    public TupleRange prependLeaderboardKeys(@Nonnull EvaluationContext context, @Nonnull TupleRange tupleRange) {
        return tupleRange.prepend(Tuple.from(this.getLeaderboardType(context), this.getLeaderboardTimestamp(context)));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.leaderboardType, this.leaderboardTimestamp, this.leaderboardTypeParameter, this.leaderboardTimestampParameter);
    }

    @Nonnull
    public String leaderboardTypeString() {
        return this.leaderboardTypeParameter == null ? Integer.toString(this.leaderboardType) : "$" + this.leaderboardTypeParameter;
    }

    @Nonnull
    public String leaderboardTimestampString() {
        return this.leaderboardTimestampParameter == null ? Long.toString(this.leaderboardTimestamp) : "$" + this.leaderboardTimestampParameter;
    }

    public String toString() {
        return this.leaderboardTypeString() + "," + this.leaderboardTimestampString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindowForFunction that = (TimeWindowForFunction)o;
        if (this.leaderboardType != that.leaderboardType) {
            return false;
        }
        if (this.leaderboardTimestamp != that.leaderboardTimestamp) {
            return false;
        }
        if (this.leaderboardTypeParameter != null ? !this.leaderboardTypeParameter.equals(that.leaderboardTypeParameter) : that.leaderboardTypeParameter != null) {
            return false;
        }
        return this.leaderboardTimestampParameter != null ? this.leaderboardTimestampParameter.equals(that.leaderboardTimestampParameter) : that.leaderboardTimestampParameter == null;
    }

    public int hashCode() {
        int result = this.leaderboardType;
        result = 31 * result + (int)(this.leaderboardTimestamp ^ this.leaderboardTimestamp >>> 32);
        result = 31 * result + (this.leaderboardTypeParameter != null ? this.leaderboardTypeParameter.hashCode() : 0);
        result = 31 * result + (this.leaderboardTimestampParameter != null ? this.leaderboardTimestampParameter.hashCode() : 0);
        return result;
    }

    @Override
    @Nonnull
    public PTimeWindowForFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
        PTimeWindowForFunction.Builder builder = PTimeWindowForFunction.newBuilder();
        builder.setLeaderboardType(this.leaderboardType);
        builder.setLeaderboardTimestamp(this.leaderboardTimestamp);
        if (this.leaderboardTypeParameter != null) {
            builder.setLeaderboardTypeParameter(this.leaderboardTypeParameter);
        }
        if (this.leaderboardTimestampParameter != null) {
            builder.setLeaderboardTimestampParameter(this.leaderboardTimestampParameter);
        }
        return builder.build();
    }

    @Nonnull
    public static TimeWindowForFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTimeWindowForFunction timeWindowForFunctionProto) {
        Verify.verify(timeWindowForFunctionProto.hasLeaderboardType());
        Verify.verify(timeWindowForFunctionProto.hasLeaderboardTimestamp());
        String leaderboardTypeParameter = timeWindowForFunctionProto.hasLeaderboardTypeParameter() ? timeWindowForFunctionProto.getLeaderboardTypeParameter() : null;
        String leaderboardTimestampParameter = timeWindowForFunctionProto.hasLeaderboardTimestampParameter() ? timeWindowForFunctionProto.getLeaderboardTimestampParameter() : null;
        return new TimeWindowForFunction(timeWindowForFunctionProto.getLeaderboardType(), timeWindowForFunctionProto.getLeaderboardTimestamp(), leaderboardTypeParameter, leaderboardTimestampParameter);
    }
}

