/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.TimeWindowLeaderboardProto;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardDirectory;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ZeroCopyByteString;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowLeaderboard
implements Comparable<TimeWindowLeaderboard> {
    public static final int ALL_TIME_LEADERBOARD_TYPE = 0;
    @Nonnull
    private final TimeWindowLeaderboardDirectory directory;
    private final int type;
    private final long startTimestamp;
    private final long endTimestamp;
    @Nonnull
    private final Tuple subspaceKey;
    private final int nlevels;

    public TimeWindowLeaderboard(@Nonnull TimeWindowLeaderboardDirectory directory, int type, long startTimestamp, long endTimestamp, @Nonnull Tuple subspaceKey, int nlevels) {
        this.directory = directory;
        this.type = type;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.subspaceKey = subspaceKey;
        this.nlevels = nlevels;
    }

    protected TimeWindowLeaderboard(@Nonnull TimeWindowLeaderboardDirectory directory, @Nonnull TimeWindowLeaderboardProto.TimeWindowLeaderboard proto) {
        this(directory, proto.getType(), proto.getStartTimestamp(), proto.getEndTimestamp(), Tuple.fromBytes(proto.getSubspaceKey().toByteArray()), proto.hasNlevels() ? proto.getNlevels() : 6);
    }

    public TimeWindowLeaderboardDirectory getDirectory() {
        return this.directory;
    }

    public int getType() {
        return this.type;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public boolean containsTimestamp(long timestamp) {
        return this.startTimestamp <= timestamp && timestamp < this.endTimestamp;
    }

    @Nonnull
    public Tuple getSubspaceKey() {
        return this.subspaceKey;
    }

    public int getNLevels() {
        return this.nlevels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindowLeaderboard that = (TimeWindowLeaderboard)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.startTimestamp != that.startTimestamp) {
            return false;
        }
        if (this.endTimestamp != that.endTimestamp) {
            return false;
        }
        if (!this.subspaceKey.equals(that.subspaceKey)) {
            return false;
        }
        return this.nlevels == that.nlevels;
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + (int)(this.startTimestamp ^ this.startTimestamp >>> 32);
        result = 31 * result + (int)(this.endTimestamp ^ this.endTimestamp >>> 32);
        result = 31 * result + this.subspaceKey.hashCode();
        result = 31 * result + this.nlevels;
        return result;
    }

    @Override
    public int compareTo(@Nonnull TimeWindowLeaderboard that) {
        if (this.type != that.type) {
            return this.type < that.type ? -1 : 1;
        }
        if (this.startTimestamp != that.startTimestamp) {
            return this.startTimestamp < that.startTimestamp ? -1 : 1;
        }
        if (this.endTimestamp != that.endTimestamp) {
            return this.endTimestamp < that.endTimestamp ? 1 : -1;
        }
        if (!this.subspaceKey.equals(that.subspaceKey)) {
            return this.subspaceKey.compareTo(that.subspaceKey);
        }
        return this.nlevels < that.nlevels ? -1 : 1;
    }

    @Nonnull
    protected TimeWindowLeaderboardProto.TimeWindowLeaderboard.Builder toProto() {
        return TimeWindowLeaderboardProto.TimeWindowLeaderboard.newBuilder().setType(this.type).setStartTimestamp(this.startTimestamp).setEndTimestamp(this.endTimestamp).setSubspaceKey(ZeroCopyByteString.wrap(this.subspaceKey.pack())).setNlevels(this.nlevels);
    }

    public String toString() {
        return "TimeWindowLeaderboard{type=" + this.type + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", subspaceKey=" + String.valueOf(this.subspaceKey) + ", nlevels=" + this.nlevels + "}";
    }
}

