/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.TimeWindowLeaderboardProto;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboard;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardSubDirectory;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowLeaderboardDirectory {
    private final boolean highScoreFirst;
    private long updateTimestamp;
    private int nextKey;
    private Map<Integer, Collection<TimeWindowLeaderboard>> leaderboards = new TreeMap<Integer, Collection<TimeWindowLeaderboard>>();
    private Map<Tuple, TimeWindowLeaderboardSubDirectory> subdirectories = new ConcurrentHashMap<Tuple, TimeWindowLeaderboardSubDirectory>();

    public TimeWindowLeaderboardDirectory(boolean highScoreFirst) {
        this.highScoreFirst = highScoreFirst;
    }

    protected TimeWindowLeaderboardDirectory(TimeWindowLeaderboardProto.TimeWindowLeaderboardDirectory proto) {
        this.highScoreFirst = proto.getHighScoreFirst();
        this.updateTimestamp = proto.getUpdateTimestamp();
        this.nextKey = proto.getNextKey();
        for (TimeWindowLeaderboardProto.TimeWindowLeaderboard leaderboardProto : proto.getLeaderboardsList()) {
            TimeWindowLeaderboard leaderboard = new TimeWindowLeaderboard(this, leaderboardProto);
            this.addLeaderboard(leaderboard);
        }
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public void setUpdateTimestamp(long updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public boolean isHighScoreFirst() {
        return this.highScoreFirst;
    }

    public Map<Integer, Collection<TimeWindowLeaderboard>> getLeaderboards() {
        return this.leaderboards;
    }

    @Nullable
    public TimeWindowLeaderboard oldestLeaderboardMatching(int type, long timestamp) {
        Iterable entry = this.leaderboards.get(type);
        if (entry == null) {
            return null;
        }
        for (TimeWindowLeaderboard leaderboard : entry) {
            if (!leaderboard.containsTimestamp(timestamp)) continue;
            return leaderboard;
        }
        return null;
    }

    @Nullable
    public TimeWindowLeaderboard findLeaderboard(int type, long startTimestamp, long endTimestamp) {
        Iterable entry = this.leaderboards.get(type);
        if (entry == null) {
            return null;
        }
        for (TimeWindowLeaderboard leaderboard : entry) {
            if (leaderboard.getStartTimestamp() != startTimestamp || leaderboard.getEndTimestamp() != endTimestamp) continue;
            return leaderboard;
        }
        return null;
    }

    public void addLeaderboard(int type, long startTimestamp, long endTimestamp, int nlevels) {
        this.addLeaderboard(new TimeWindowLeaderboard(this, type, startTimestamp, endTimestamp, Tuple.from(this.nextKey++), nlevels));
    }

    protected void addLeaderboard(TimeWindowLeaderboard leaderboard) {
        this.leaderboards.compute(leaderboard.getType(), (iignore, collection) -> {
            if (collection == null) {
                collection = new TreeSet<TimeWindowLeaderboard>();
            }
            collection.add(leaderboard);
            return collection;
        });
    }

    @Nullable
    public TimeWindowLeaderboardSubDirectory getSubDirectory(@Nonnull Tuple subdir) {
        return this.subdirectories.get(subdir);
    }

    public void addSubDirectory(@Nonnull TimeWindowLeaderboardSubDirectory subdir) {
        this.subdirectories.put(subdir.getGroup(), subdir);
    }

    @Nonnull
    public TimeWindowLeaderboardProto.TimeWindowLeaderboardDirectory toProto() {
        TimeWindowLeaderboardProto.TimeWindowLeaderboardDirectory.Builder builder = TimeWindowLeaderboardProto.TimeWindowLeaderboardDirectory.newBuilder();
        builder.setUpdateTimestamp(this.updateTimestamp);
        builder.setHighScoreFirst(this.highScoreFirst);
        builder.setNextKey(this.nextKey);
        for (Collection<TimeWindowLeaderboard> entry : this.leaderboards.values()) {
            for (TimeWindowLeaderboard leaderboard : entry) {
                builder.addLeaderboards(leaderboard.toProto());
            }
        }
        return builder.build();
    }
}

