/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.async.RankedSet;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TimeWindowLeaderboardProto;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperation;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanRange;
import com.apple.foundationdb.record.provider.foundationdb.indexes.AtomicMutation;
import com.apple.foundationdb.record.provider.foundationdb.indexes.RankedSetIndexHelper;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowForFunction;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboard;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardDirectory;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardDirectoryOperation;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardDirectoryResult;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardSaveSubDirectory;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardScoreTrim;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardScoreTrimResult;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardSubDirectory;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardSubDirectoryOperation;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardSubDirectoryResult;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardWindowUpdate;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowLeaderboardWindowUpdateResult;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowRecordFunction;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowScanRange;
import com.apple.foundationdb.record.util.MapUtils;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowLeaderboardIndexMaintainer
extends StandardIndexMaintainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeWindowLeaderboardIndexMaintainer.class);
    private static final Tuple SUB_DIRECTORY_PREFIX = Tuple.from(new Object[]{null});
    private final RankedSet.Config config;

    public TimeWindowLeaderboardIndexMaintainer(IndexMaintainerState state) {
        super(state);
        this.config = RankedSetIndexHelper.getConfig(state.index);
    }

    @Nonnull
    protected CompletableFuture<TimeWindowLeaderboard> oldestLeaderboardMatching(int type, long timestamp) {
        return this.loadDirectory().thenApply(directory -> directory == null ? null : directory.oldestLeaderboardMatching(type, timestamp));
    }

    @Nonnull
    protected CompletableFuture<TimeWindowLeaderboardDirectory> loadDirectory() {
        Subspace extraSubspace = this.getSecondarySubspace();
        return this.state.transaction.get(extraSubspace.pack()).thenApply(bytes -> {
            if (bytes == null) {
                return null;
            }
            TimeWindowLeaderboardProto.TimeWindowLeaderboardDirectory.Builder builder = TimeWindowLeaderboardProto.TimeWindowLeaderboardDirectory.newBuilder();
            try {
                builder.mergeFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreStorageException("error decoding leaderboard directory", ex);
            }
            return new TimeWindowLeaderboardDirectory(builder.build());
        });
    }

    protected void saveDirectory(TimeWindowLeaderboardDirectory directory) {
        Subspace extraSubspace = this.getSecondarySubspace();
        this.state.transaction.set(extraSubspace.pack(), directory.toProto().toByteArray());
    }

    @Nonnull
    protected CompletableFuture<TimeWindowLeaderboardSubDirectory> loadSubDirectory(@Nonnull TimeWindowLeaderboardDirectory directory, @Nonnull Tuple group) {
        TimeWindowLeaderboardSubDirectory subdirectory = directory.getSubDirectory(group);
        if (subdirectory != null) {
            return CompletableFuture.completedFuture(subdirectory);
        }
        Subspace extraSubspace = this.getSecondarySubspace();
        return this.state.transaction.get(extraSubspace.pack(SUB_DIRECTORY_PREFIX.addAll(group))).thenApply(bytes -> {
            TimeWindowLeaderboardSubDirectory newsub;
            if (bytes == null) {
                newsub = new TimeWindowLeaderboardSubDirectory(group, directory.isHighScoreFirst());
            } else {
                TimeWindowLeaderboardProto.TimeWindowLeaderboardSubDirectory.Builder builder = TimeWindowLeaderboardProto.TimeWindowLeaderboardSubDirectory.newBuilder();
                try {
                    builder.mergeFrom((byte[])bytes);
                }
                catch (InvalidProtocolBufferException ex) {
                    throw new RecordCoreStorageException("error decoding leaderboard sub-directory", ex);
                }
                newsub = new TimeWindowLeaderboardSubDirectory(group, builder.build());
            }
            directory.addSubDirectory(newsub);
            return newsub;
        });
    }

    protected void saveSubDirectory(@Nonnull TimeWindowLeaderboardSubDirectory subdirectory) {
        Subspace extraSubspace = this.getSecondarySubspace();
        this.state.transaction.set(extraSubspace.pack(SUB_DIRECTORY_PREFIX.addAll(subdirectory.getGroup())), subdirectory.toProto().toByteArray());
    }

    @Override
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scan(new IndexScanRange(scanType, range), continuation, scanProperties);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        TupleRange leaderboardRange;
        long timestamp;
        int type;
        IndexScanRange scanRange;
        IndexScanType scanType = scanBounds.getScanType();
        if (!(scanType.equals(IndexScanType.BY_VALUE) || scanType.equals(IndexScanType.BY_RANK) || scanType.equals(IndexScanType.BY_TIME_WINDOW))) {
            throw new RecordCoreException("Can only scan leaderboard index by time window, rank or value.", new Object[0]);
        }
        if (scanType.equals(IndexScanType.BY_TIME_WINDOW)) {
            if (scanBounds instanceof TimeWindowScanRange) {
                scanRange = (TimeWindowScanRange)scanBounds;
                type = ((TimeWindowScanRange)scanRange).getLeaderboardType();
                timestamp = ((TimeWindowScanRange)scanRange).getLeaderboardTimestamp();
                leaderboardRange = scanRange.getScanRange();
            } else {
                scanRange = (IndexScanRange)scanBounds;
                TupleRange rankRange = scanRange.getScanRange();
                Tuple lowRank = rankRange.getLow();
                Tuple highRank = rankRange.getHigh();
                type = (int)lowRank.getLong(0);
                timestamp = lowRank.getLong(1);
                leaderboardRange = new TupleRange(Tuple.fromList(lowRank.getItems().subList(2, lowRank.size())), Tuple.fromList(highRank.getItems().subList(2, highRank.size())), rankRange.getLowEndpoint(), rankRange.getHighEndpoint());
            }
        } else {
            scanRange = (IndexScanRange)scanBounds;
            type = 0;
            timestamp = 0L;
            leaderboardRange = scanRange.getScanRange();
        }
        int groupPrefixSize = this.getGroupingCount();
        CompletableFuture<TimeWindowLeaderboard> leaderboardFuture = this.oldestLeaderboardMatching(type, timestamp);
        CompletionStage scoreRangeFuture = scanType.equals(IndexScanType.BY_VALUE) ? leaderboardFuture.thenApply(leaderboard -> leaderboard == null ? null : leaderboardRange) : leaderboardFuture.thenCompose(leaderboard -> {
            if (leaderboard == null) {
                return CompletableFuture.completedFuture(null);
            }
            Subspace extraSubspace = this.getSecondarySubspace();
            Subspace leaderboardSubspace = extraSubspace.subspace(leaderboard.getSubspaceKey());
            RankedSet.Config leaderboardConfig = this.config.toBuilder().setNLevels(leaderboard.getNLevels()).build();
            return RankedSetIndexHelper.rankRangeToScoreRange(this.state, groupPrefixSize, leaderboardSubspace, leaderboardConfig, leaderboardRange);
        });
        return RecordCursor.flatMapPipelined(arg_0 -> this.lambda$scan$5((CompletableFuture)scoreRangeFuture, arg_0), (scoreRange, ignore) -> {
            CompletableFuture<Boolean> highStoreFirstFuture;
            if (scoreRange == null) {
                return RecordCursor.empty(this.getExecutor());
            }
            TimeWindowLeaderboard leaderboard = (TimeWindowLeaderboard)this.state.context.joinNow(leaderboardFuture);
            if (scanType.equals(IndexScanType.BY_VALUE)) {
                Tuple highGroup;
                Tuple lowGroup = scoreRange.getLow() != null && scoreRange.getLow().size() > groupPrefixSize ? TupleHelpers.subTuple(scoreRange.getLow(), 0, groupPrefixSize) : null;
                Tuple tuple = highGroup = scoreRange.getHigh() != null && scoreRange.getHigh().size() > groupPrefixSize ? TupleHelpers.subTuple(scoreRange.getHigh(), 0, groupPrefixSize) : null;
                highStoreFirstFuture = lowGroup != null && lowGroup.equals(highGroup) ? this.isHighScoreFirst(leaderboard.getDirectory(), lowGroup) : CompletableFuture.completedFuture(leaderboard.getDirectory().isHighScoreFirst());
            } else {
                highStoreFirstFuture = AsyncUtil.READY_FALSE;
            }
            if (highStoreFirstFuture.isDone()) {
                return this.scanLeaderboard(leaderboard, this.state.context.joinNow(highStoreFirstFuture), (TupleRange)scoreRange, continuation, scanProperties);
            }
            return RecordCursor.flatMapPipelined(ignore2 -> RecordCursor.fromFuture(this.getExecutor(), highStoreFirstFuture), (highScoreFirst, ignore2) -> this.scanLeaderboard(leaderboard, (boolean)highScoreFirst, (TupleRange)scoreRange, continuation, scanProperties), null, 1);
        }, null, 1).mapPipelined(kv -> this.getIndexEntry((IndexEntry)kv, groupPrefixSize, ((TimeWindowLeaderboard)this.state.context.joinNow(leaderboardFuture)).getDirectory()), 1);
    }

    protected RecordCursor<IndexEntry> scanLeaderboard(@Nonnull TimeWindowLeaderboard leaderboard, boolean highScoreFirst, @Nonnull TupleRange scoreRange, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (highScoreFirst) {
            return this.scanLeaderboard(leaderboard, this.negateScoreRange(scoreRange), continuation, scanProperties.setReverse(!scanProperties.isReverse()));
        }
        return this.scanLeaderboard(leaderboard, scoreRange, continuation, scanProperties);
    }

    protected RecordCursor<IndexEntry> scanLeaderboard(@Nonnull TimeWindowLeaderboard leaderboard, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scan(range.prepend(leaderboard.getSubspaceKey()), continuation, scanProperties);
    }

    protected TupleRange negateScoreRange(@Nonnull TupleRange range) {
        int groupPrefixSize = this.getGroupingCount();
        Tuple low = range.getLow();
        Tuple high = range.getHigh();
        EndpointType lowEndpoint = range.getLowEndpoint();
        EndpointType highEndpoint = range.getHighEndpoint();
        if (low == null || low.size() < groupPrefixSize) {
            if (lowEndpoint == EndpointType.TREE_START) {
                lowEndpoint = EndpointType.TREE_END;
            }
        } else {
            low = TimeWindowLeaderboardIndexMaintainer.negateScoreForHighScoreFirst(low, groupPrefixSize);
        }
        if (high == null || high.size() < groupPrefixSize) {
            if (lowEndpoint == EndpointType.TREE_END) {
                lowEndpoint = EndpointType.TREE_START;
            }
        } else {
            high = TimeWindowLeaderboardIndexMaintainer.negateScoreForHighScoreFirst(high, groupPrefixSize);
        }
        return new TupleRange(high, low, highEndpoint, lowEndpoint);
    }

    protected CompletableFuture<IndexEntry> getIndexEntry(@Nonnull IndexEntry rawEntry, int groupPrefixSize, @Nonnull TimeWindowLeaderboardDirectory directory) {
        Tuple rawKey = rawEntry.getKey().popFront();
        return this.isHighScoreFirst(directory, TupleHelpers.subTuple(rawKey, 0, groupPrefixSize)).thenApply(highScoreFirst -> {
            Tuple key = highScoreFirst != false ? TimeWindowLeaderboardIndexMaintainer.negateScoreForHighScoreFirst(rawKey, groupPrefixSize) : rawKey;
            return new IndexEntry(rawEntry.getIndex(), key, rawEntry.getValue());
        });
    }

    protected CompletableFuture<Boolean> isHighScoreFirst(@Nonnull TimeWindowLeaderboardDirectory directory, @Nonnull Tuple group) {
        return this.loadSubDirectory(directory, group).thenApply(TimeWindowLeaderboardSubDirectory::isHighScoreFirst);
    }

    protected static Tuple negateScoreForHighScoreFirst(@Nonnull Tuple entry, int position) {
        return TupleHelpers.set(entry, position, TupleHelpers.negate((Number)entry.get(position)));
    }

    @Override
    @Nonnull
    protected List<IndexEntry> commonKeys(@Nonnull List<IndexEntry> oldIndexKeys, @Nonnull List<IndexEntry> newIndexKeys) {
        if (oldIndexKeys.equals(newIndexKeys)) {
            return oldIndexKeys;
        }
        return Collections.emptyList();
    }

    @Override
    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        Subspace extraSubspace = this.getSecondarySubspace();
        Tuple entryValue = indexEntries.isEmpty() ? TupleHelpers.EMPTY : indexEntries.get(0).getValue();
        return this.loadDirectory().thenCompose(directory -> {
            if (directory == null) {
                return AsyncUtil.DONE;
            }
            return this.groupOrderedScoreIndexKeys((Iterable<IndexEntry>)indexEntries, (TimeWindowLeaderboardDirectory)directory, true).thenCompose(groupedScores -> {
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (Iterable iterable : directory.getLeaderboards().values()) {
                    for (TimeWindowLeaderboard leaderboard : iterable) {
                        for (Map.Entry groupEntry : groupedScores.entrySet()) {
                            Optional<OrderedScoreIndexKey> bestContainedScore = ((Collection)groupEntry.getValue()).stream().filter(score -> leaderboard.containsTimestamp(score.timestamp)).findFirst();
                            if (!bestContainedScore.isPresent()) continue;
                            Tuple groupKey = (Tuple)groupEntry.getKey();
                            OrderedScoreIndexKey indexKey = bestContainedScore.get();
                            Tuple leaderboardGroupKey = leaderboard.getSubspaceKey().addAll(groupKey);
                            Tuple entryKey = leaderboardGroupKey.addAll(indexKey.scoreKey);
                            CompletableFuture<Void> updateOrdinaryIndex = this.updateOneKeyAsync(savedRecord, remove, new IndexEntry(this.state.index, entryKey, entryValue));
                            if (!MoreAsyncUtil.isCompletedNormally(updateOrdinaryIndex)) {
                                futures.add(updateOrdinaryIndex);
                            }
                            Subspace rankSubspace = extraSubspace.subspace(leaderboardGroupKey);
                            RankedSet.Config leaderboardConfig = this.config.toBuilder().setNLevels(leaderboard.getNLevels()).build();
                            futures.add(RankedSetIndexHelper.updateRankedSet(this.state, rankSubspace, leaderboardConfig, entryKey, indexKey.scoreKey, remove));
                        }
                    }
                }
                Optional<Long> latestTimestamp = groupedScores.values().stream().flatMap(Collection::stream).map(OrderedScoreIndexKey::getTimestamp).max(Long::compareTo);
                if (latestTimestamp.isPresent()) {
                    this.state.transaction.mutate(MutationType.MAX, this.state.indexSubspace.getKey(), AtomicMutation.Standard.encodeSignedLong(latestTimestamp.get()));
                }
                return AsyncUtil.whenAll(futures);
            });
        });
    }

    @Override
    public boolean isIdempotent() {
        return !this.config.isCountDuplicates();
    }

    @Override
    public boolean canEvaluateRecordFunction(@Nonnull IndexRecordFunction<?> function) {
        return ("rank".equals(function.getName()) || "time_window_rank".equals(function.getName()) || "time_window_rank_and_entry".equals(function.getName())) && this.state.index.getRootExpression().equals(function.getOperand());
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public <T, M extends Message> CompletableFuture<T> evaluateRecordFunction(@Nonnull EvaluationContext context, @Nonnull IndexRecordFunction<T> function, @Nonnull FDBRecord<M> record) {
        if ("rank".equals(function.getName())) {
            CompletionStage rank = this.timeWindowRankAndEntry(record, 0, 0L).thenApply(re -> re == null ? null : re.getRank());
            return rank;
        }
        if ("time_window_rank".equals(function.getName())) {
            TimeWindowRecordFunction timeWindowRank = (TimeWindowRecordFunction)function;
            TimeWindowForFunction timeWindow = timeWindowRank.getTimeWindow();
            CompletionStage rank = this.timeWindowRankAndEntry(context, timeWindow, record).thenApply(re -> re == null ? null : re.getRank());
            return rank;
        }
        if ("time_window_rank_and_entry".equals(function.getName())) {
            TimeWindowRecordFunction timeWindowRankAndEntry = (TimeWindowRecordFunction)function;
            TimeWindowForFunction timeWindow = timeWindowRankAndEntry.getTimeWindow();
            CompletionStage rankAndEntry = this.timeWindowRankAndEntry(context, timeWindow, record).thenApply(re -> re == null ? null : Tuple.from(re.getRank()).addAll(re.getEntry()));
            return rankAndEntry;
        }
        return this.unsupportedRecordFunction(function);
    }

    @Override
    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        if ("time_window_count".equals(function.getName()) && function.getOperand().equals(this.state.index.getRootExpression())) {
            return true;
        }
        if (("score_for_time_window_rank".equals(function.getName()) || "score_for_time_window_rank_else_skip".equals(function.getName()) || "time_window_rank_for_score".equals(function.getName())) && function.getOperand().equals(this.state.index.getRootExpression())) {
            return true;
        }
        return super.canEvaluateAggregateFunction(function);
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        if ("time_window_count".equals(function.getName()) && range.isEquals()) {
            return this.evaluateEqualRange(range, (leaderboard, rankedSet, groupKey, values) -> rankedSet.size(this.state.context.readTransaction(isolationLevel.isSnapshot())).thenApply(xva$0 -> Tuple.from(xva$0)));
        }
        if (("score_for_time_window_rank".equals(function.getName()) || "score_for_time_window_rank_else_skip".equals(function.getName())) && range.isEquals()) {
            Tuple outOfRange = "score_for_time_window_rank_else_skip".equals(function.getName()) ? RankedSetIndexHelper.COMPARISON_SKIPPED_SCORE : null;
            return this.evaluateEqualRange(range, (leaderboard, rankedSet, groupKey, values) -> RankedSetIndexHelper.scoreForRank(this.state, rankedSet, (Number)values.get(0), outOfRange).thenCombine(this.isHighScoreFirst(leaderboard.getDirectory(), groupKey), (score, highScoreFirst) -> score == null || highScoreFirst == false ? score : TimeWindowLeaderboardIndexMaintainer.negateScoreForHighScoreFirst(score, 0)));
        }
        if ("time_window_rank_for_score".equals(function.getName()) && range.isEquals()) {
            return this.evaluateEqualRange(range, (leaderboard, rankedSet, groupKey, values) -> this.isHighScoreFirst(leaderboard.getDirectory(), groupKey).thenCompose(highScoreFirst -> {
                Tuple scoreValues = highScoreFirst != false ? TimeWindowLeaderboardIndexMaintainer.negateScoreForHighScoreFirst(values, 0) : values;
                return RankedSetIndexHelper.rankForScore(this.state, rankedSet, scoreValues, false).thenApply(xva$0 -> Tuple.from(xva$0));
            }));
        }
        return this.unsupportedAggregateFunction(function);
    }

    private CompletableFuture<Tuple> evaluateEqualRange(@Nonnull TupleRange range, @Nonnull EvaluateEqualRange function) {
        Tuple tuple = range.getLow();
        int type = (int)tuple.getLong(0);
        long timestamp = tuple.getLong(1);
        int groupingCount = this.getGroupingCount();
        Tuple groupKey = TupleHelpers.subTuple(tuple, 2, 2 + groupingCount);
        Tuple values = TupleHelpers.subTuple(tuple, 2 + groupingCount, tuple.size());
        CompletableFuture<TimeWindowLeaderboard> leaderboardFuture = this.oldestLeaderboardMatching(type, timestamp);
        return leaderboardFuture.thenCompose(leaderboard -> {
            if (leaderboard == null) {
                return CompletableFuture.completedFuture(null);
            }
            Tuple leaderboardGroupKey = leaderboard.getSubspaceKey().addAll(groupKey);
            Subspace extraSubspace = this.getSecondarySubspace();
            Subspace rankSubspace = extraSubspace.subspace(leaderboardGroupKey);
            RankedSet.Config leaderboardConfig = this.config.toBuilder().setNLevels(leaderboard.getNLevels()).build();
            RankedSetIndexHelper.InstrumentedRankedSet rankedSet = new RankedSetIndexHelper.InstrumentedRankedSet(this.state, rankSubspace, leaderboardConfig);
            return function.apply((TimeWindowLeaderboard)leaderboard, rankedSet, groupKey, values);
        });
    }

    @Nonnull
    public <M extends Message> CompletableFuture<TimeWindowRankAndEntry> timeWindowRankAndEntry(@Nonnull EvaluationContext context, @Nonnull TimeWindowForFunction timeWindow, @Nonnull FDBRecord<M> record) {
        return this.timeWindowRankAndEntry(record, timeWindow.getLeaderboardType(context), timeWindow.getLeaderboardTimestamp(context));
    }

    @Nonnull
    public <M extends Message> CompletableFuture<TimeWindowRankAndEntry> timeWindowRankAndEntry(@Nonnull FDBRecord<M> record, int type, long timestamp) {
        List<IndexEntry> indexEntries = this.evaluateIndex(record);
        CompletableFuture<TimeWindowLeaderboard> leaderboardFuture = this.oldestLeaderboardMatching(type, timestamp);
        return leaderboardFuture.thenCompose(leaderboard -> {
            if (leaderboard == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.groupOrderedScoreIndexKeys(indexEntries, leaderboard.getDirectory(), true).thenCompose(groupedScores -> {
                if (groupedScores.isEmpty()) {
                    return CompletableFuture.completedFuture(null);
                }
                if (groupedScores.size() > 1) {
                    throw new RecordCoreException("Record has more than one group of scores", new Object[0]);
                }
                Map.Entry groupEntry = groupedScores.entrySet().iterator().next();
                Optional<OrderedScoreIndexKey> bestContainedScore = ((Collection)groupEntry.getValue()).stream().filter(score -> leaderboard.containsTimestamp(score.timestamp)).findFirst();
                if (!bestContainedScore.isPresent()) {
                    return CompletableFuture.completedFuture(null);
                }
                Tuple groupKey = (Tuple)groupEntry.getKey();
                return this.isHighScoreFirst(leaderboard.getDirectory(), groupKey).thenCompose(highScoreFirst -> {
                    OrderedScoreIndexKey indexKey = (OrderedScoreIndexKey)bestContainedScore.get();
                    Tuple leaderboardGroupKey = leaderboard.getSubspaceKey().addAll(groupKey);
                    Subspace extraSubspace = this.getSecondarySubspace();
                    Subspace rankSubspace = extraSubspace.subspace(leaderboardGroupKey);
                    RankedSet.Config leaderboardConfig = this.config.toBuilder().setNLevels(leaderboard.getNLevels()).build();
                    RankedSetIndexHelper.InstrumentedRankedSet rankedSet = new RankedSetIndexHelper.InstrumentedRankedSet(this.state, rankSubspace, leaderboardConfig);
                    Tuple entry = highScoreFirst != false ? TimeWindowLeaderboardIndexMaintainer.negateScoreForHighScoreFirst(indexKey.scoreKey, 0) : indexKey.scoreKey;
                    return RankedSetIndexHelper.rankForScore(this.state, rankedSet, indexKey.scoreKey, true).thenApply(rank -> new TimeWindowRankAndEntry((Long)rank, entry));
                });
            });
        });
    }

    @Override
    public CompletableFuture<Void> deleteWhere(Transaction tr, @Nonnull Tuple prefix) {
        return this.loadDirectory().thenApply(directory -> {
            if (directory != null) {
                Subspace indexSubspace = this.getIndexSubspace();
                Subspace extraSubspace = this.getSecondarySubspace();
                for (Iterable iterable : directory.getLeaderboards().values()) {
                    for (TimeWindowLeaderboard leaderboard : iterable) {
                        Tuple leaderboardGroupKey = leaderboard.getSubspaceKey().addAll(prefix);
                        byte[] indexKey = indexSubspace.pack(leaderboardGroupKey);
                        this.state.context.clear(new Range(indexKey, ByteArrayUtil.strinc(indexKey)));
                        byte[] ranksetKey = extraSubspace.pack(leaderboardGroupKey);
                        this.state.context.clear(new Range(ranksetKey, ByteArrayUtil.strinc(ranksetKey)));
                    }
                }
            }
            return null;
        });
    }

    @Override
    @Nonnull
    public CompletableFuture<IndexOperationResult> performOperation(@Nonnull IndexOperation operation) {
        CompletionStage<IndexOperationResult> result;
        FDBStoreTimer.Events event = null;
        if (operation instanceof TimeWindowLeaderboardWindowUpdate) {
            UpdateState state = new UpdateState((TimeWindowLeaderboardWindowUpdate)operation);
            result = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)state.loadDirectory().thenApply(directory -> {
                state.setDirectory((TimeWindowLeaderboardDirectory)directory);
                return null;
            })).thenApply(vignore -> {
                state.update();
                return null;
            })).thenCompose(vignore -> state.checkOverlappingChanged())).thenCompose(vignore -> state.save())).thenApply(vignore -> state.getResult());
            event = FDBStoreTimer.Events.TIME_WINDOW_LEADERBOARD_UPDATE_DIRECTORY;
        } else if (operation instanceof TimeWindowLeaderboardScoreTrim) {
            TimeWindowLeaderboardScoreTrim trim = (TimeWindowLeaderboardScoreTrim)operation;
            result = ((CompletableFuture)this.loadDirectory().thenCompose(directory -> this.trimScores((TimeWindowLeaderboardDirectory)directory, trim.getScores(), trim.isIncludesGroup()))).thenApply(TimeWindowLeaderboardScoreTrimResult::new);
            event = FDBStoreTimer.Events.TIME_WINDOW_LEADERBOARD_TRIM_SCORES;
        } else if (operation instanceof TimeWindowLeaderboardDirectoryOperation) {
            result = this.loadDirectory().thenApply(TimeWindowLeaderboardDirectoryResult::new);
            event = FDBStoreTimer.Events.TIME_WINDOW_LEADERBOARD_GET_DIRECTORY;
        } else if (operation instanceof TimeWindowLeaderboardSubDirectoryOperation) {
            TimeWindowLeaderboardSubDirectoryOperation subdir = (TimeWindowLeaderboardSubDirectoryOperation)operation;
            result = ((CompletableFuture)this.loadDirectory().thenCompose(directory -> this.loadSubDirectory((TimeWindowLeaderboardDirectory)directory, subdir.getGroup()))).thenApply(TimeWindowLeaderboardSubDirectoryResult::new);
            event = FDBStoreTimer.Events.TIME_WINDOW_LEADERBOARD_GET_SUB_DIRECTORY;
        } else if (operation instanceof TimeWindowLeaderboardSaveSubDirectory) {
            TimeWindowLeaderboardSaveSubDirectory subdir = (TimeWindowLeaderboardSaveSubDirectory)operation;
            this.saveSubDirectory(subdir.getSubDirectory());
            result = CompletableFuture.completedFuture(new TimeWindowLeaderboardSubDirectoryResult(subdir.getSubDirectory()));
            event = FDBStoreTimer.Events.TIME_WINDOW_LEADERBOARD_SAVE_SUB_DIRECTORY;
        } else {
            result = super.performOperation(operation);
        }
        if (event != null && this.getTimer() != null) {
            result = this.getTimer().instrument(event, result, this.getExecutor());
        }
        return result;
    }

    protected CompletableFuture<Collection<Tuple>> trimScores(@Nullable TimeWindowLeaderboardDirectory directory, @Nonnull Collection<Tuple> scores, boolean includesGroup) {
        if (directory == null) {
            return CompletableFuture.completedFuture(scores);
        }
        Map<Integer, Collection<TimeWindowLeaderboard>> leaderboards = directory.getLeaderboards();
        List<IndexEntry> indexEntries = scores.stream().map(score -> new IndexEntry(this.state.index, (Tuple)score, TupleHelpers.EMPTY)).collect(Collectors.toList());
        return this.groupOrderedScoreIndexKeys(indexEntries, directory, includesGroup).thenApply(groupedScores -> {
            TreeSet trimmed = new TreeSet();
            for (Iterable directoryEntry : leaderboards.values()) {
                for (TimeWindowLeaderboard leaderboard : directoryEntry) {
                    for (Collection entry : groupedScores.values()) {
                        Optional<OrderedScoreIndexKey> bestContainedScore = entry.stream().filter(score -> leaderboard.containsTimestamp(score.timestamp)).findFirst();
                        bestContainedScore.ifPresent(trimmed::add);
                    }
                }
            }
            return trimmed.stream().map(indexKey -> indexKey.getIndexEntry().getKey()).collect(Collectors.toList());
        });
    }

    protected CompletableFuture<Map<Tuple, Collection<OrderedScoreIndexKey>>> groupOrderedScoreIndexKeys(@Nonnull Iterable<IndexEntry> indexEntries, @Nonnull TimeWindowLeaderboardDirectory directory, boolean includesGroup) {
        int groupPrefixSize = this.getGroupingCount();
        HashMap groupDirections = new HashMap();
        if (includesGroup) {
            for (IndexEntry indexEntry : indexEntries) {
                Tuple groupKey = TupleHelpers.subTuple(indexEntry.getKey(), 0, groupPrefixSize);
                MapUtils.computeIfAbsent(groupDirections, groupKey, group -> this.isHighScoreFirst(directory, (Tuple)group));
            }
        }
        return AsyncUtil.whenAll(groupDirections.values()).thenApply(vignore -> {
            HashMap<Tuple, Collection> grouped = new HashMap<Tuple, Collection>();
            for (IndexEntry indexEntry : indexEntries) {
                Tuple scoreKey = indexEntry.getKey();
                Tuple groupKey = TupleHelpers.EMPTY;
                if (includesGroup && groupPrefixSize > 0) {
                    groupKey = TupleHelpers.subTuple(scoreKey, 0, groupPrefixSize);
                    scoreKey = TupleHelpers.subTuple(scoreKey, groupPrefixSize, scoreKey.size());
                }
                if (includesGroup ? (Boolean)((CompletableFuture)groupDirections.get(groupKey)).join() != false : directory.isHighScoreFirst()) {
                    scoreKey = TimeWindowLeaderboardIndexMaintainer.negateScoreForHighScoreFirst(scoreKey, 0);
                }
                OrderedScoreIndexKey orderedScoreIndexKey = new OrderedScoreIndexKey(indexEntry, scoreKey);
                grouped.compute(groupKey, (gignore, collection) -> {
                    if (collection == null) {
                        collection = new TreeSet<OrderedScoreIndexKey>();
                    }
                    collection.add(orderedScoreIndexKey);
                    return collection;
                });
            }
            return grouped;
        });
    }

    private /* synthetic */ RecordCursor lambda$scan$5(CompletableFuture scoreRangeFuture, byte[] ignore) {
        return RecordCursor.fromFuture(this.getExecutor(), scoreRangeFuture);
    }

    private static interface EvaluateEqualRange {
        @Nonnull
        public CompletableFuture<Tuple> apply(@Nonnull TimeWindowLeaderboard var1, @Nonnull RankedSet var2, @Nonnull Tuple var3, @Nonnull Tuple var4);
    }

    protected class UpdateState {
        private final TimeWindowLeaderboardWindowUpdate update;
        private TimeWindowLeaderboardDirectory directory;
        private boolean rebuild;
        private boolean changed;
        private long earliestAddedStartTimestamp;

        public UpdateState(TimeWindowLeaderboardWindowUpdate update) {
            this.update = update;
            this.rebuild = update.getRebuild() == TimeWindowLeaderboardWindowUpdate.Rebuild.ALWAYS;
        }

        protected boolean isRebuildConditional() {
            return !this.rebuild && this.update.getRebuild() == TimeWindowLeaderboardWindowUpdate.Rebuild.IF_OVERLAPPING_CHANGED;
        }

        public CompletableFuture<TimeWindowLeaderboardDirectory> loadDirectory() {
            if (this.rebuild) {
                return CompletableFuture.completedFuture(null);
            }
            return TimeWindowLeaderboardIndexMaintainer.this.loadDirectory();
        }

        public void setDirectory(@Nullable TimeWindowLeaderboardDirectory existingDirectory) {
            this.directory = existingDirectory;
            if (this.directory != null && this.directory.isHighScoreFirst() != this.update.isHighScoreFirst()) {
                if (this.update.getRebuild() == TimeWindowLeaderboardWindowUpdate.Rebuild.NEVER) {
                    throw new RecordCoreException("cannot change highScoreFirst without a rebuild", new Object[0]);
                }
                this.directory = null;
            }
            if (this.directory == null) {
                this.directory = new TimeWindowLeaderboardDirectory(this.update.isHighScoreFirst());
                if (this.isRebuildConditional()) {
                    this.rebuild = true;
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(KeyValueLogMessage.of(this.rebuild ? "rebuilding leaderboard index for initial directory" : "need to rebuild leaderboard index for initial directory", new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.indexSubspace.pack())}));
                }
            }
        }

        public void update() {
            Collection<TimeWindowLeaderboard> existing;
            this.directory.setUpdateTimestamp(this.update.getUpdateTimestamp());
            Subspace indexSubspace = TimeWindowLeaderboardIndexMaintainer.this.getIndexSubspace();
            Subspace extraSubspace = TimeWindowLeaderboardIndexMaintainer.this.getSecondarySubspace();
            for (Iterable iterable : this.directory.getLeaderboards().values()) {
                Iterator iter = iterable.iterator();
                while (iter.hasNext()) {
                    TimeWindowLeaderboard leaderboard = (TimeWindowLeaderboard)iter.next();
                    if (leaderboard.getType() == 0 || this.update.getDeleteBefore() < leaderboard.getEndTimestamp()) continue;
                    ((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.transaction.clear(indexSubspace.pack(leaderboard.getSubspaceKey()));
                    ((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.transaction.clear(extraSubspace.pack(leaderboard.getSubspaceKey()));
                    iter.remove();
                    this.changed = true;
                    if (TimeWindowLeaderboardIndexMaintainer.this.getTimer() == null) continue;
                    TimeWindowLeaderboardIndexMaintainer.this.getTimer().increment(FDBStoreTimer.Counts.TIME_WINDOW_LEADERBOARD_DELETE_WINDOW);
                }
            }
            if (this.update.isAllTime() && ((existing = this.directory.getLeaderboards().get(0)) == null || existing.isEmpty())) {
                this.directory.addLeaderboard(0, Long.MIN_VALUE, Long.MAX_VALUE, this.update.getNlevels());
                if (this.isRebuildConditional()) {
                    this.rebuild = true;
                }
                this.changed = true;
                if (TimeWindowLeaderboardIndexMaintainer.this.getTimer() != null) {
                    TimeWindowLeaderboardIndexMaintainer.this.getTimer().increment(FDBStoreTimer.Counts.TIME_WINDOW_LEADERBOARD_ADD_WINDOW);
                }
            }
            this.earliestAddedStartTimestamp = Long.MAX_VALUE;
            for (TimeWindowLeaderboardWindowUpdate.TimeWindowSpec timeWindowSpec : this.update.getSpecs()) {
                int i = 0;
                while ((long)i < timeWindowSpec.getCount()) {
                    long startTimestamp = timeWindowSpec.getBaseTimestamp() + timeWindowSpec.getStartIncrement() * (long)i;
                    long endTimestamp = startTimestamp + timeWindowSpec.getDuration();
                    if (this.directory.findLeaderboard(timeWindowSpec.getType(), startTimestamp, endTimestamp) == null) {
                        this.directory.addLeaderboard(timeWindowSpec.getType(), startTimestamp, endTimestamp, this.update.getNlevels());
                        if (this.earliestAddedStartTimestamp > startTimestamp) {
                            this.earliestAddedStartTimestamp = startTimestamp;
                        }
                        this.changed = true;
                        if (TimeWindowLeaderboardIndexMaintainer.this.getTimer() != null) {
                            TimeWindowLeaderboardIndexMaintainer.this.getTimer().increment(FDBStoreTimer.Counts.TIME_WINDOW_LEADERBOARD_ADD_WINDOW);
                        }
                    }
                    ++i;
                }
            }
        }

        public CompletableFuture<Void> checkOverlappingChanged() {
            if (this.changed) {
                return ((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.transaction.get(((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.indexSubspace.getKey()).thenApply(maxBytes -> {
                    long latestEntryTimestamp;
                    if (maxBytes != null && (latestEntryTimestamp = AtomicMutation.Standard.decodeSignedLong(maxBytes)) >= this.earliestAddedStartTimestamp) {
                        if (this.isRebuildConditional()) {
                            this.rebuild = true;
                        }
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info(KeyValueLogMessage.of(this.rebuild ? "rebuilding leaderboard index due to overlapping existing record" : "need to rebuild leaderboard index due to overlapping existing record", new Object[]{LogMessageKeys.LATEST_ENTRY_TIMESTAMP, latestEntryTimestamp, LogMessageKeys.EARLIEST_ADDED_START_TIMESTAMP, this.earliestAddedStartTimestamp, LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.indexSubspace.pack())}));
                        }
                        if (TimeWindowLeaderboardIndexMaintainer.this.getTimer() != null) {
                            TimeWindowLeaderboardIndexMaintainer.this.getTimer().increment(FDBStoreTimer.Counts.TIME_WINDOW_LEADERBOARD_OVERLAPPING_CHANGED);
                        }
                    }
                    return null;
                });
            }
            return AsyncUtil.DONE;
        }

        public CompletableFuture<Void> save() {
            if (this.rebuild) {
                TimeWindowLeaderboardIndexMaintainer.this.deleteWhere(((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.transaction, TupleHelpers.EMPTY);
            }
            if (this.changed) {
                TimeWindowLeaderboardIndexMaintainer.this.saveDirectory(this.directory);
            }
            if (this.rebuild) {
                return ((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.store.rebuildIndex(((TimeWindowLeaderboardIndexMaintainer)TimeWindowLeaderboardIndexMaintainer.this).state.index);
            }
            return AsyncUtil.DONE;
        }

        public TimeWindowLeaderboardWindowUpdateResult getResult() {
            return new TimeWindowLeaderboardWindowUpdateResult(this.changed, this.rebuild);
        }
    }

    static class OrderedScoreIndexKey
    implements Comparable<OrderedScoreIndexKey> {
        @Nonnull
        final IndexEntry indexEntry;
        @Nonnull
        final Tuple scoreKey;
        final long timestamp;

        public OrderedScoreIndexKey(IndexEntry indexEntry, Tuple scoreKey) {
            this.indexEntry = indexEntry;
            this.scoreKey = scoreKey;
            this.timestamp = scoreKey.getLong(1);
        }

        @Nonnull
        public IndexEntry getIndexEntry() {
            return this.indexEntry;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderedScoreIndexKey that = (OrderedScoreIndexKey)o;
            return this.indexEntry.equals(that.indexEntry);
        }

        public int hashCode() {
            return this.indexEntry.hashCode();
        }

        @Override
        public int compareTo(OrderedScoreIndexKey that) {
            return this.scoreKey.compareTo(that.scoreKey);
        }
    }

    public static class TimeWindowRankAndEntry {
        @Nullable
        private final Long rank;
        @Nonnull
        private final Tuple entry;

        private TimeWindowRankAndEntry(@Nullable Long rank, @Nonnull Tuple entry) {
            this.rank = rank;
            this.entry = entry;
        }

        @Nullable
        public Long getRank() {
            return this.rank;
        }

        @Nonnull
        public Tuple getEntry() {
            return this.entry;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeWindowRankAndEntry that = (TimeWindowRankAndEntry)o;
            return Objects.equals(this.rank, that.rank) && Objects.equals(this.entry, that.entry);
        }

        public int hashCode() {
            return Objects.hash(this.entry, this.rank);
        }

        public String toString() {
            return "TimeWindowRankAndEntry{rank=" + this.rank + ", entry=" + String.valueOf(this.entry) + "}";
        }
    }
}

