/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperation;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowLeaderboardWindowUpdate
extends IndexOperation {
    private final long updateTimestamp;
    private final boolean highScoreFirst;
    private final long deleteBefore;
    private final boolean allTime;
    private final Iterable<TimeWindowSpec> specs;
    private final int nlevels;
    private final Rebuild rebuild;

    public TimeWindowLeaderboardWindowUpdate(long updateTimestamp, boolean highScoreFirst, long deleteBefore, boolean allTime, Iterable<TimeWindowSpec> specs, int nlevels, Rebuild rebuild) {
        this.updateTimestamp = updateTimestamp;
        this.highScoreFirst = highScoreFirst;
        this.deleteBefore = deleteBefore;
        this.allTime = allTime;
        this.specs = specs;
        this.nlevels = nlevels;
        this.rebuild = rebuild;
    }

    public TimeWindowLeaderboardWindowUpdate(long updateTimestamp, boolean highScoreFirst, long deleteBefore, boolean allTime, Iterable<TimeWindowSpec> specs, Rebuild rebuild) {
        this(updateTimestamp, highScoreFirst, deleteBefore, allTime, specs, 6, rebuild);
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public boolean isHighScoreFirst() {
        return this.highScoreFirst;
    }

    public long getDeleteBefore() {
        return this.deleteBefore;
    }

    public boolean isAllTime() {
        return this.allTime;
    }

    public Iterable<TimeWindowSpec> getSpecs() {
        return this.specs;
    }

    public int getNlevels() {
        return this.nlevels;
    }

    public Rebuild getRebuild() {
        return this.rebuild;
    }

    public static enum Rebuild {
        ALWAYS,
        NEVER,
        IF_OVERLAPPING_CHANGED;

    }

    public static class TimeWindowSpec {
        private final int type;
        private final long baseTimestamp;
        private final long startIncrement;
        private final long duration;
        private final int count;

        public TimeWindowSpec(int type, long baseTimestamp, long startIncrement, long duration, int count) {
            this.type = type;
            this.baseTimestamp = baseTimestamp;
            this.startIncrement = startIncrement;
            this.duration = duration;
            this.count = count;
        }

        public int getType() {
            return this.type;
        }

        public long getBaseTimestamp() {
            return this.baseTimestamp;
        }

        public long getStartIncrement() {
            return this.startIncrement;
        }

        public long getDuration() {
            return this.duration;
        }

        public long getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeWindowSpec that = (TimeWindowSpec)o;
            if (this.type != that.type) {
                return false;
            }
            if (this.baseTimestamp != that.baseTimestamp) {
                return false;
            }
            if (this.startIncrement != that.startIncrement) {
                return false;
            }
            if (this.duration != that.duration) {
                return false;
            }
            return this.count == that.count;
        }

        public int hashCode() {
            int result = this.type;
            result = 31 * result + (int)(this.baseTimestamp ^ this.baseTimestamp >>> 32);
            result = 31 * result + (int)(this.startIncrement ^ this.startIncrement >>> 32);
            result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
            result = 31 * result + this.count;
            return result;
        }
    }
}

