/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowForFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowRecordFunction<T>
extends IndexRecordFunction<T> {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Time-Window-Record-Function");
    @Nonnull
    private final TimeWindowForFunction timeWindow;

    public TimeWindowRecordFunction(@Nonnull String name, @Nonnull GroupingKeyExpression operand, @Nullable String index, @Nonnull TimeWindowForFunction timeWindow) {
        super(name, operand, index);
        this.timeWindow = timeWindow;
    }

    @Nonnull
    public TimeWindowForFunction getTimeWindow() {
        return this.timeWindow;
    }

    @Override
    @Nonnull
    public TimeWindowRecordFunction<T> cloneWithOperand(@Nonnull GroupingKeyExpression operand) {
        return new TimeWindowRecordFunction<T>(this.getName(), operand, this.getIndex(), this.timeWindow);
    }

    @Override
    @Nonnull
    public TimeWindowRecordFunction<T> cloneWithIndex(@Nonnull String index) {
        return new TimeWindowRecordFunction<T>(this.getName(), this.getOperand(), index, this.timeWindow);
    }

    @Override
    public String toString() {
        return super.toString() + "@" + String.valueOf(this.timeWindow);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeWindowRecordFunction that = (TimeWindowRecordFunction)o;
        return this.timeWindow.equals(that.timeWindow);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.timeWindow.hashCode();
        return result;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return super.planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, super.planHash(mode), this.timeWindow);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

