/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.leaderboard;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.planprotos.PIndexScanParameters;
import com.apple.foundationdb.record.planprotos.PTimeWindowScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanRange;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowForFunction;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowScanRange;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TimeWindowScanComparisons
extends IndexScanComparisons {
    @Nonnull
    private final TimeWindowForFunction timeWindow;

    protected TimeWindowScanComparisons(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTimeWindowScanComparisons timeWindowScanComparisonsProto) {
        super(serializationContext, Objects.requireNonNull(timeWindowScanComparisonsProto.getSuper()));
        this.timeWindow = TimeWindowForFunction.fromProto(serializationContext, Objects.requireNonNull(timeWindowScanComparisonsProto.getTimeWindow()));
    }

    public TimeWindowScanComparisons(@Nonnull TimeWindowForFunction timeWindow, @Nonnull ScanComparisons comparisons) {
        super(IndexScanType.BY_TIME_WINDOW, comparisons);
        this.timeWindow = timeWindow;
    }

    @Override
    @Nonnull
    public TimeWindowScanRange bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        return new TimeWindowScanRange(this.timeWindow.getLeaderboardType(context), this.timeWindow.getLeaderboardTimestamp(context), ((IndexScanRange)super.bind((FDBRecordStoreBase)store, index, context)).getScanRange());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return super.planHash(mode) + this.timeWindow.planHash(mode);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of(super.explain().getExplainTokens().addToString("@").addToString(this.timeWindow));
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        super.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        detailsBuilder.add((Object)"time window type: {{timeWindowType}}");
        detailsBuilder.add((Object)"time window timestamp: {{timeWindowTimestamp}}");
        attributeMapBuilder.put("timeWindowType", Attribute.gml(this.timeWindow.leaderboardTypeString()));
        attributeMapBuilder.put("timeWindowTimestamp", Attribute.gml(this.timeWindow.leaderboardTimestampString()));
    }

    @Override
    @Nonnull
    protected TimeWindowScanComparisons withScanComparisons(@Nonnull ScanComparisons newScanComparisons) {
        return new TimeWindowScanComparisons(this.timeWindow, newScanComparisons);
    }

    @Override
    public String toString() {
        return super.toString() + "@" + String.valueOf(this.timeWindow);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeWindowScanComparisons that = (TimeWindowScanComparisons)o;
        return this.timeWindow.equals(that.timeWindow);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.timeWindow.hashCode();
        return result;
    }

    @Override
    @Nonnull
    public PTimeWindowScanComparisons toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PTimeWindowScanComparisons.newBuilder().setSuper(this.toIndexScanComparisonsProto(serializationContext)).setTimeWindow(this.timeWindow.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PIndexScanParameters toIndexScanParametersProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexScanParameters.newBuilder().setTimeWindowScanComparisons(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static TimeWindowScanComparisons fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTimeWindowScanComparisons timeWindowScanComparisonsProto) {
        return new TimeWindowScanComparisons(serializationContext, timeWindowScanComparisonsProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PTimeWindowScanComparisons, TimeWindowScanComparisons> {
        @Override
        @Nonnull
        public Class<PTimeWindowScanComparisons> getProtoMessageClass() {
            return PTimeWindowScanComparisons.class;
        }

        @Override
        @Nonnull
        public TimeWindowScanComparisons fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTimeWindowScanComparisons timeWindowScanComparisonsProto) {
            return TimeWindowScanComparisons.fromProto(serializationContext, timeWindowScanComparisonsProto);
        }
    }
}

