/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyValue;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class RecordLayerPropertyKey<T> {
    @Nonnull
    private final String name;
    @Nullable
    private final T defaultValue;
    @Nonnull
    private final Class<T> type;

    public RecordLayerPropertyKey(@Nonnull String name, @Nullable T defaultValue, @Nonnull Class<T> type) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Nonnull
    public RecordLayerPropertyValue<T> buildValue(@Nonnull Supplier<T> valueSupplier) {
        return new RecordLayerPropertyValue<T>(this, valueSupplier);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        RecordLayerPropertyKey otherKey = (RecordLayerPropertyKey)other;
        return this.name.equals(otherKey.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public static RecordLayerPropertyKey<Boolean> booleanPropertyKey(@Nonnull String name, boolean defaultValue) {
        return new RecordLayerPropertyKey<Boolean>(name, defaultValue, Boolean.class);
    }

    public static RecordLayerPropertyKey<String> stringPropertyKey(@Nonnull String name, @Nonnull String defaultValue) {
        return new RecordLayerPropertyKey<String>(name, defaultValue, String.class);
    }

    public static RecordLayerPropertyKey<Integer> integerPropertyKey(@Nonnull String name, int defaultValue) {
        return new RecordLayerPropertyKey<Integer>(name, defaultValue, Integer.class);
    }

    public static RecordLayerPropertyKey<Long> longPropertyKey(@Nonnull String name, long defaultValue) {
        return new RecordLayerPropertyKey<Long>(name, defaultValue, Long.class);
    }

    public static RecordLayerPropertyKey<Double> doublePropertyKey(@Nonnull String name, double defaultValue) {
        return new RecordLayerPropertyKey<Double>(name, defaultValue, Double.class);
    }
}

