/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyKey;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerPropertyStorage {
    private static final RecordLayerPropertyStorage EMPTY_PROPERTY_STORAGE = new RecordLayerPropertyStorage(ImmutableMap.of());
    @Nonnull
    private final ImmutableMap<RecordLayerPropertyKey<?>, RecordLayerPropertyValue<?>> propertyMap;

    private RecordLayerPropertyStorage(@Nonnull ImmutableMap<RecordLayerPropertyKey<?>, RecordLayerPropertyValue<?>> propertyMap) {
        this.propertyMap = propertyMap;
    }

    @Nonnull
    public ImmutableMap<RecordLayerPropertyKey<?>, RecordLayerPropertyValue<?>> getPropertyMap() {
        return this.propertyMap;
    }

    @Nullable
    public <T> T getPropertyValue(@Nonnull RecordLayerPropertyKey<T> propertyKey) {
        if (this.propertyMap.containsKey(propertyKey)) {
            Object value = Preconditions.checkNotNull(this.propertyMap.get(propertyKey)).getValue();
            try {
                return propertyKey.getType().cast(value);
            }
            catch (ClassCastException ex) {
                throw new RecordCoreException("Invalid type for record context property", ex).addLogInfo(new Object[]{LogMessageKeys.PROPERTY_NAME, propertyKey.getName(), LogMessageKeys.PROPERTY_TYPE, value.getClass().getName()});
            }
        }
        return propertyKey.getDefaultValue();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this.propertyMap);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static RecordLayerPropertyStorage getEmptyInstance() {
        return EMPTY_PROPERTY_STORAGE;
    }

    public static class Builder {
        private final Map<RecordLayerPropertyKey<?>, RecordLayerPropertyValue<?>> propertyMap;

        private Builder() {
            this.propertyMap = new HashMap();
        }

        private Builder(ImmutableMap<RecordLayerPropertyKey<?>, RecordLayerPropertyValue<?>> properties) {
            this.propertyMap = new HashMap(properties);
        }

        public <T> boolean hasProp(@Nonnull RecordLayerPropertyKey<T> propKey) {
            return this.propertyMap.containsKey(propKey);
        }

        public <T> void removeProp(@Nonnull RecordLayerPropertyKey<T> propKey) {
            this.propertyMap.remove(propKey);
        }

        public <T> Builder addProp(@Nonnull RecordLayerPropertyValue<T> propValue) {
            if (this.propertyMap.putIfAbsent(propValue.getKey(), propValue) != null) {
                throw new RecordCoreException("Duplicate property name is added", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.PROPERTY_NAME, propValue.getKey().getName()});
            }
            return this;
        }

        public <T> Builder addProp(@Nonnull RecordLayerPropertyKey<T> propKey, @Nonnull Supplier<T> valueSupplier) {
            RecordLayerPropertyValue<T> propValue = propKey.buildValue(valueSupplier);
            return this.addProp(propValue);
        }

        public <T> Builder addProp(@Nonnull RecordLayerPropertyKey<T> propKey, @Nonnull T value) {
            RecordLayerPropertyValue<Object> propValue = propKey.buildValue(() -> value);
            return this.addProp(propValue);
        }

        public RecordLayerPropertyStorage build() {
            return new RecordLayerPropertyStorage(ImmutableMap.copyOf(this.propertyMap));
        }
    }
}

