/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.recordrepair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordRepairResult;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordRepairStatsRunner;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordRepairValidateRunner;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordValueValidator;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordVersionValidator;
import com.apple.foundationdb.record.provider.foundationdb.runners.throttled.CursorFactory;
import com.apple.foundationdb.record.provider.foundationdb.runners.throttled.ThrottledRetryingIterator;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.util.CloseException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public abstract class RecordRepair
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RecordRepair.class);
    @Nonnull
    private final FDBDatabase database;
    @Nonnull
    private final FDBRecordStore.Builder storeBuilder;
    @Nonnull
    private final ValidationKind validationKind;
    @Nonnull
    private final ThrottledRetryingIterator<Tuple> throttledIterator;

    protected RecordRepair(@Nonnull Builder config) {
        this.database = config.database;
        this.storeBuilder = config.getStoreBuilder();
        this.validationKind = config.getValidationKind();
        ThrottledRetryingIterator.Builder<Tuple> iteratorBuilder = ThrottledRetryingIterator.builder(this.database, this.cursorFactory(), this::handleOneItem);
        this.throttledIterator = this.configureThrottlingIterator(iteratorBuilder, config).build();
    }

    public static Builder builder(@Nonnull FDBDatabase database, FDBRecordStore.Builder storeBuilder) {
        return new Builder(database, storeBuilder);
    }

    @Override
    public void close() throws CloseException {
        this.throttledIterator.close();
    }

    @Nonnull
    protected abstract CompletableFuture<Void> handleOneItem(@Nonnull FDBRecordStore var1, @Nonnull RecordCursorResult<Tuple> var2, @Nonnull ThrottledRetryingIterator.QuotaManager var3);

    protected CompletableFuture<Void> iterateAll() {
        return this.throttledIterator.iterateAll(this.storeBuilder);
    }

    private CursorFactory<Tuple> cursorFactory() {
        return (store, lastResult, rowLimit) -> {
            byte[] continuation = lastResult == null ? null : lastResult.getContinuation().toBytes();
            ScanProperties scanProperties = ScanProperties.FORWARD_SCAN.with(executeProperties -> executeProperties.setReturnedRowLimit(rowLimit));
            return store.scanRecordKeys(continuation, scanProperties);
        };
    }

    protected CompletableFuture<RecordRepairResult> validateInternal(@Nonnull RecordCursorResult<Tuple> primaryKey, @Nonnull FDBRecordStore store, boolean allowRepair) {
        RecordValueValidator valueValidator = new RecordValueValidator(store);
        return valueValidator.validateRecordAsync(primaryKey.get()).thenCompose(valueValidationResult -> {
            if (!valueValidationResult.isValid()) {
                if (allowRepair) {
                    return valueValidator.repairRecordAsync((RecordRepairResult)valueValidationResult);
                }
                return CompletableFuture.completedFuture(valueValidationResult);
            }
            if (this.validationKind == ValidationKind.RECORD_VALUE_AND_VERSION) {
                RecordVersionValidator versionValidator = new RecordVersionValidator(store);
                return versionValidator.validateRecordAsync((Tuple)primaryKey.get()).thenCompose(versionValidationResult -> {
                    if (!versionValidationResult.isValid() && allowRepair) {
                        return versionValidator.repairRecordAsync((RecordRepairResult)versionValidationResult);
                    }
                    return CompletableFuture.completedFuture(versionValidationResult);
                });
            }
            return CompletableFuture.completedFuture(valueValidationResult);
        });
    }

    private ThrottledRetryingIterator.Builder<Tuple> configureThrottlingIterator(ThrottledRetryingIterator.Builder<Tuple> builder, Builder config) {
        return builder.withTransactionInitNotification(this::logStartTransaction).withTransactionSuccessNotification(this::logCommitTransaction).withTransactionTimeQuotaMillis(config.getTransactionTimeQuotaMillis()).withMaxRecordsDeletesPerTransaction(config.getMaxRecordDeletesPerTransaction()).withMaxRecordsScannedPerSec(config.getMaxRecordScannedPerSec()).withMaxRecordsDeletesPerSec(config.getMaxRecordDeletesPerSec()).withNumOfRetries(config.getNumOfRetries());
    }

    private void logStartTransaction(ThrottledRetryingIterator.QuotaManager quotaManager) {
        if (logger.isDebugEnabled()) {
            logger.debug(KeyValueLogMessage.of("RecordRepairRunner: transaction started", new Object[0]));
        }
    }

    private void logCommitTransaction(ThrottledRetryingIterator.QuotaManager quotaManager) {
        if (logger.isDebugEnabled()) {
            logger.debug(KeyValueLogMessage.of("RecordRepairRunner: transaction committed", new Object[]{LogMessageKeys.RECORDS_SCANNED, quotaManager.getScannedCount(), LogMessageKeys.RECORDS_DELETED, quotaManager.getDeletesCount()}));
        }
    }

    public static class Builder {
        @Nonnull
        private final FDBDatabase database;
        @Nonnull
        private final FDBRecordStore.Builder storeBuilder;
        private int maxResultsReturned = 10000;
        @Nonnull
        private ValidationKind validationKind = ValidationKind.RECORD_VALUE_AND_VERSION;
        private int transactionTimeQuotaMillis = (int)TimeUnit.SECONDS.toMillis(4L);
        private int maxRecordDeletesPerTransaction = 0;
        private int maxRecordScannedPerSec = 0;
        private int maxRecordDeletesPerSec = 1000;
        private int numOfRetries = 4;

        public Builder(@Nonnull FDBDatabase database, @Nonnull FDBRecordStore.Builder storeBuilder) {
            this.database = database;
            this.storeBuilder = storeBuilder;
        }

        public RecordRepairStatsRunner buildStatsRunner() {
            return new RecordRepairStatsRunner(this);
        }

        public RecordRepairValidateRunner buildRepairRunner(boolean allowRepair) {
            return new RecordRepairValidateRunner(this, allowRepair);
        }

        public Builder withMaxResultsReturned(int maxResultsReturned) {
            this.maxResultsReturned = maxResultsReturned;
            return this;
        }

        public Builder withValidationKind(ValidationKind validationKind) {
            this.validationKind = validationKind;
            return this;
        }

        public Builder withMaxRecordDeletesPerTransaction(int maxRecordDeletesPerTransaction) {
            this.maxRecordDeletesPerTransaction = maxRecordDeletesPerTransaction;
            return this;
        }

        public Builder withTransactionTimeQuotaMillis(int transactionTimeQuotaMillis) {
            this.transactionTimeQuotaMillis = transactionTimeQuotaMillis;
            return this;
        }

        public Builder withMaxRecordScannedPerSec(int maxRecordScannedPerSec) {
            this.maxRecordScannedPerSec = maxRecordScannedPerSec;
            return this;
        }

        public Builder withMaxRecordDeletesPerSec(int maxRecordDeletesPerSec) {
            this.maxRecordDeletesPerSec = maxRecordDeletesPerSec;
            return this;
        }

        public Builder withNumOfRetries(int numOfRetries) {
            this.numOfRetries = numOfRetries;
            return this;
        }

        @Nonnull
        public FDBDatabase getDatabase() {
            return this.database;
        }

        @Nonnull
        public FDBRecordStore.Builder getStoreBuilder() {
            return this.storeBuilder;
        }

        @Nonnull
        public ValidationKind getValidationKind() {
            return this.validationKind;
        }

        public int getMaxResultsReturned() {
            return this.maxResultsReturned;
        }

        public int getTransactionTimeQuotaMillis() {
            return this.transactionTimeQuotaMillis;
        }

        public int getMaxRecordDeletesPerTransaction() {
            return this.maxRecordDeletesPerTransaction;
        }

        public int getMaxRecordScannedPerSec() {
            return this.maxRecordScannedPerSec;
        }

        public int getMaxRecordDeletesPerSec() {
            return this.maxRecordDeletesPerSec;
        }

        public int getNumOfRetries() {
            return this.numOfRetries;
        }
    }

    public static enum ValidationKind {
        RECORD_VALUE,
        RECORD_VALUE_AND_VERSION;

    }
}

