/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.recordrepair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordRepairResult {
    public static final String CODE_VALID = "Valid";
    public static final String CODE_SPLIT_ERROR = "RecordValueSplitError";
    public static final String CODE_DESERIALIZE_ERROR = "RecordValueDeserializeError";
    public static final String CODE_VERSION_MISSING_ERROR = "RecordVersionMissingError";
    public static final String CODE_RECORD_MISSING_ERROR = "RecordMissingError";
    public static final String REPAIR_NOT_NEEDED = "RepairNotNeeded";
    public static final String REPAIR_UNKNOWN_VALIDATION_CODE = "UnknownCode";
    public static final String REPAIR_RECORD_DELETED = "RecordValueRecordDeletedRepair";
    public static final String REPAIR_VERSION_CREATED = "RecordVersionCreatedRepair";
    @Nonnull
    private final Tuple primaryKey;
    private final boolean isValid;
    @Nonnull
    private final String errorCode;
    @Nullable
    private final String message;
    private final boolean isRepaired;
    @Nullable
    private final String repairCode;

    private RecordRepairResult(@Nonnull Tuple primaryKey, boolean isValid, @Nonnull String errorCode, @Nullable String message) {
        this(primaryKey, isValid, errorCode, message, false, null);
    }

    private RecordRepairResult(@Nonnull Tuple primaryKey, boolean isValid, @Nonnull String errorCode, @Nullable String message, boolean isRepaired, String repairCode) {
        this.primaryKey = primaryKey;
        this.isValid = isValid;
        this.errorCode = errorCode;
        this.message = message;
        this.isRepaired = isRepaired;
        this.repairCode = repairCode;
    }

    public static RecordRepairResult valid(Tuple primaryKey) {
        return new RecordRepairResult(primaryKey, true, CODE_VALID, null);
    }

    public static RecordRepairResult invalid(Tuple primaryKey, String error, String message) {
        return new RecordRepairResult(primaryKey, false, error, message);
    }

    @Nonnull
    public RecordRepairResult withRepair(@Nonnull String repairCode) {
        return new RecordRepairResult(this.primaryKey, this.isValid, this.errorCode, this.message, true, repairCode);
    }

    @Nonnull
    public Tuple getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Nonnull
    public String getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public boolean isRepaired() {
        return this.isRepaired;
    }

    @Nullable
    public String getRepairCode() {
        return this.repairCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordRepairResult)) {
            return false;
        }
        RecordRepairResult that = (RecordRepairResult)o;
        return this.isValid == that.isValid && this.isRepaired == that.isRepaired && Objects.equals(this.primaryKey, that.primaryKey) && Objects.equals(this.errorCode, that.errorCode) && Objects.equals(this.repairCode, that.repairCode);
    }

    public int hashCode() {
        return Objects.hash(this.primaryKey, this.isValid, this.errorCode, this.isRepaired, this.repairCode);
    }

    public String toString() {
        return "RecordValidationResult{primaryKey=" + String.valueOf(this.primaryKey) + ", isValid=" + this.isValid + ", errorCode='" + this.errorCode + "', message='" + this.message + "', isRepaired=" + this.isRepaired + ", repairCode='" + this.repairCode + "'}";
    }
}

