/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.recordrepair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordRepair;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordRepairResult;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RepairValidationResults;
import com.apple.foundationdb.record.provider.foundationdb.runners.throttled.ThrottledRetryingIterator;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordRepairValidateRunner
extends RecordRepair {
    private final boolean allowRepair;
    private final int maxResultsReturned;
    @Nonnull
    private final List<RecordRepairResult> invalidResults;
    @Nonnull
    private final AtomicInteger validResultCount;
    @Nonnull
    private final AtomicBoolean earlyReturn;

    RecordRepairValidateRunner(@Nonnull RecordRepair.Builder config, boolean allowRepair) {
        super(config);
        this.allowRepair = allowRepair;
        this.maxResultsReturned = config.getMaxResultsReturned();
        this.invalidResults = new ArrayList<RecordRepairResult>();
        this.validResultCount = new AtomicInteger(0);
        this.earlyReturn = new AtomicBoolean(false);
    }

    public CompletableFuture<RepairValidationResults> run() {
        return this.iterateAll().handle((ignoreVoid, ex) -> {
            if (ex != null) {
                return new RepairValidationResults(false, (Throwable)ex, this.invalidResults, this.validResultCount.get());
            }
            return new RepairValidationResults(!this.earlyReturn.get(), null, this.invalidResults, this.validResultCount.get());
        });
    }

    @Override
    @Nonnull
    protected CompletableFuture<Void> handleOneItem(@Nonnull FDBRecordStore store, @Nonnull RecordCursorResult<Tuple> primaryKey, @Nonnull ThrottledRetryingIterator.QuotaManager quotaManager) {
        return this.validateInternal(primaryKey, store, this.allowRepair).thenAccept(result -> {
            if (result.isValid()) {
                this.validResultCount.incrementAndGet();
            } else {
                this.invalidResults.add((RecordRepairResult)result);
                if (this.maxResultsReturned > 0 && this.invalidResults.size() >= this.maxResultsReturned) {
                    quotaManager.markExhausted();
                    this.earlyReturn.set(true);
                }
                if (result.isRepaired() && "RecordValueRecordDeletedRepair".equals(result.getRepairCode())) {
                    quotaManager.deleteCountAdd(1);
                }
            }
        });
    }
}

