/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.recordrepair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.RecordDeserializationException;
import com.apple.foundationdb.record.provider.foundationdb.SplitHelper;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordRepairResult;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordValidator;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.UnknownValidationException;
import com.apple.foundationdb.tuple.Tuple;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordValueValidator
implements RecordValidator {
    private static final Logger logger = LoggerFactory.getLogger(RecordValueValidator.class);
    @Nonnull
    private final FDBRecordStore store;

    public RecordValueValidator(@Nonnull FDBRecordStore store) {
        this.store = store;
    }

    @Override
    public CompletableFuture<RecordRepairResult> validateRecordAsync(@Nonnull Tuple primaryKey) {
        return this.store.loadRecordAsync(primaryKey).handle((rec, exception) -> {
            if (exception != null) {
                if (exception instanceof CompletionException) {
                    exception = exception.getCause();
                }
                if (exception instanceof SplitHelper.FoundSplitWithoutStartException) {
                    return RecordRepairResult.invalid(primaryKey, "RecordValueSplitError", "Found split record without start");
                }
                if (exception instanceof SplitHelper.FoundSplitOutOfOrderException) {
                    return RecordRepairResult.invalid(primaryKey, "RecordValueSplitError", "Split record segments out of order");
                }
                if (exception instanceof RecordDeserializationException) {
                    return RecordRepairResult.invalid(primaryKey, "RecordValueDeserializeError", "Record cannot be deseralized");
                }
                if (exception instanceof RecordCoreException) {
                    throw (RecordCoreException)exception;
                }
                throw new UnknownValidationException("Unknown exception caught", (Throwable)exception);
            }
            return RecordRepairResult.valid(primaryKey);
        });
    }

    @Override
    public CompletableFuture<RecordRepairResult> repairRecordAsync(@Nonnull RecordRepairResult validationResult) {
        if (validationResult.isValid()) {
            return CompletableFuture.completedFuture(validationResult.withRepair("RepairNotNeeded"));
        }
        switch (validationResult.getErrorCode()) {
            case "RecordValueSplitError": 
            case "RecordValueDeserializeError": {
                this.store.deleteRecordSplits(validationResult.getPrimaryKey(), false, null, this.store.getRecordMetaData());
                if (logger.isDebugEnabled()) {
                    logger.debug(KeyValueLogMessage.of("Record repair: Record deleted", new Object[]{LogMessageKeys.PRIMARY_KEY, validationResult.getPrimaryKey(), LogMessageKeys.CODE, validationResult.getErrorCode()}));
                }
                return CompletableFuture.completedFuture(validationResult.withRepair("RecordValueRecordDeletedRepair"));
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn(KeyValueLogMessage.of("Record repair: Unknown code", new Object[]{LogMessageKeys.PRIMARY_KEY, validationResult.getPrimaryKey(), LogMessageKeys.CODE, validationResult.getErrorCode()}));
        }
        return CompletableFuture.completedFuture(validationResult.withRepair("UnknownCode"));
    }
}

