/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.recordrepair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordRepairResult;
import com.apple.foundationdb.record.provider.foundationdb.recordrepair.RecordValidator;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RecordVersionValidator
implements RecordValidator {
    private static final Logger logger = LoggerFactory.getLogger(RecordVersionValidator.class);
    @Nonnull
    private final FDBRecordStore store;

    public RecordVersionValidator(@Nonnull FDBRecordStore store) {
        this.store = store;
    }

    @Override
    public CompletableFuture<RecordRepairResult> validateRecordAsync(@Nonnull Tuple primaryKey) {
        if (!this.store.getRecordMetaData().isStoreRecordVersions()) {
            return CompletableFuture.completedFuture(RecordRepairResult.valid(primaryKey));
        }
        return this.store.loadRecordAsync(primaryKey).thenApply(rec -> {
            if (rec == null) {
                return RecordRepairResult.invalid(primaryKey, "RecordMissingError", "Record cannot be found");
            }
            if (!rec.hasVersion()) {
                return RecordRepairResult.invalid(primaryKey, "RecordVersionMissingError", "Record version is missing");
            }
            return RecordRepairResult.valid(primaryKey);
        });
    }

    @Override
    public CompletableFuture<RecordRepairResult> repairRecordAsync(@Nonnull RecordRepairResult validationResult) {
        if (validationResult.isValid()) {
            return CompletableFuture.completedFuture(validationResult.withRepair("RepairNotNeeded"));
        }
        switch (validationResult.getErrorCode()) {
            case "RecordMissingError": {
                return CompletableFuture.completedFuture(validationResult.withRepair("RepairNotNeeded"));
            }
            case "RecordVersionMissingError": {
                if (logger.isDebugEnabled()) {
                    logger.debug(KeyValueLogMessage.of("Record repair: Version created", new Object[]{LogMessageKeys.PRIMARY_KEY, validationResult.getPrimaryKey(), LogMessageKeys.CODE, validationResult.getErrorCode()}));
                }
                FDBRecordVersion newVersion = FDBRecordVersion.incomplete(this.store.getContext().claimLocalVersion());
                return ((CompletableFuture)this.store.loadRecordAsync(validationResult.getPrimaryKey()).thenCompose(rec -> this.store.overrideLockSaveRecordAsync((Message)rec.getRecord(), FDBRecordStoreBase.RecordExistenceCheck.NONE, newVersion, FDBRecordStoreBase.VersionstampSaveBehavior.DEFAULT))).thenApply(ignore -> validationResult.withRepair("RecordVersionCreatedRepair"));
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn(KeyValueLogMessage.of("Record version repair: Unknown code", new Object[]{LogMessageKeys.PRIMARY_KEY, validationResult.getPrimaryKey(), LogMessageKeys.CODE, validationResult.getErrorCode()}));
        }
        return CompletableFuture.completedFuture(validationResult.withRepair("UnknownCode"));
    }
}

