/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.recordrepair;

import com.apple.foundationdb.annotation.API;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RepairStatsResults {
    @Nonnull
    private final Map<String, AtomicInteger> stats = new HashMap<String, AtomicInteger>();
    @Nullable
    private Throwable exceptionCaught;

    RepairStatsResults() {
    }

    @Nonnull
    public Map<String, Integer> getStats() {
        return this.stats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AtomicInteger)entry.getValue()).get()));
    }

    @Nullable
    public Throwable getExceptionCaught() {
        return this.exceptionCaught;
    }

    void increment(String code) {
        this.stats.computeIfAbsent(code, ignore -> new AtomicInteger(0)).incrementAndGet();
    }

    void setExceptionCaught(Throwable ex) {
        this.exceptionCaught = ex;
    }
}

