/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.runners;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class ExponentialDelay {
    private static final long MIN_DELAY_MILLIS = 2L;
    private final long maxDelayMillis;
    private long currentDelayMillis;
    private long nextDelayMillis;
    @Nonnull
    private ScheduledExecutorService scheduledExecutor;

    public ExponentialDelay(long initialDelayMillis, long maxDelayMillis, @Nonnull ScheduledExecutorService scheduledExecutor) {
        this.currentDelayMillis = initialDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.nextDelayMillis = this.calculateNextDelayMillis();
        this.scheduledExecutor = scheduledExecutor;
    }

    public CompletableFuture<Void> delay() {
        long delay = this.nextDelayMillis;
        this.currentDelayMillis = Math.max(Math.min(this.currentDelayMillis * 2L, this.maxDelayMillis), 2L);
        this.nextDelayMillis = this.calculateNextDelayMillis();
        return this.delayedFuture(delay);
    }

    private long calculateNextDelayMillis() {
        return (long)(ThreadLocalRandom.current().nextDouble() * (double)this.currentDelayMillis);
    }

    @Nonnull
    @VisibleForTesting
    protected CompletableFuture<Void> delayedFuture(long nextDelayMillis) {
        return MoreAsyncUtil.delayedFuture(nextDelayMillis, TimeUnit.MILLISECONDS, this.scheduledExecutor);
    }

    public long getNextDelayMillis() {
        return this.nextDelayMillis;
    }
}

