/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.runners;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class FutureAutoClose
implements AutoCloseable {
    @Nonnull
    private final List<CompletableFuture<?>> futuresToClose = new ArrayList();
    private boolean closed = false;

    public <T> CompletableFuture<T> newFuture() {
        return this.registerFuture(new CompletableFuture());
    }

    public synchronized <T> CompletableFuture<T> registerFuture(CompletableFuture<T> future) {
        if (this.isClosed()) {
            FDBDatabaseRunner.RunnerClosed exception = new FDBDatabaseRunner.RunnerClosed();
            future.completeExceptionally(exception);
            throw exception;
        }
        this.futuresToClose.removeIf(CompletableFuture::isDone);
        this.futuresToClose.add(future);
        return future;
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            this.closed = true;
            if (!this.futuresToClose.stream().allMatch(CompletableFuture::isDone)) {
                FDBDatabaseRunner.RunnerClosed exception = new FDBDatabaseRunner.RunnerClosed();
                for (CompletableFuture<?> future : this.futuresToClose) {
                    future.completeExceptionally(exception);
                }
            }
            this.futuresToClose.clear();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

