/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.runners;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class TransactionalRunner
implements AutoCloseable {
    @Nonnull
    private final FDBDatabase database;
    @Nonnull
    private final FDBRecordContextConfig.Builder contextConfigBuilder;
    private boolean closed;
    @Nonnull
    private final List<FDBRecordContext> contextsToClose;

    public TransactionalRunner(@Nonnull FDBDatabase database, @Nonnull FDBRecordContextConfig contextConfig) {
        this(database, contextConfig.toBuilder());
    }

    public TransactionalRunner(@Nonnull FDBDatabase database, @Nonnull FDBRecordContextConfig.Builder contextConfigBuilder) {
        this.database = database;
        this.contextConfigBuilder = contextConfigBuilder;
        this.contextsToClose = new ArrayList<FDBRecordContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T> CompletableFuture<T> runAsync(boolean clearWeakReadSemantics, @Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> runnable) {
        FDBRecordContext context = this.openContext(clearWeakReadSemantics);
        boolean returnedFuture = false;
        try {
            CompletionStage future = runnable.apply(context).thenCompose(val -> context.commitAsync().thenApply(vignore -> val));
            returnedFuture = true;
            CompletionStage completionStage = ((CompletableFuture)future).whenComplete((result, exception) -> context.close());
            return completionStage;
        }
        finally {
            if (!returnedFuture) {
                context.close();
            }
        }
    }

    public <T> T run(boolean clearWeakReadSemantics, @Nonnull Function<? super FDBRecordContext, ? extends T> runnable) {
        T result;
        try (FDBRecordContext context = this.openContext(clearWeakReadSemantics);){
            result = runnable.apply(context);
            context.commit();
        }
        return result;
    }

    @Nonnull
    public FDBRecordContext openContext() {
        return this.openContext(true);
    }

    @Nonnull
    private FDBRecordContext openContext(boolean clearWeakReadSemantics) {
        if (this.closed) {
            throw new FDBDatabaseRunner.RunnerClosed();
        }
        FDBRecordContextConfig contextConfig = !clearWeakReadSemantics || this.contextConfigBuilder.getWeakReadSemantics() == null ? this.contextConfigBuilder.build() : this.contextConfigBuilder.copyBuilder().setWeakReadSemantics(null).build();
        FDBRecordContext context = this.database.openContext(contextConfig);
        this.addContextToClose(context);
        return context;
    }

    private synchronized void addContextToClose(@Nonnull FDBRecordContext context) {
        if (this.closed) {
            context.close();
            throw new FDBDatabaseRunner.RunnerClosed();
        }
        this.contextsToClose.removeIf(FDBRecordContext::isClosed);
        this.contextsToClose.add(context);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.contextsToClose.forEach(FDBRecordContext::close);
        this.closed = true;
    }
}

