/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.storestate;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreKeyspace;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.subspace.Subspace;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class FDBRecordStoreStateCacheEntry {
    @Nonnull
    private final SubspaceProvider subspaceProvider;
    @Nonnull
    private final Subspace subspace;
    @Nonnull
    private final RecordStoreState recordStoreState;
    @Nullable
    private final byte[] metaDataVersionStamp;

    private FDBRecordStoreStateCacheEntry(@Nonnull SubspaceProvider subspaceProvider, @Nonnull Subspace subspace, @Nonnull RecordStoreState recordStoreState, @Nullable byte[] metaDataVersionStamp) {
        this.subspaceProvider = subspaceProvider;
        this.subspace = subspace;
        this.recordStoreState = recordStoreState;
        this.metaDataVersionStamp = metaDataVersionStamp;
    }

    @Nonnull
    public RecordStoreState getRecordStoreState() {
        return this.recordStoreState;
    }

    @Nullable
    byte[] getMetaDataVersionStamp() {
        return this.metaDataVersionStamp;
    }

    @Nonnull
    CompletableFuture<Void> handleCachedState(@Nonnull FDBRecordContext context, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        Transaction tr = context.ensureActive();
        tr.addReadConflictKey(this.subspace.pack(FDBRecordStoreKeyspace.STORE_INFO.key()));
        return FDBRecordStore.checkStoreHeader(this.recordStoreState.getStoreHeader(), context, this.subspaceProvider, this.subspace, existenceCheck);
    }

    @Nonnull
    static CompletableFuture<FDBRecordStoreStateCacheEntry> load(@Nonnull FDBRecordStore recordStore, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        CompletableFuture<byte[]> metaDataVersionStampFuture = recordStore.getContext().getMetaDataVersionStampAsync(IsolationLevel.SNAPSHOT);
        return MoreAsyncUtil.combineAndFailFast(recordStore.loadRecordStoreStateAsync(existenceCheck), metaDataVersionStampFuture, (recordStoreState, metaDataVersionStamp) -> new FDBRecordStoreStateCacheEntry(recordStore.getSubspaceProvider(), recordStore.getSubspace(), recordStoreState.toImmutable(), (byte[])metaDataVersionStamp));
    }
}

