/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.storestate;

import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCache;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCacheEntry;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.google.common.cache.Cache;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class MetaDataVersionStampStoreStateCache
implements FDBRecordStoreStateCache {
    @Nonnull
    private final FDBDatabase database;
    @Nonnull
    private final Cache<SubspaceProvider, FDBRecordStoreStateCacheEntry> cache;

    MetaDataVersionStampStoreStateCache(@Nonnull FDBDatabase database, @Nonnull Cache<SubspaceProvider, FDBRecordStoreStateCacheEntry> cache) {
        this.database = database;
        this.cache = cache;
    }

    @Nonnull
    private FDBRecordStoreStateCacheEntry getNewerEntry(@Nonnull FDBRecordStoreStateCacheEntry entry1, @Nonnull FDBRecordStoreStateCacheEntry entry2) {
        if (entry1.getMetaDataVersionStamp() == null) {
            return entry2;
        }
        if (entry2.getMetaDataVersionStamp() == null) {
            return entry1;
        }
        return ByteArrayUtil.compareUnsigned(entry1.getMetaDataVersionStamp(), entry2.getMetaDataVersionStamp()) >= 0 ? entry1 : entry2;
    }

    private void addToCache(@Nonnull SubspaceProvider subspaceProvider, @Nonnull FDBRecordStoreStateCacheEntry cacheEntry) {
        this.cache.asMap().merge(subspaceProvider, cacheEntry, (entry1, entry2) -> {
            FDBRecordStoreStateCacheEntry newerEntry = this.getNewerEntry((FDBRecordStoreStateCacheEntry)entry1, (FDBRecordStoreStateCacheEntry)entry2);
            if (newerEntry.getRecordStoreState().getStoreHeader().getCacheable()) {
                return newerEntry;
            }
            return null;
        });
    }

    private void invalidateOlderEntry(@Nonnull SubspaceProvider subspaceProvider, @Nonnull byte[] metaDataVersionStamp) {
        this.cache.asMap().computeIfPresent(subspaceProvider, (ignore, existingEntry) -> {
            if (existingEntry.getMetaDataVersionStamp() == null || ByteArrayUtil.compareUnsigned(metaDataVersionStamp, existingEntry.getMetaDataVersionStamp()) > 0) {
                return null;
            }
            return existingEntry;
        });
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBRecordStoreStateCacheEntry> get(@Nonnull FDBRecordStore recordStore, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        FDBRecordContext context = recordStore.getContext();
        this.validateContext(context);
        if (context.hasDirtyStoreState()) {
            recordStore.increment(FDBStoreTimer.Counts.STORE_STATE_CACHE_MISS);
            return FDBRecordStoreStateCacheEntry.load(recordStore, existenceCheck);
        }
        SubspaceProvider subspaceProvider = recordStore.getSubspaceProvider();
        FDBRecordStoreStateCacheEntry existingEntry = this.cache.getIfPresent(subspaceProvider);
        if (existingEntry == null) {
            recordStore.increment(FDBStoreTimer.Counts.STORE_STATE_CACHE_MISS);
            return FDBRecordStoreStateCacheEntry.load(recordStore, existenceCheck).whenComplete((cacheEntry, err) -> {
                if (err == null && cacheEntry.getRecordStoreState().getStoreHeader().getCacheable()) {
                    this.addToCache(subspaceProvider, (FDBRecordStoreStateCacheEntry)cacheEntry);
                }
            });
        }
        return recordStore.getContext().getMetaDataVersionStampAsync(IsolationLevel.SNAPSHOT).thenCompose(metaDataVersionStamp -> {
            if (metaDataVersionStamp == null || existingEntry.getMetaDataVersionStamp() == null || ByteArrayUtil.compareUnsigned(metaDataVersionStamp, existingEntry.getMetaDataVersionStamp()) != 0) {
                recordStore.increment(FDBStoreTimer.Counts.STORE_STATE_CACHE_MISS);
                return FDBRecordStoreStateCacheEntry.load(recordStore, existenceCheck).whenComplete((cacheEntry, err) -> {
                    if (err == null && metaDataVersionStamp != null) {
                        if (cacheEntry.getRecordStoreState().getStoreHeader().getCacheable()) {
                            this.addToCache(subspaceProvider, (FDBRecordStoreStateCacheEntry)cacheEntry);
                        } else {
                            this.invalidateOlderEntry(subspaceProvider, (byte[])metaDataVersionStamp);
                        }
                    }
                });
            }
            recordStore.increment(FDBStoreTimer.Counts.STORE_STATE_CACHE_HIT);
            return existingEntry.handleCachedState(context, existenceCheck).thenApply(ignore -> existingEntry);
        });
    }

    @Override
    public void validateDatabase(@Nonnull FDBDatabase database) {
        if (database != this.database) {
            throw new RecordCoreArgumentException("record store state cache used with different database than the one it was initialized with", new Object[0]);
        }
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }
}

