/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.storestate;

import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCache;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCacheEntry;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCacheFactory;
import com.apple.foundationdb.record.provider.foundationdb.storestate.MetaDataVersionStampStoreStateCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class MetaDataVersionStampStoreStateCacheFactory
implements FDBRecordStoreStateCacheFactory {
    public static final long UNLIMITED = Long.MAX_VALUE;
    public static final long DEFAULT_MAX_SIZE = 500L;
    public static final long DEFAULT_EXPIRE_AFTER_ACCESS_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private long maxSize = 500L;
    private long expireAfterAccessMillis = DEFAULT_EXPIRE_AFTER_ACCESS_MILLIS;

    @Override
    @Nonnull
    public FDBRecordStoreStateCache getCache(@Nonnull FDBDatabase database) {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (this.maxSize != Long.MAX_VALUE) {
            cacheBuilder.maximumSize(this.maxSize);
        }
        if (this.expireAfterAccessMillis != Long.MAX_VALUE) {
            cacheBuilder.expireAfterAccess(this.expireAfterAccessMillis, TimeUnit.MILLISECONDS);
        }
        Cache<SubspaceProvider, FDBRecordStoreStateCacheEntry> cache = cacheBuilder.build();
        return new MetaDataVersionStampStoreStateCache(database, cache);
    }

    @Nonnull
    public MetaDataVersionStampStoreStateCacheFactory setExpireAfterAccessMillis(long expireAfterAccessMillis) {
        this.expireAfterAccessMillis = expireAfterAccessMillis;
        return this;
    }

    public long getDefaultExpireAfterAccessMillis() {
        return this.expireAfterAccessMillis;
    }

    @Nonnull
    public MetaDataVersionStampStoreStateCacheFactory setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    @Nonnull
    public static MetaDataVersionStampStoreStateCacheFactory newInstance() {
        return new MetaDataVersionStampStoreStateCacheFactory();
    }
}

