/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.storestate;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.AsyncLoadingCache;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCache;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCacheEntry;
import com.apple.foundationdb.record.util.pair.Pair;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class ReadVersionRecordStoreStateCache
implements FDBRecordStoreStateCache {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadVersionRecordStoreStateCache.class);
    @Nonnull
    private final AsyncLoadingCache<Pair<SubspaceProvider, Long>, FDBRecordStoreStateCacheEntry> cache;
    @Nonnull
    private final FDBDatabase database;

    ReadVersionRecordStoreStateCache(@Nonnull FDBDatabase database, long refreshTimeMillis, long deadlineTimeMillis, long maxSize) {
        this.database = database;
        this.cache = new AsyncLoadingCache(refreshTimeMillis, deadlineTimeMillis, maxSize, database.getScheduledExecutor());
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBRecordStoreStateCacheEntry> get(@Nonnull FDBRecordStore recordStore, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        FDBRecordContext context = recordStore.getContext();
        this.validateContext(context);
        if (context.hasDirtyStoreState()) {
            context.increment(FDBStoreTimer.Counts.STORE_STATE_CACHE_MISS);
            return FDBRecordStoreStateCacheEntry.load(recordStore, existenceCheck);
        }
        return context.getReadVersionAsync().thenCompose(readVersion -> {
            SubspaceProvider subspaceProvider = recordStore.getSubspaceProvider();
            CompletionStage storeStateFuture = this.cache.orElseGet(Pair.of(subspaceProvider, readVersion), () -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(KeyValueLogMessage.of("store state cache miss", new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context), LogMessageKeys.READ_VERSION, readVersion}));
                }
                context.increment(FDBStoreTimer.Counts.STORE_STATE_CACHE_MISS);
                return FDBRecordStoreStateCacheEntry.load(recordStore, existenceCheck);
            }).thenCompose(storeState -> storeState.handleCachedState(context, existenceCheck).thenApply(vignore -> storeState));
            if (context.getTimer() != null && MoreAsyncUtil.isCompletedNormally(storeStateFuture)) {
                context.increment(FDBStoreTimer.Counts.STORE_STATE_CACHE_HIT);
            }
            return storeStateFuture;
        });
    }

    @Override
    public void validateDatabase(@Nonnull FDBDatabase database) {
        if (database != this.database) {
            throw new RecordCoreArgumentException("record store state cache used with different database than the one it was initialized with", new Object[0]);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

