/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.storestate;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCacheFactory;
import com.apple.foundationdb.record.provider.foundationdb.storestate.ReadVersionRecordStoreStateCache;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ReadVersionRecordStoreStateCacheFactory
implements FDBRecordStoreStateCacheFactory {
    public static final long DEFAULT_REFRESH_TIME_MILLIS = 5000L;
    public static final long DEFAULT_DEADLINE_TIME_MILLIS = 5000L;
    public static final long DEFAULT_MAX_SIZE = 1000L;
    private long refreshTimeMillis = 5000L;
    private long deadlineTimeMillis = 5000L;
    private long maxSize = 1000L;

    private ReadVersionRecordStoreStateCacheFactory() {
    }

    @Nonnull
    public ReadVersionRecordStoreStateCacheFactory setRefreshTimeMillis(long refreshTimeMillis) {
        this.refreshTimeMillis = refreshTimeMillis;
        return this;
    }

    @Nonnull
    public ReadVersionRecordStoreStateCacheFactory setDeadlineTimeMillis(long deadlineTimeMillis) {
        this.deadlineTimeMillis = deadlineTimeMillis;
        return this;
    }

    @Nonnull
    public ReadVersionRecordStoreStateCacheFactory setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Override
    @Nonnull
    public ReadVersionRecordStoreStateCache getCache(@Nonnull FDBDatabase database) {
        return new ReadVersionRecordStoreStateCache(database, this.refreshTimeMillis, this.deadlineTimeMillis, this.maxSize);
    }

    @Nonnull
    public static ReadVersionRecordStoreStateCacheFactory newInstance() {
        return new ReadVersionRecordStoreStateCacheFactory();
    }
}

