/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.synchronizedsession;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunnerImpl;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.util.Result;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.synchronizedsession.SynchronizedSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class SynchronizedSessionRunner
implements FDBDatabaseRunner {
    private FDBDatabaseRunnerImpl underlying;
    private SynchronizedSession session;

    public static CompletableFuture<SynchronizedSessionRunner> startSessionAsync(@Nonnull Subspace lockSubspace, long leaseLengthMill, @Nonnull FDBDatabaseRunnerImpl runner) {
        UUID newSessionId = UUID.randomUUID();
        SynchronizedSession session = new SynchronizedSession(lockSubspace, newSessionId, leaseLengthMill);
        return runner.runAsync((? super FDBRecordContext context) -> session.initializeSessionAsync(context.ensureActive()), Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "SynchronizedSessionRunner::startSession", LogMessageKeys.SESSION_ID, session.getSessionId(), LogMessageKeys.SUBSPACE, lockSubspace})).thenApply(vignore -> new SynchronizedSessionRunner(runner, session));
    }

    public static SynchronizedSessionRunner startSession(@Nonnull Subspace lockSubspace, long leaseLengthMill, @Nonnull FDBDatabaseRunnerImpl runner) {
        return runner.asyncToSync(FDBStoreTimer.Waits.WAIT_INIT_SYNC_SESSION, SynchronizedSessionRunner.startSessionAsync(lockSubspace, leaseLengthMill, runner));
    }

    public static SynchronizedSessionRunner joinSession(@Nonnull Subspace lockSubspace, @Nonnull UUID sessionId, long leaseLengthMill, @Nonnull FDBDatabaseRunnerImpl runner) {
        SynchronizedSession session = new SynchronizedSession(lockSubspace, sessionId, leaseLengthMill);
        return new SynchronizedSessionRunner(runner, session);
    }

    private SynchronizedSessionRunner(@Nonnull FDBDatabaseRunnerImpl underlyingRunner, @Nonnull SynchronizedSession session) {
        this.underlying = underlyingRunner;
        this.session = session;
    }

    private <T> Function<FDBRecordContext, T> runInSession(@Nonnull Function<? super FDBRecordContext, ? extends T> work) {
        return context -> {
            context.asyncToSync(FDBStoreTimer.Waits.WAIT_CHECK_SYNC_SESSION, this.session.checkLockAsync(context.ensureActive()));
            Object result = work.apply((FDBRecordContext)context);
            this.session.updateLockSessionLeaseEndTime(context.ensureActive());
            return result;
        };
    }

    private <T> Function<? super FDBRecordContext, CompletableFuture<? extends T>> runInSessionAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> work) {
        return context -> ((CompletableFuture)this.session.checkLockAsync(context.ensureActive()).thenCompose(vignore -> (CompletionStage)work.apply((FDBRecordContext)context))).thenApply(result -> {
            this.session.updateLockSessionLeaseEndTime(context.ensureActive());
            return result;
        });
    }

    public UUID getSessionId() {
        return this.session.getSessionId();
    }

    public CompletableFuture<Void> endSessionAsync() {
        return this.underlying.runAsync((? super FDBRecordContext context) -> this.session.releaseLock(context.ensureActive()), Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "SynchronizedSessionRunner::endSession", LogMessageKeys.SESSION_ID, this.session.getSessionId()}));
    }

    public void endSession() {
        this.underlying.asyncToSync(FDBStoreTimer.Waits.WAIT_END_SYNC_SESSION, this.endSessionAsync());
    }

    public CompletableFuture<Void> endAnySessionAsync() {
        return this.underlying.runAsync((? super FDBRecordContext context) -> {
            this.session.endAnySession(context.ensureActive());
            return AsyncUtil.DONE;
        }, Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "SynchronizedSessionRunner::endAnySession", LogMessageKeys.SESSION_ID, this.session.getSessionId()}));
    }

    public void endAnySession() {
        this.underlying.asyncToSync(FDBStoreTimer.Waits.WAIT_END_SYNC_SESSION, this.endAnySessionAsync());
    }

    @Override
    public <T> T run(@Nonnull Function<? super FDBRecordContext, ? extends T> retriable, @Nullable List<Object> additionalLogMessageKeyValues) {
        return this.underlying.run(this.runInSession(retriable), additionalLogMessageKeyValues);
    }

    @Override
    @Nonnull
    public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable, @Nonnull BiFunction<? super T, Throwable, Result<? extends T, ? extends Throwable>> handlePostTransaction, @Nullable List<Object> additionalLogMessageKeyValues) {
        List<Object> logDetails;
        if (additionalLogMessageKeyValues == null || additionalLogMessageKeyValues.isEmpty()) {
            logDetails = Arrays.asList(new Object[]{LogMessageKeys.SESSION_ID, this.session.getSessionId()});
        } else {
            logDetails = new ArrayList<Object>(additionalLogMessageKeyValues);
            logDetails.add((Object)LogMessageKeys.SESSION_ID);
            logDetails.add(this.session.getSessionId());
        }
        return this.underlying.runAsync(this.runInSessionAsync(retriable), handlePostTransaction, logDetails);
    }

    @Override
    @Nonnull
    public FDBDatabase getDatabase() {
        return this.underlying.getDatabase();
    }

    @Override
    public FDBRecordContextConfig.Builder getContextConfigBuilder() {
        return this.underlying.getContextConfigBuilder();
    }

    @Override
    public void setContextConfigBuilder(FDBRecordContextConfig.Builder contextConfigBuilder) {
        this.underlying.setContextConfigBuilder(contextConfigBuilder);
    }

    @Override
    public Executor getExecutor() {
        return this.underlying.getExecutor();
    }

    @Override
    public int getMaxAttempts() {
        return this.underlying.getMaxAttempts();
    }

    @Override
    public void setMaxAttempts(int maxAttempts) {
        this.underlying.setMaxAttempts(maxAttempts);
    }

    @Override
    public long getMinDelayMillis() {
        return this.underlying.getMinDelayMillis();
    }

    @Override
    public long getMaxDelayMillis() {
        return this.underlying.getMaxDelayMillis();
    }

    @Override
    public void setMaxDelayMillis(long maxDelayMillis) {
        this.underlying.setMaxDelayMillis(maxDelayMillis);
    }

    @Override
    public long getInitialDelayMillis() {
        return this.underlying.getInitialDelayMillis();
    }

    @Override
    public void setInitialDelayMillis(long initialDelayMillis) {
        this.underlying.setInitialDelayMillis(initialDelayMillis);
    }

    @Override
    @Nonnull
    public FDBRecordContext openContext() {
        return this.underlying.openContext();
    }

    @Override
    @Nullable
    public <T> T asyncToSync(StoreTimer.Wait event, @Nonnull CompletableFuture<T> async) {
        return this.underlying.asyncToSync(event, async);
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public CompletableFuture<SynchronizedSessionRunner> startSynchronizedSessionAsync(@Nonnull Subspace lockSubspace, long leaseLengthMillis) {
        return this.underlying.startSynchronizedSessionAsync(lockSubspace, leaseLengthMillis);
    }

    @Override
    public SynchronizedSessionRunner startSynchronizedSession(@Nonnull Subspace lockSubspace, long leaseLengthMillis) {
        return this.underlying.startSynchronizedSession(lockSubspace, leaseLengthMillis);
    }

    @Override
    public SynchronizedSessionRunner joinSynchronizedSession(@Nonnull Subspace lockSubspace, @Nonnull UUID sessionId, long leaseLengthMillis) {
        return this.underlying.joinSynchronizedSession(lockSubspace, sessionId, leaseLengthMillis);
    }
}

