/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query;

import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.BooleanComponent;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class BoundRecordQuery {
    @Nonnull
    private final RecordStoreState recordStoreState;
    @Nonnull
    private final RecordQuery recordQuery;
    @Nonnull
    private final Supplier<Set<String>> parametersSupplier;
    @Nonnull
    private final ParameterRelationshipGraph parameterRelationshipGraph;
    @Nonnull
    private final Supplier<Integer> hashCodeSupplier;

    public BoundRecordQuery(@Nonnull RecordStoreState recordStoreState, @Nonnull RecordQuery recordQuery) {
        this(recordStoreState, recordQuery, ParameterRelationshipGraph.empty());
    }

    public BoundRecordQuery(@Nonnull RecordStoreState recordStoreState, @Nonnull RecordQuery recordQuery, @Nonnull Bindings perBoundParameterBindings) {
        this(recordStoreState, recordQuery, ParameterRelationshipGraph.fromRecordQueryAndBindings(recordQuery, perBoundParameterBindings));
    }

    private BoundRecordQuery(@Nonnull RecordStoreState recordStoreState, @Nonnull RecordQuery recordQuery, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        this.recordStoreState = recordStoreState;
        this.recordQuery = recordQuery;
        this.parameterRelationshipGraph = parameterRelationshipGraph;
        this.parametersSupplier = Suppliers.memoize(this::computeParameters);
        this.hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
    }

    @Nonnull
    public RecordStoreState getRecordStoreState() {
        return this.recordStoreState;
    }

    @Nonnull
    public RecordQuery getRecordQuery() {
        return this.recordQuery;
    }

    public Set<String> getParameters() {
        return this.parametersSupplier.get();
    }

    @Nonnull
    public ParameterRelationshipGraph getParameterRelationshipGraph() {
        return this.parameterRelationshipGraph;
    }

    @Nonnull
    public RecordQueryPlan plan(@Nonnull FDBRecordStore store) {
        return store.planQuery(this.getRecordQuery(), this.parameterRelationshipGraph);
    }

    public boolean isCompatible(@Nonnull FDBRecordStore store, @Nonnull Bindings parameterBindings) {
        if (!store.getRecordStoreState().compatibleWith(this.recordStoreState)) {
            return false;
        }
        return this.parameterRelationshipGraph.isCompatible(parameterBindings);
    }

    public int hashCode() {
        return this.hashCodeSupplier.get();
    }

    private int computeHashCode() {
        HashFunction hashFunction = Hashing.murmur3_32_fixed();
        Hasher hasher = hashFunction.newHasher();
        hasher.putInt(this.recordQuery.hashCode());
        hasher.putInt(this.recordStoreState.getIndexStates().hashCode());
        RecordMetaDataProto.DataStoreInfo storeHeader = this.recordStoreState.getStoreHeader();
        hasher.putInt(storeHeader.getMetaDataversion());
        hasher.putInt(storeHeader.getUserVersion());
        hasher.putInt(this.getParameters().hashCode());
        hasher.putInt(this.parameterRelationshipGraph.hashCode());
        return hasher.hash().asInt();
    }

    @Nonnull
    private Set<String> computeParameters() {
        QueryComponent filter = this.recordQuery.getFilter();
        if (filter != null) {
            return BooleanComponent.groupedComparisons(filter).flatMap(pair -> ((List)pair.getRight()).stream()).map(Comparisons.ComparisonWithParameter::getParameter).collect(ImmutableSet.toImmutableSet());
        }
        return ImmutableSet.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundRecordQuery)) {
            return false;
        }
        BoundRecordQuery other = (BoundRecordQuery)o;
        if (!this.getRecordQuery().equals(other.getRecordQuery())) {
            return false;
        }
        if (!this.getParameters().equals(other.getParameters())) {
            return false;
        }
        RecordStoreState otherRecordStoreState = other.getRecordStoreState();
        RecordMetaDataProto.DataStoreInfo storeHeader = this.recordStoreState.getStoreHeader();
        RecordMetaDataProto.DataStoreInfo otherStoreHeader = otherRecordStoreState.getStoreHeader();
        if (storeHeader.getMetaDataversion() != otherStoreHeader.getMetaDataversion()) {
            return false;
        }
        if (storeHeader.getUserVersion() != otherStoreHeader.getUserVersion()) {
            return false;
        }
        if (!this.recordStoreState.compatibleWith(otherRecordStoreState)) {
            return false;
        }
        return this.parameterRelationshipGraph.equals(other.getParameterRelationshipGraph());
    }

    public String toString() {
        return this.recordQuery.toString();
    }
}

