/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.expressions.BooleanComponent;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class ParameterRelationshipGraph {
    private static final ParameterRelationshipGraph UNBOUND = ParameterRelationshipGraph.empty();
    @Nonnull
    private final ImmutableNetwork<String, Relationship> network;

    private ParameterRelationshipGraph(@Nonnull Network<String, Relationship> network) {
        this.network = ImmutableNetwork.copyOf(network);
    }

    public boolean isUnbound() {
        return this == ParameterRelationshipGraph.unbound();
    }

    public int hashCode() {
        return this.network.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterRelationshipGraph)) {
            return false;
        }
        ParameterRelationshipGraph that = (ParameterRelationshipGraph)o;
        return this.network.equals(that.network);
    }

    @Nonnull
    public static ParameterRelationshipGraph fromRecordQueryAndBindings(@Nonnull RecordQuery recordQuery, @Nonnull Bindings preBoundParameterBindings) {
        QueryComponent filter = recordQuery.getFilter();
        ImmutableNetwork.Builder networkBuilder = NetworkBuilder.directed().allowsSelfLoops(true).allowsParallelEdges(true).immutable();
        if (filter != null) {
            BooleanComponent.groupedComparisons(filter).flatMap(entry -> StreamSupport.stream(CrossProduct.crossProduct(ImmutableList.of((List)entry.getValue(), (List)entry.getValue())).spliterator(), false)).forEach(list -> {
                Object rightComparand;
                Object leftComparand;
                Comparisons.ComparisonWithParameter left = (Comparisons.ComparisonWithParameter)list.get(0);
                Comparisons.ComparisonWithParameter right = (Comparisons.ComparisonWithParameter)list.get(1);
                if (left.getParameter().equals(right.getParameter())) {
                    Relationship.addEdge(networkBuilder, RelationshipType.EQUALS, left.getParameter(), right.getParameter());
                    Relationship.addEdge(networkBuilder, RelationshipType.EQUALS, right.getParameter(), left.getParameter());
                } else if (preBoundParameterBindings.containsBinding(left.getParameter()) && preBoundParameterBindings.containsBinding(right.getParameter()) && Objects.equals(leftComparand = preBoundParameterBindings.get(left.getParameter()), rightComparand = preBoundParameterBindings.get(right.getParameter()))) {
                    Relationship.addEdge(networkBuilder, RelationshipType.EQUALS, left.getParameter(), right.getParameter());
                    Relationship.addEdge(networkBuilder, RelationshipType.EQUALS, right.getParameter(), left.getParameter());
                }
            });
        }
        return new ParameterRelationshipGraph(networkBuilder.build());
    }

    @Nonnull
    public static ParameterRelationshipGraph empty() {
        return new ParameterRelationshipGraph(NetworkBuilder.directed().allowsSelfLoops(true).allowsParallelEdges(true).immutable().build());
    }

    public static ParameterRelationshipGraph unbound() {
        return UNBOUND;
    }

    @Nonnull
    public Set<String> getRelatedParameters(@Nonnull String parameter, @Nonnull RelationshipType relationshipType) {
        return this.network.outEdges((Object)parameter).stream().filter(relationship -> relationship.getRelationshipKind() == relationshipType).map(relationship -> (String)this.network.incidentNodes(relationship).nodeV()).collect(ImmutableSet.toImmutableSet());
    }

    public boolean containsParameter(@Nonnull String parameter) {
        return this.network.nodes().contains(parameter);
    }

    public boolean isCompatible(@Nonnull Bindings parameterBindings) {
        return this.network.edges().stream().allMatch(edge -> {
            String parameter1 = edge.getParameter1();
            String parameter2 = edge.getParameter2();
            if (edge.getRelationshipKind() == RelationshipType.EQUALS && !parameter1.equals(parameter2)) {
                if (!parameterBindings.containsBinding(parameter1) || !parameterBindings.containsBinding(parameter2)) {
                    return false;
                }
                return Objects.equals(parameterBindings.get(parameter1), parameterBindings.get(parameter2));
            }
            return true;
        });
    }

    public static enum RelationshipType {
        EQUALS,
        NOT_EQUALS;

    }

    public static class Relationship {
        @Nonnull
        private final RelationshipType relationshipType;
        @Nonnull
        private final String parameter1;
        @Nonnull
        private final String parameter2;

        public Relationship(@Nonnull RelationshipType relationshipType, @Nonnull String parameter1, @Nonnull String parameter2) {
            this.relationshipType = relationshipType;
            this.parameter1 = parameter1;
            this.parameter2 = parameter2;
        }

        @Nonnull
        public RelationshipType getRelationshipKind() {
            return this.relationshipType;
        }

        @Nonnull
        public String getParameter1() {
            return this.parameter1;
        }

        @Nonnull
        public String getParameter2() {
            return this.parameter2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Relationship)) {
                return false;
            }
            Relationship that = (Relationship)o;
            return this.relationshipType == that.relationshipType && this.getParameter1().equals(that.getParameter1()) && this.getParameter2().equals(that.getParameter2());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.relationshipType, this.getParameter1(), this.getParameter2()});
        }

        private static void addEdge(@Nonnull ImmutableNetwork.Builder<String, Relationship> networkBuilder, @Nonnull RelationshipType relationshipType, @Nonnull String parameter1, @Nonnull String parameter2) {
            networkBuilder.addEdge(parameter1, parameter2, new Relationship(relationshipType, parameter1, parameter2));
        }

        public String toString() {
            return this.getParameter1() + " --" + this.getRelationshipKind().name() + "--> " + this.getParameter2();
        }
    }
}

